/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface EmployeeJpaRepository
extends EmployeeRepository,
JpaRepository<EmployeeEntity, String> {
    @Query(value="select e from EmployeeEntity e where e.organization.id=?1 and e.id in (?2)")
    public Collection<EmployeeEntity> getByIds(String var1, Collection<String> var2);

    @Query(value="select count(e) from EmployeeEntity e where e.organization.id=?1 and e.superior.id=?2 ")
    public long countChildById(String var1, String var2);

    @Modifying
    @Query(value="update EmployeeEntity set superior.id=?3 where organization.id=?1 and superior.id=?2")
    public int replaceSuperior(String var1, String var2, String var3);

    @Query(value="select e from EmployeeEntity e where e.organization.id=?1 and e.id=?2")
    public EmployeeEntity getByOrganIdAndId(String var1, String var2);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.selectedCredential.number in (?2)")
    public Collection<EmployeeEntity> getByIdNums(String var1, Collection<String> var2);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.telephone in (?2)")
    public Collection<EmployeeEntity> getByTelephones(String var1, Collection<String> var2);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where t.selectedCredential.number in (?1)")
    public List<EmployeeEntity> getAllByIdNums(Collection<String> var1);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where t.telephone in (?1)")
    public List<EmployeeEntity> getAllByTelephones(Collection<String> var1);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where u.occupationType=com.bcxin.Infrastructures.enums.OccupationType.SecurityGuard and t.selectedCredential.number in (?1) and u.status <> 1")
    public List<EmployeeEntity> getSecurityGuardByIdNums(Collection<String> var1);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.telephone=?2")
    public EmployeeEntity getByTelephone(String var1, String var2);

    @Query(value="select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.selectedCredential.number=?2")
    public EmployeeEntity getByIdNum(String var1, String var2);

    @Query(value="select e from EmployeeEntity e where e.tenantUser.id=?1 and e.occupationType=com.bcxin.Infrastructures.enums.OccupationType.SecurityGuard")
    public Collection<EmployeeEntity> getSecurityGuardsByTenantUserId(String var1);

    @Query(value="select e from EmployeeEntity e where e.organization.id=?1 and e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and position in ('\u7cfb\u7edf\u7ba1\u7406\u5458','\u603b\u7ecf\u7406','\u526f\u603b\u7ecf\u7406')")
    public Collection<EmployeeEntity> getRegisterEmployeeByOrganId(String var1);

    @Query(value="select e from EmployeeEntity e where e.status<>com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and e.organization.id=?1")
    public Collection<EmployeeEntity> getAllByOrganId(String var1);

    @Query(value="select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.False and e.id in (?1)")
    public Collection<String> queryIdByNotIsSure(Collection<String> var1);

    @Query(value="select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.True  and e.id not in (?1)")
    public Collection<String> queryIdByFailureIsSure(Collection<String> var1);

    @Query(value="select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.True  and e.id in (?1)")
    public Collection<String> queryIdBySuccessIsSure(Collection<String> var1);

    @Modifying
    @Transactional
    @Query(value="update EmployeeEntity e set e.insure = ?2 where e.id in (?1)")
    public void updateIsSureStatus(Collection<String> var1, TrueFalseStatus var2);

    @Modifying
    @Query(value="update DepartmentEmployeeRelationEntity e set e.departmentIndexTree = ?2 where e.department.id = ?1")
    public void updateRelativeDepartmentIndexCodeByIds(String var1, String var2);

    @Query(value="select e.id from EmployeeEntity e where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob  and e.id in (select de.employee.id from DepartmentEmployeeRelationEntity de where de.departmentIndexTree like ?1)")
    public List<String> findIdListByDepartmentIndexTree(String var1);

    @Query(value="select e from EmployeeEntity e where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob  and e.organization.id=?1 and e.domainAdmin = com.bcxin.Infrastructures.enums.TrueFalseStatus.True ")
    public List<EmployeeEntity> getAdminByOrganId(String var1);

    @Query(value="select 1 from EmployeeEntity e where e.organization.id=?1 and e.tenantUser.id=?2 ")
    public boolean checkIfExists(String var1, String var2);

    @Query(value="select e.id from EmployeeEntity e where e.organization.id=?1 and e.tenantUser.id=?2 ")
    public String getByOrgIdAndUserId(String var1, String var2);

    @Query(value="select e from EmployeeEntity e where e.organization.id=?1 and exists (select 1 from TenantUserCredentialsEntity c where c.number=?2 and c.tenantUser.id=e.tenantUser.id )")
    public EmployeeEntity getIdByOrgIdAndIdCard(String var1, String var2);

    @Query(value="select e.tenantUser.name from EmployeeEntity e where e.status = com.bcxin.Infrastructures.enums.EmploymentStatus.OnJob  and e.superior.id in (?1)")
    public List<String> findJuniorNameListBySuperiorId(Collection<String> var1);
}

