/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.readers;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.CerType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonResourceType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.api.interfaces.identities.requests.GetCredentialRequest;
import com.bcxin.api.interfaces.tenants.criterias.ContractCriteria;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeLeaveCriteria;
import com.bcxin.api.interfaces.tenants.criterias.TenantUserRegionCriteria;
import com.bcxin.api.interfaces.tenants.requests.operatelog.SearchOperateLogRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.IMContactCriteria;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.QueryCredentialRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateTenantUserRealNameRequest;
import com.bcxin.api.interfaces.tenants.responses.CompanyCredentialResponse;
import com.bcxin.api.interfaces.tenants.responses.CredentialResponse;
import com.bcxin.api.interfaces.tenants.responses.CurrentCredentialResponse;
import com.bcxin.api.interfaces.tenants.responses.OperateLogResponse;
import com.bcxin.api.interfaces.tenants.responses.QualificationCredentialResponse;
import com.bcxin.tenant.domain.dto.EmployeeOccupationTypeValidationBasicDto;
import com.bcxin.tenant.domain.dto.EmployeeTenantUserIdNumDto;
import com.bcxin.tenant.domain.dto.TenantUserTelephoneCredentialDto;
import com.bcxin.tenant.domain.entities.CompanyCredentialViewEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.EmployeeExportViewEntity;
import com.bcxin.tenant.domain.entities.IdentityUserpasswordEntity;
import com.bcxin.tenant.domain.entities.OperateLogEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialDetailsEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.criterias.DepartAdminCriteria;
import com.bcxin.tenant.domain.readers.criterias.EmployeeContractCriteria;
import com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria;
import com.bcxin.tenant.domain.readers.criterias.EmployeeRecordCriteria;
import com.bcxin.tenant.domain.readers.criterias.InvitedToJoinQueuesCriteria;
import com.bcxin.tenant.domain.readers.criterias.LeaveEmployeeCriteria;
import com.bcxin.tenant.domain.readers.criterias.MyExternalMemberRecordCriteria;
import com.bcxin.tenant.domain.readers.criterias.OrganizationAdminCriteria;
import com.bcxin.tenant.domain.readers.criterias.OrganizationCriteria;
import com.bcxin.tenant.domain.readers.criterias.UserAppealsCriteria;
import com.bcxin.tenant.domain.readers.dtos.BatchEmployeeValidationDto;
import com.bcxin.tenant.domain.readers.dtos.CompanyDto;
import com.bcxin.tenant.domain.readers.dtos.ContractDto;
import com.bcxin.tenant.domain.readers.dtos.DepartAdminDto;
import com.bcxin.tenant.domain.readers.dtos.DepartDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeBasicDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeCompositeDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeConDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeConditionDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeContractDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeDepartIdDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeDetailDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeLeaveDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeRecordDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeReportDto;
import com.bcxin.tenant.domain.readers.dtos.EmployeeStatusDto;
import com.bcxin.tenant.domain.readers.dtos.ExternalGroupDto;
import com.bcxin.tenant.domain.readers.dtos.ImContactDto;
import com.bcxin.tenant.domain.readers.dtos.InviteUserDto;
import com.bcxin.tenant.domain.readers.dtos.InvitedToJoinQueuesDto;
import com.bcxin.tenant.domain.readers.dtos.LoginUserDto;
import com.bcxin.tenant.domain.readers.dtos.MyExternalMemberRecordDTO;
import com.bcxin.tenant.domain.readers.dtos.MyImContactDto;
import com.bcxin.tenant.domain.readers.dtos.MyImDepartDto;
import com.bcxin.tenant.domain.readers.dtos.MyOrganizationProfileDto;
import com.bcxin.tenant.domain.readers.dtos.MyRegistrationOrganizationDto;
import com.bcxin.tenant.domain.readers.dtos.MyTeamDto;
import com.bcxin.tenant.domain.readers.dtos.OrganizationAdminDto;
import com.bcxin.tenant.domain.readers.dtos.OrganizationDto;
import com.bcxin.tenant.domain.readers.dtos.TenantUserCredentialsDto;
import com.bcxin.tenant.domain.readers.dtos.TenantUserDto;
import com.bcxin.tenant.domain.readers.dtos.UserAppealDto;
import com.bcxin.tenant.domain.readers.dtos.UserCredentialDto;
import com.bcxin.tenant.domain.readers.dtos.UserOrganBasicDto;
import com.bcxin.tenant.domain.readers.dtos.UserRegionDto;
import com.bcxin.tenant.domain.readers.tmps.EmployeeDepartData;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import com.bcxin.tenant.domain.repositories.criterias.ExternalMemberSearchCriteria;
import com.bcxin.tenant.domain.repositories.dtos.ContractExportDto;
import com.bcxin.tenant.domain.repositories.dtos.ContractReportDto;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentAdminExportDto;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentDto;
import com.bcxin.tenant.domain.repositories.dtos.ExternalMemberDTO;
import com.bcxin.tenant.domain.repositories.dtos.LeaveEmployeeExportDto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationExportDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartAdminReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartmentReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.EmployeeContactReadDto;
import com.bcxin.tenant.domain.repository.translates.DataTranslate;
import com.bcxin.tenant.domain.snapshots.DepartImAllowedDepartSnapshot;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class TenantDbReaderImpl
implements TenantDbReader {
    private static final Logger log = LoggerFactory.getLogger(TenantDbReaderImpl.class);
    private final EntityManager entityManager;
    private final JsonProvider jsonProvider;
    private final DataTranslate dataTranslate;
    private final TenantUserRepository tenantUserRepository;
    private final OrganizationRepository organizationRepository;

    public TenantDbReaderImpl(EntityManager entityManager, JsonProvider jsonProvider, DataTranslate dataTranslate, TenantUserRepository tenantUserRepository, OrganizationRepository organizationRepository) {
        this.entityManager = entityManager;
        this.jsonProvider = jsonProvider;
        this.dataTranslate = dataTranslate;
        this.tenantUserRepository = tenantUserRepository;
        this.organizationRepository = organizationRepository;
    }

    public Pageable<EmployeeDto> find(String organizationId, EmployeeCriteria criteria) {
        LocalDate now;
        String exists;
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            String keyword = criteria.getKeyword();
            String substrings = keyword.substring(0, 1);
            Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
            Matcher m = p.matcher(substrings);
            if (m.find()) {
                sb.append(" and (t.name like :keyword)");
                parameters.put("keyword", criteria.getKeyword() + "%");
            } else if (keyword.length() >= 12) {
                sb.append(" and (s.number like :keyword)");
                parameters.put("keyword", criteria.getKeyword() + "%");
            } else {
                sb.append(" and (t.telephone like :keyword or s.number like :keyword)");
                parameters.put("keyword", criteria.getKeyword() + "%");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCredentialTypes())) {
            sb.append(" and s.credentialType in :credentialType");
            parameters.put("credentialType", criteria.getCredentialTypes());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getAuthenticatedStatuses())) {
            sb.append(" and t.authenticateStatus in :authenticateStatus");
            parameters.put("authenticateStatus", criteria.getAuthenticatedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCheckedStatuses())) {
            sb.append(" and t.checkedStatus in :checkedStatus");
            parameters.put("checkedStatus", criteria.getCheckedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getOccupationTypes())) {
            sb.append(" and e.occupationType in :occupationType");
            parameters.put("occupationType", criteria.getOccupationTypes());
        }
        if (criteria.getHiredDate() != null) {
            sb.append(" and e.hiredDate=:hiredDate ");
            parameters.put("hiredDate", criteria.getHiredDate());
        }
        if (StringUtils.hasLength((String)criteria.getPosition())) {
            sb.append(" and e.position = :position ");
            parameters.put("position", criteria.getPosition());
        }
        if (criteria.getStartDate() != null) {
            sb.append(" and e.hiredDate >=:startDate ");
            parameters.put("startDate", criteria.getStartDate());
        }
        if (criteria.getEndDate() != null) {
            sb.append(" and e.hiredDate <=:endDate ");
            parameters.put("endDate", criteria.getEndDate());
        }
        if ("1".equals(criteria.getContractStatus())) {
            sb.append(" and exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        if ("0".equals(criteria.getContractStatus())) {
            sb.append(" and not exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
        String areaCode = "EMPTY";
        if (organizationOptional.isPresent()) {
            OrganizationEntity organizationEntity = (OrganizationEntity)organizationOptional.get();
            areaCode = organizationEntity.getSuperviseRegionCode();
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getCerStatus())) {
            exists = " ";
            if ("0".equals(criteria.getCerStatus())) {
                exists = " not ";
            }
            sb.append(" and " + exists + " exists(select tucd from  TenantUserCredentialDetailsEntity tucd where t.id=tucd.tenantUserId  and tucd.state = '1' and tucd.active = true and tucd.certificateType='1'");
            if (!AuthUtil.isUnDistinguishArea()) {
                sb.append(" and tucd.areaCode like :areaCode ");
                parameters.put("areaCode", AuthUtil.getShortAreaCode((String)areaCode) + "%");
            }
            sb.append(") ");
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getGradeCerStatus()) || CollUtil.isNotEmpty((Collection)criteria.getLevel())) {
            exists = " ";
            if ("0".equals(criteria.getCerStatus())) {
                exists = " not ";
            }
            sb.append(" and " + exists + " exists(select tucd from  TenantUserCredentialDetailsEntity tucd  where t.id=tucd.tenantUserId and  tucd.state = '1' and tucd.active = true and tucd.certificateType='2'");
            if (StringUtils.hasLength((String)areaCode)) {
                sb.append(" and tucd.areaCode like :areaCode ");
                parameters.put("areaCode", AuthUtil.getShortAreaCode((String)areaCode) + "%");
            }
            if (CollUtil.isNotEmpty((Collection)criteria.getLevel())) {
                sb.append(" and tucd.appraisalGrade in :gradeLevels");
                Collection level = criteria.getLevel();
                ArrayList<String> gradeLevels = new ArrayList<String>();
                for (Integer i2 : level) {
                    gradeLevels.add(i2.toString());
                }
                parameters.put("gradeLevels", gradeLevels);
            }
            sb.append(") ");
        }
        if (criteria.getBeginAge() != null) {
            now = LocalDate.now();
            LocalDate bTime = now.minus(criteria.getBeginAge().intValue(), ChronoUnit.YEARS);
            sb.append(" and  t.birthdate <= :bTime");
            parameters.put("bTime", Date.from(bTime.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (criteria.getEndAge() != null) {
            now = LocalDate.now();
            LocalDate eTime = now.minus(criteria.getEndAge() + 1, ChronoUnit.YEARS);
            sb.append(" and  t.birthdate >= :eTime");
            parameters.put("eTime", Date.from(eTime.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (criteria.getSex() != null) {
            sb.append("  and  t.sex = :sex");
            parameters.put("sex", criteria.getSex());
        }
        if (criteria.getInsure() != null) {
            if (criteria.getInsure().equals((Object)TrueFalseStatus.False)) {
                sb.append("  and  (e.insure = :insure or e.insure is null)");
            } else {
                sb.append("  and  e.insure = :insure");
            }
            parameters.put("insure", criteria.getInsure());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getBackgroundScreeningStatus())) {
            sb.append(" and t.backgroundScreeningStatus in :backgroundScreeningStatus");
            parameters.put("backgroundScreeningStatus", criteria.getBackgroundScreeningStatus());
        }
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.EmployeeDto(t.id,e.organization.name,e.id,t.name,t.telephone,s.credentialType,e.occupationType, s.number,t.checkedStatus,t.userType,t.authenticateStatus,e.hiredDate,e.position,t.authenticatedResult,t.sex,t.birthdate,t.nation,t.education,t.politicsStatus,t.householdType,t.militaryStatus,t.nativePlace,t.maritalStatus,t.stature,t.emergencyContact,t.emergencyPhone,t.licenseLevel,t.backgroundScreeningStatus,e.insure,est.name,e.positiveDate,s.validDateFrom,s.validDateTo,s.address,e.createdTime,e.domainAdmin,e.organization.id,e.personStatus,e.probation,e.planPositiveDate,t.placeOfNow,e.hiredOperator,t.lastCheckedStatusTime)  from EmployeeEntity e join e.tenantUser t left join t.selectedCredential s  left join e.superior es left join es.tenantUser est  where e.status!=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob ";
        String cString = "select count(1) from EmployeeEntity e join e.tenantUser t left join t.selectedCredential s   where e.status!=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob ";
        if (StrUtil.isNotEmpty((CharSequence)organizationId)) {
            qString = qString + " and e.organization.id=:organId ";
            cString = cString + " and e.organization.id=:organId ";
            parameters.put("organId", organizationId);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getOrganName())) {
            qString = qString + " and e.organization.name like '%:organName%' ";
            cString = cString + " and e.organization.name like '%:organName%' ";
            parameters.put("organName", criteria.getOrganName());
        }
        qString = qString + sb;
        cString = cString + sb;
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            if (userContext.get().isDepartAdmin()) {
                String deptAdminSql = this.getDeptAdminSql(criteria.getTreeCodes());
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    cString = cString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    parameters.put("departmentIds", criteria.getDepartIds());
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (e.id=:selfEmployeeId or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
                    cString = cString + " and (e.id=:selfEmployeeId or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + "))";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            } else {
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    cString = cString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (e.id=:selfEmployeeId)";
                    cString = cString + " and (e.id=:selfEmployeeId)";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            }
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=e.id and de.department.id in (:departmentIds))";
            cString = cString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=e.id and de.department.id in (:departmentIds))";
            parameters.put("departmentIds", criteria.getDepartIds());
        }
        qString = qString + " order by e.hiredDate desc ";
        TypedQuery employeeTypedQuery = this.entityManager.createQuery(qString, EmployeeDto.class);
        TypedQuery totalCountQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            employeeTypedQuery = employeeTypedQuery.setParameter(key, parameters.get(key));
            totalCountQuery = totalCountQuery.setParameter(key, parameters.get(key));
        }
        long totalCount = (Long)totalCountQuery.getSingleResult();
        List result = null;
        if (totalCount > 0L) {
            result = employeeTypedQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
            Collection employeeIds = result.stream().map(ii -> ii.getId()).collect(Collectors.toList());
            if (employeeIds.size() > 0) {
                List<TenantUserCredentialDetailsEntity> tenantUserCredentialDetailsEntities;
                String finalAreaCode;
                List<TenantUserCredentialDetailsEntity> cerDetailList;
                Map<String, List<TenantUserCredentialDetailsEntity>> cerDetailMap;
                TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName, de.leaderType as departLeader) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
                mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
                List departDtos = mapTypedQuery.getResultList();
                Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
                for (EmployeeDto rt2 : result) {
                    List<DepartDto> departDtoList = departMap.get(rt2.getId());
                    if (departDtoList == null) continue;
                    Optional<DepartDto> leaderDept = departDtoList.stream().filter(dto -> dto.getDepartLeader() != null && dto.getDepartLeader() != false).findFirst();
                    rt2.assignDepart(departDtoList.stream().map(DepartDto::getDepartId).collect(Collectors.joining(", ")), departDtoList.stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")), (Boolean)leaderDept.map(DepartDto::getDepartLeader).orElse(null));
                }
                TypedQuery contractDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.ContractDto(de.employee.id as employeeId, de.id as contractId, de.endDate as endDate) from ContractEntity de where de.employee.id in (:employeeIds) and de.status = com.bcxin.Infrastructures.enums.ValidStatus.Valid and CURDATE() between de.beginDate and de.endDate ", ContractDto.class);
                contractDtoTypedQuery.setParameter("employeeIds", (Object)employeeIds);
                List contractDtos = contractDtoTypedQuery.getResultList();
                Map<String, List<ContractDto>> contractMap = contractDtos.stream().collect(Collectors.groupingBy(ContractDto::getEmployeeId));
                result.forEach(rt -> {
                    if (contractMap.get(rt.getId()) != null) {
                        List contractDtoList = (List)contractMap.get(rt.getId());
                        contractDtoList = contractDtoList.stream().sorted(Comparator.comparing(ContractDto::getValidDateTo)).collect(Collectors.toList());
                        rt.assignContractStatus(true, ((ContractDto)contractDtoList.get(contractDtoList.size() - 1)).getValidDateTo());
                    } else {
                        rt.assignContractStatus(false, null);
                    }
                });
                mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentAdminEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
                mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
                departDtos = mapTypedQuery.getResultList();
                departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
                for (EmployeeDto rt3 : result) {
                    if (departMap.get(rt3.getId()) == null) continue;
                    rt3.assignAdminDepart(departMap.get(rt3.getId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")));
                }
                List<TenantUserCredentialDetailsEntity> cerDetails = this.getCerDetailsByUserIds(CerType.Qualification.getTypeValue(), result.stream().map(EmployeeDto::getUserId).collect(Collectors.toList()));
                List<TenantUserCredentialDetailsEntity> gradeDetails = this.getCerDetailsByUserIds(CerType.Grade.getTypeValue(), result.stream().map(EmployeeDto::getUserId).collect(Collectors.toList()));
                if (cerDetails != null && cerDetails.size() > 0) {
                    cerDetailMap = cerDetails.stream().collect(Collectors.groupingBy(i -> i.getTenantUserId()));
                    for (EmployeeDto rt4 : result) {
                        cerDetailList = cerDetailMap.get(rt4.getUserId());
                        if (cerDetailList == null) continue;
                        finalAreaCode = areaCode;
                        for (TenantUserCredentialDetailsEntity tenantUserCredentialDetailsEntity : cerDetailList) {
                            if (!StrUtil.isNotEmpty((CharSequence)tenantUserCredentialDetailsEntity.getAreaCode()) || tenantUserCredentialDetailsEntity.getAreaCode().length() < 2) continue;
                            if (AuthUtil.getShortAreaCode((String)tenantUserCredentialDetailsEntity.getAreaCode()).equals(AuthUtil.getShortAreaCode((String)finalAreaCode))) {
                                rt4.setCerStatus(true);
                                tenantUserCredentialDetailsEntities = cerDetailMap.get(rt4.getUserId());
                                for (TenantUserCredentialDetailsEntity userCredentialDetailsEntity : tenantUserCredentialDetailsEntities) {
                                    if (!AuthUtil.getShortAreaCode((String)userCredentialDetailsEntity.getAreaCode()).equals(AuthUtil.getShortAreaCode((String)finalAreaCode))) continue;
                                    rt4.setCerNo(userCredentialDetailsEntity.getCerNo());
                                }
                                continue;
                            }
                            if (tenantUserCredentialDetailsEntity.getAreaCode() != "#") continue;
                            rt4.setCerStatus(false);
                        }
                    }
                }
                if (gradeDetails != null && gradeDetails.size() > 0) {
                    cerDetailMap = gradeDetails.stream().collect(Collectors.groupingBy(i -> i.getTenantUserId()));
                    for (EmployeeDto rt4 : result) {
                        cerDetailList = cerDetailMap.get(rt4.getUserId());
                        if (cerDetailList == null) continue;
                        finalAreaCode = areaCode;
                        for (TenantUserCredentialDetailsEntity tenantUserCredentialDetailsEntity : cerDetailList) {
                            if (!StrUtil.isNotEmpty((CharSequence)tenantUserCredentialDetailsEntity.getAreaCode()) || tenantUserCredentialDetailsEntity.getAreaCode().length() < 2) continue;
                            if (AuthUtil.getShortAreaCode((String)tenantUserCredentialDetailsEntity.getAreaCode()).equals(AuthUtil.getShortAreaCode((String)finalAreaCode))) {
                                rt4.setGradeCerStatus(true);
                                tenantUserCredentialDetailsEntities = cerDetailMap.get(rt4.getUserId());
                                for (TenantUserCredentialDetailsEntity userCredentialDetailsEntity : tenantUserCredentialDetailsEntities) {
                                    rt4.assignGradeCer(userCredentialDetailsEntity.getCerNo(), userCredentialDetailsEntity.getAppraisalGrade());
                                    rt4.setGradeLevel(userCredentialDetailsEntity.getGradeLevel().getTypeValue());
                                }
                                continue;
                            }
                            if (tenantUserCredentialDetailsEntity.getAreaCode() != "#") continue;
                            rt4.setGradeCerStatus(false);
                        }
                    }
                }
            }
        } else {
            result = Collections.emptyList();
        }
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), (Collection)result);
    }

    public List<String> getMyDeptEmployeeIdList(Set<String> treeCodes) {
        String deptAdminSql = this.getDeptAdminSql(treeCodes);
        String sql = "SELECT k.employee.id FROM DepartmentEmployeeRelationEntity k WHERE 1=1 " + deptAdminSql + "";
        TypedQuery typedQuery = this.entityManager.createQuery(sql, String.class);
        return typedQuery.getResultList();
    }

    public Collection<MyOrganizationProfileDto> getMyOrganizationProfiles(String userId) {
        List employeeIds;
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(MyOrganizationProfileDto.class);
        Root root = criteria.from(EmployeeEntity.class);
        Join employeeOrganizationEntityJoin = root.join("organization", JoinType.INNER);
        CompoundSelection myOrganizationProfileDtoSelection = builder.construct(MyOrganizationProfileDto.class, new Selection[]{employeeOrganizationEntityJoin.get("id"), employeeOrganizationEntityJoin.get("name"), employeeOrganizationEntityJoin.get("industryCode"), employeeOrganizationEntityJoin.get("institutionalCode"), employeeOrganizationEntityJoin.get("superviseRegionCode"), employeeOrganizationEntityJoin.get("tenantUser").get("id"), root.get("id"), root.get("tenantUser").get("id"), root.get("occupationType"), root.get("status"), root.get("hiredDate"), root.get("masterSlaveType"), root.get("domainAdmin"), employeeOrganizationEntityJoin.get("organizationLevel")});
        CriteriaBuilder.In employmentStatusIn = builder.in((Expression)root.get("status"));
        employmentStatusIn.value((Object)EmploymentStatus.OnJob);
        employmentStatusIn.value((Object)EmploymentStatus.PendingForOffJob);
        criteria = criteria.where(new Predicate[]{builder.equal((Expression)root.get("tenantUser").get("id"), (Object)userId), employmentStatusIn, builder.equal((Expression)employeeOrganizationEntityJoin.get("approvedInformationValueType").get("status"), (Object)ApprovedStatus.Passed)}).select((Selection)myOrganizationProfileDtoSelection);
        List result = this.entityManager.createQuery(criteria).getResultList();
        if (result.size() > 0 && (employeeIds = result.stream().filter(i -> !i.isDomainAdmin()).map(MyOrganizationProfileDto::getEmployeeId).collect(Collectors.toList())) != null && employeeIds.size() > 0) {
            TypedQuery selectedDepartAdminQuery = this.entityManager.createQuery("select new java.lang.String(e.employee.id) from DepartmentAdminEntity e where e.employee.id in (?1) group by e.employee.id", String.class);
            selectedDepartAdminQuery.setParameter(1, employeeIds);
            employeeIds = selectedDepartAdminQuery.getResultList();
            if (employeeIds.size() > 0) {
                Map employeeMap = employeeIds.stream().collect(Collectors.toMap(String::new, Function.identity()));
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    MyOrganizationProfileDto myOrganizationProfileDto;
                    myOrganizationProfileDto.setDepartAdmin(employeeMap.get((myOrganizationProfileDto = (MyOrganizationProfileDto)iterator.next()).getEmployeeId()) != null);
                }
            }
        }
        return result;
    }

    public int isAssign(String organId, String tenantUserId) {
        TypedQuery selectedDepartmentQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.tmps.EmployeeDepartData(d.id,d.permissionType,d.permissionConfig,e.id)  from EmployeeEntity e join e.departmentEmployeeRelations c join c.department d  where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and e.organization.id=?1 and e.tenantUser.id=?2", EmployeeDepartData.class);
        selectedDepartmentQuery.setParameter(1, (Object)organId);
        selectedDepartmentQuery.setParameter(2, (Object)tenantUserId);
        List employeeDepartDataList = selectedDepartmentQuery.getResultList();
        if (CollectionUtils.isEmpty((Collection)employeeDepartDataList)) {
            return 1;
        }
        return DepartImPermissionType.Special.compareTo((Enum)((EmployeeDepartData)employeeDepartDataList.get(0)).getPermissionType());
    }

    public Collection<MyImDepartDto> getMyDeparts(String organId, String tenantUserId) {
        TypedQuery selectedDepartmentQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.tmps.EmployeeDepartData(d.id,d.permissionType,d.permissionConfig,e.id)  from EmployeeEntity e join e.departmentEmployeeRelations c join c.department d  where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and e.organization.id=?1 and e.tenantUser.id=?2 and d.deleted = false", EmployeeDepartData.class);
        selectedDepartmentQuery.setParameter(1, (Object)organId);
        selectedDepartmentQuery.setParameter(2, (Object)tenantUserId);
        List employeeDepartDataList = selectedDepartmentQuery.getResultList();
        if (CollectionUtils.isEmpty((Collection)employeeDepartDataList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> likeDepartIds = new ArrayList<String>();
        ArrayList<String> equalMatchedDepartIds = new ArrayList<String>();
        AtomicBoolean showWhole = new AtomicBoolean(false);
        StringBuilder selfForDepartCondition = new StringBuilder();
        AtomicInteger paramIndex = new AtomicInteger(2);
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        parameters.put(1, organId);
        boolean self = false;
        for (EmployeeDepartData ed : employeeDepartDataList) {
            switch (ed.getPermissionType()) {
                case Whole: {
                    showWhole.set(true);
                    break;
                }
                case OnDepartAndSub: {
                    likeDepartIds.add(ed.getId());
                    break;
                }
                case JustOnDepart: {
                    equalMatchedDepartIds.add(ed.getId());
                    break;
                }
                case Special: {
                    DepartImAllowedDepartSnapshot snapshot = (DepartImAllowedDepartSnapshot)this.jsonProvider.toObject(DepartImAllowedDepartSnapshot.class, ed.getPermissionConfig());
                    if (snapshot == null || CollectionUtils.isEmpty((Collection)snapshot.getDepartIds())) break;
                    equalMatchedDepartIds.addAll(snapshot.getDepartIds());
                    break;
                }
                case JustSelf: {
                    self = true;
                    if (selfForDepartCondition.length() > 0) {
                        selfForDepartCondition.append(" OR ");
                    }
                    selfForDepartCondition.append(String.format(" (d.id=?%s and c.employee.id=?%s)", paramIndex.get(), paramIndex.get() + 1));
                    parameters.put(paramIndex.get(), ed.getId());
                    parameters.put(paramIndex.get() + 1, ed.getEmployeeId());
                    paramIndex.incrementAndGet();
                    paramIndex.incrementAndGet();
                }
            }
        }
        StringBuilder noSelfForDepartCondition = new StringBuilder();
        if (!showWhole.get()) {
            if (!CollectionUtils.isEmpty(likeDepartIds)) {
                StringBuilder sbLikeCondition = new StringBuilder();
                sbLikeCondition.append(" (");
                for (int lindex = 0; lindex < likeDepartIds.size(); ++lindex) {
                    if (lindex > 0) {
                        sbLikeCondition.append(" OR ");
                    }
                    sbLikeCondition.append(String.format(" d.indexTree like ?%s", paramIndex.get()));
                    parameters.put(paramIndex.get(), "%" + (String)likeDepartIds.get(lindex) + "%");
                    paramIndex.incrementAndGet();
                }
                sbLikeCondition.append(") ");
                noSelfForDepartCondition.append((CharSequence)sbLikeCondition);
            }
            if (!CollectionUtils.isEmpty(equalMatchedDepartIds)) {
                if (noSelfForDepartCondition.length() > 0) {
                    noSelfForDepartCondition.append(" OR ");
                }
                noSelfForDepartCondition.append(String.format(" d.id in (?%s)", paramIndex.get()));
                parameters.put(paramIndex.get(), equalMatchedDepartIds);
            }
        }
        String qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.DepartmentReadDto(d.id,d.name,d.displayOrder,d.parent.id) from DepartmentEntity d where d.organization.id=?1 and d.deleted=false ";
        if (self) {
            qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.DepartmentReadDto(d.id,d.name,d.displayOrder,d.parent.id) from DepartmentEntity d left join d.departmentEmployeeRelations c where d.organization.id=?1 and d.deleted=false ";
        }
        Collection whereItems = new ArrayList<String>();
        whereItems.add(selfForDepartCondition.toString());
        whereItems.add(noSelfForDepartCondition.toString());
        whereItems = whereItems.stream().filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.toList());
        if (whereItems.size() > 0) {
            qString = String.format("%s and (%s)", qString, whereItems.stream().collect(Collectors.joining(" or ")));
        }
        TypedQuery departEmployeeQuery = this.entityManager.createQuery(qString, DepartmentReadDto.class);
        for (Integer key : parameters.keySet()) {
            departEmployeeQuery = departEmployeeQuery.setParameter(key.intValue(), parameters.get(key));
        }
        List result = departEmployeeQuery.getResultList();
        return this.dataTranslate.translate2MyImDeparts(result);
    }

    public Collection<MyImContactDto> getMyImContacts(IMContactCriteria request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("organId", request.getOrganizationId());
        parameters.put("departId", request.getDepartId());
        String qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.EmployeeContactReadDto(t.id,c.employee.id,t.name,t.telephone,t.headPhoto,t.sex,t.imIdentity) from DepartmentEntity d join d.departmentEmployeeRelations c join c.employee e join e.tenantUser t where d.organization.id=:organId and d.id=:departId and e.status <>1 ";
        if (!this.isSpecialDepart(request)) {
            qString = qString + " and (d.permissionType <> com.bcxin.Infrastructures.enums.DepartImPermissionType.JustSelf or ( d.permissionType = com.bcxin.Infrastructures.enums.DepartImPermissionType.JustSelf and t.id =:tenantUserId ) or exists (select 1 from DepartmentEntity tt1 join tt1.departmentEmployeeRelations tt2 join tt2.employee.tenantUser tt3  where tt1.organization.id=:organId   and tt3.id =:tenantUserId   and ( tt1.permissionType =3  or (tt1.permissionType =1 and d.indexTree like concat(tt1.indexTree,'%')) )) )";
            parameters.put("tenantUserId", request.getUserId());
        }
        TypedQuery employeeQuery = this.entityManager.createQuery(qString, EmployeeContactReadDto.class);
        for (String key : parameters.keySet()) {
            employeeQuery.setParameter(key, parameters.get(key));
        }
        List result = employeeQuery.getResultList();
        return this.dataTranslate.translate2MyImContacts(result);
    }

    public Collection<MyImContactDto> getMyImContactSearch(IMContactCriteria request) {
        List<String> specialDeparts;
        String qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.EmployeeContactReadDto(t.id,c.employee.id,t.name,t.telephone,t.headPhoto,t.sex,t.imIdentity) from DepartmentEntity d join d.departmentEmployeeRelations c join c.employee e join e.tenantUser t join t.selectedCredential s where d.organization.id=:organId  and e.status <>1 and d.deleted = false ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organId", request.getOrganizationId());
        if (StrUtil.isNotEmpty((CharSequence)request.getDepartId())) {
            qString = qString + " and d.id=:departId ";
            parameters.put("departId", request.getDepartId());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)";
            parameters.put("keyword", "%" + request.getKeyword() + "%");
        }
        if ((specialDeparts = this.getSpecialDeparts(request)).size() == 0) {
            specialDeparts.add("specialDeparts");
        }
        qString = qString + " and ((d.id in (:specialDeparts)) ";
        parameters.put("specialDeparts", specialDeparts);
        qString = qString + " or (( d.permissionType = com.bcxin.Infrastructures.enums.DepartImPermissionType.JustSelf and t.id =:tenantUserId ) or exists (select 1 from DepartmentEntity tt1 join tt1.departmentEmployeeRelations tt2 join tt2.employee.tenantUser tt3  where tt1.organization.id=:organId   and tt3.id =:tenantUserId   and ( tt1.permissionType =3  or (tt1.permissionType =0 and d.id = tt1.id)  or (tt1.permissionType =1 and d.indexTree like concat(tt1.indexTree,'%')) )) ))";
        parameters.put("tenantUserId", request.getUserId());
        TypedQuery employeeQuery = this.entityManager.createQuery(qString, EmployeeContactReadDto.class);
        for (String key : parameters.keySet()) {
            employeeQuery.setParameter(key, parameters.get(key));
        }
        List result = employeeQuery.getResultList();
        return this.dataTranslate.translate2MyImContacts(result);
    }

    public Pageable<CompanyCredentialResponse> getCompanys(OrganizationCriteria organizationCriteria) {
        if (StrUtil.isEmpty((CharSequence)organizationCriteria.getName())) {
            return Pageable.create((int)organizationCriteria.getPageIndex(), (int)organizationCriteria.getPageSize(), (int)0, null);
        }
        String qString = "select t from CompanyCredentialViewEntity t where t.comName = '" + organizationCriteria.getName() + "'";
        String cString = "select count(1) from CompanyCredentialViewEntity t where t.comName = '" + organizationCriteria.getName() + "'";
        TypedQuery companyQuery = this.entityManager.createQuery(qString, CompanyCredentialViewEntity.class);
        TypedQuery cquery = this.entityManager.createQuery(cString, Long.class);
        long totalCount = (Long)cquery.getSingleResult();
        if (totalCount > 0L) {
            List result = companyQuery.setFirstResult(organizationCriteria.getSkip()).setMaxResults(organizationCriteria.getPageSize()).getResultList();
            ArrayList<CompanyCredentialResponse> comList = new ArrayList<CompanyCredentialResponse>();
            for (CompanyCredentialViewEntity companyCredential : result) {
                comList.add(CompanyCredentialResponse.create((String)companyCredential.getComName(), (String)companyCredential.getLegalPerson(), (String)companyCredential.getTel(), (String)companyCredential.getRegisteredMoney(), (String)companyCredential.getCerNo(), (String)companyCredential.getAddress(), (String)companyCredential.getLocation(), (Date)companyCredential.getCerDate(), (String)companyCredential.getSecurityScopeType()));
            }
            return Pageable.create((int)organizationCriteria.getPageIndex(), (int)organizationCriteria.getPageSize(), (int)((int)totalCount), comList);
        }
        return Pageable.create((int)organizationCriteria.getPageIndex(), (int)organizationCriteria.getPageSize(), (int)((int)totalCount), null);
    }

    public Pageable<ImContactDto> contactSearch(IMContactCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.ImContactDto(t.id,t.name,t.headPhoto,t.telephone,s.number,t.imIdentity,t.sex,t.oneInchColorWhitePhoto) from TenantUserEntity t join t.selectedCredential s where 1=1  ";
        String cString = "select count(1)  from TenantUserEntity t join t.selectedCredential s where 1=1  ";
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StrUtil.isNotEmpty((CharSequence)criteria.getKeyword())) {
            qString = qString + " and (t.telephone =:keyword or s.number =:keyword)";
            cString = cString + " and (t.telephone =:keyword or s.number =:keyword)";
            parameters.put("keyword", criteria.getKeyword());
        }
        TypedQuery employeeQuery = this.entityManager.createQuery(qString, ImContactDto.class);
        TypedQuery cquery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            employeeQuery.setParameter(key, parameters.get(key));
            cquery.setParameter(key, parameters.get(key));
        }
        List result = employeeQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        long totalCount = (Long)cquery.getSingleResult();
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), (Collection)result);
    }

    private List<String> getSpecialDeparts(IMContactCriteria request) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select t3.permissionConfig from EmployeeEntity t1 join t1.departmentEmployeeRelations t2 join t2.department t3  where t1.tenantUser.id = :tenantUserId and t3.permissionType = com.bcxin.Infrastructures.enums.DepartImPermissionType.Special";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tenantUserId", request.getUserId());
        TypedQuery employeeLeaveDtoTypedQuery = this.entityManager.createQuery(sql, String.class);
        for (String key : parameters.keySet()) {
            employeeLeaveDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        List list = employeeLeaveDtoTypedQuery.getResultList();
        DepartImAllowedDepartSnapshot snapshot = null;
        if (list.size() > 0) {
            for (String permissionConfig : list) {
                snapshot = (DepartImAllowedDepartSnapshot)JSON.parseObject((String)permissionConfig, DepartImAllowedDepartSnapshot.class);
                result.addAll(snapshot.getDepartIds());
            }
        }
        return result;
    }

    private boolean isSpecialDepart(IMContactCriteria request) {
        boolean result = false;
        List<String> list = this.getSpecialDeparts(request);
        if (list.size() > 0 && list.contains(request.getDepartId())) {
            result = true;
        }
        return result;
    }

    public Pageable<DepartAdminDto> findDepartAdmins(String organizationId, DepartAdminCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.DepartAdminReadDto(e.id,t.name,t.telephone,p.department.name,d.department.name)  from DepartmentAdminEntity d join d.employee e left join e.tenantUser t join e.departmentEmployeeRelations p   where e.status<>com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and d.organization.id=:organizationId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (CollUtil.isNotEmpty((Collection)criteria.getDepartId())) {
            qString = qString + " AND p.department.id in( :departId )  ";
            parameters.put("departId", criteria.getDepartId());
        }
        if (CollUtil.isNotEmpty((Collection)criteria.getAdminDepartIds())) {
            qString = qString + " AND d.department.id in( :adminDepartIds )  ";
            parameters.put("adminDepartIds", criteria.getAdminDepartIds());
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword )";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists(select da from DepartmentAdminEntity da where da.employee.id=:employeeId and exists(select 1 from d.department dp where dp.indexTree like concat(da.department.indexTree ,'%')))";
            qString = qString + " and exists(select 1 from p.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            parameters.put("employeeId", userContext.get().getEmployeeId());
        }
        TypedQuery adminReadDtoTypedQuery = this.entityManager.createQuery(qString, DepartAdminReadDto.class);
        for (String key : parameters.keySet()) {
            adminReadDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        List departAdminReads = adminReadDtoTypedQuery.getResultList();
        Collection<DepartAdminDto> wholeDepartAdmins = this.dataTranslate.translate2DepartAdmins(departAdminReads);
        Pageable pageable = Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)wholeDepartAdmins.size(), (Collection)wholeDepartAdmins.stream().skip(criteria.getSkip()).limit(criteria.getPageSize()).collect(Collectors.toList()));
        return pageable;
    }

    public List<DepartmentAdminExportDto> findExportDepartAdmins(String organizationId, DepartAdminCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.repository.readers.tmps.DepartAdminReadDto(e.id,t.name,t.telephone,p.department.name,d.department.name)  from DepartmentAdminEntity d join d.employee e left join e.tenantUser t join e.departmentEmployeeRelations p   where e.status<>com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and d.organization.id=:organizationId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (CollUtil.isNotEmpty((Collection)criteria.getDepartId())) {
            qString = qString + " AND p.department.id in( :departId )  ";
            parameters.put("departId", criteria.getDepartId());
        }
        if (CollUtil.isNotEmpty((Collection)criteria.getAdminDepartIds())) {
            qString = qString + " AND d.department.id in( :adminDepartIds )  ";
            parameters.put("adminDepartIds", criteria.getAdminDepartIds());
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword )";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists(select da from DepartmentAdminEntity da where da.employee.id=:employeeId and exists(select 1 from d.department dp where dp.indexTree like concat(da.department.indexTree ,'%')))";
            qString = qString + " and exists(select 1 from p.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            parameters.put("employeeId", userContext.get().getEmployeeId());
        }
        TypedQuery adminReadDtoTypedQuery = this.entityManager.createQuery(qString, DepartAdminReadDto.class);
        for (String key : parameters.keySet()) {
            adminReadDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        List departAdminReads = adminReadDtoTypedQuery.getResultList();
        List<DepartmentAdminExportDto> wholeDepartAdmins = this.dataTranslate.translate2DepartExportAdmins(departAdminReads);
        return wholeDepartAdmins;
    }

    public UserOrganBasicDto getUserOrganBasicDto(String organizationId, String tenantUserId, PersonResourceType resourceType) {
        try {
            TypedQuery userOrganBasicDtoTypedQuery = null;
            UserOrganBasicDto userOrganBasicDto = null;
            if (resourceType == PersonResourceType.Member) {
                userOrganBasicDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.UserOrganBasicDto(t.id,t.name, o.id,o.name, o.superviseRegionCode,e.id,e.memberType)  from ExternalMemberEntity e join e.tenantUser t join OrganizationEntity o on e.referenceNumber=o.id where t.id=?1 and o.id=?2 and  e.approvedInformationValueType.status = com.bcxin.Infrastructures.enums.ApprovedStatus.Passed", UserOrganBasicDto.class);
                userOrganBasicDtoTypedQuery.setParameter(1, (Object)tenantUserId);
                userOrganBasicDtoTypedQuery.setParameter(2, (Object)organizationId);
                userOrganBasicDto = (UserOrganBasicDto)userOrganBasicDtoTypedQuery.getSingleResult();
            } else {
                userOrganBasicDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.UserOrganBasicDto(t.id,t.name, o.id,o.name, o.superviseRegionCode,e.id,e.masterSlaveType,e.domainAdmin)  from EmployeeEntity e join e.tenantUser t join e.organization o where t.id=?1 and o.id=?2 and  e.status<>com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob", UserOrganBasicDto.class);
                userOrganBasicDtoTypedQuery.setParameter(1, (Object)tenantUserId);
                userOrganBasicDtoTypedQuery.setParameter(2, (Object)organizationId);
                userOrganBasicDto = (UserOrganBasicDto)userOrganBasicDtoTypedQuery.getSingleResult();
                if (userOrganBasicDto != null) {
                    TypedQuery selectedDepartAdminQuery = this.entityManager.createQuery("select new java.lang.String(e.employee.id) from DepartmentAdminEntity e where e.employee.id = ?1 group by e.employee.id", String.class);
                    selectedDepartAdminQuery.setParameter(1, (Object)userOrganBasicDto.getEmployeeId());
                    List employeeIds = selectedDepartAdminQuery.getResultList();
                    if (employeeIds.size() > 0) {
                        userOrganBasicDto.setDepartAdmin(true);
                    }
                }
            }
            return userOrganBasicDto;
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Pageable<EmployeeLeaveDto> findLeaveEmployees(String organizationId, LeaveEmployeeCriteria criteria) {
        String qString = "select new map(c.id as id,t.name as name,t.telephone as telephone,s.credentialType as credentialType,x.name as departName,c.insure as insure,s.number as number,c.hiredDate as hiredDate,c.leaveTime as leaveTime,c.leaveNote as leaveNote,c.leaveOperator.name as operatorName,c.leaveOperator.createdTime as leaveRequestTime)  from EmployeeEntity c join c.tenantUser t left join t.selectedCredential s left join c.defaultDepartment x where c.status=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob  and c.organization.id=:organizationId";
        String cString = "select count(1) from EmployeeEntity c join c.tenantUser t left join t.selectedCredential s where c.status=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob  and c.organization.id=:organizationId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)";
            cString = cString + " and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (criteria.getStartDate() != null) {
            qString = qString + " and c.leaveTime >=:startDate ";
            cString = cString + " and c.leaveTime >=:startDate ";
            parameters.put("startDate", criteria.getStartDate());
        }
        if (criteria.getEndDate() != null) {
            qString = qString + " and c.leaveTime <=:endDate ";
            cString = cString + " and c.leaveTime <=:endDate ";
            parameters.put("endDate", criteria.getEndDate());
        }
        if (criteria.getInsure() != null) {
            if (criteria.getInsure().equals((Object)TrueFalseStatus.False)) {
                qString = qString + " and (c.insure = :insure or c.insure is null) ";
                cString = cString + " and (c.insure = :insure or c.insure is null) ";
            } else {
                qString = qString + " and c.insure =:insure ";
                cString = cString + " and c.insure =:insure ";
            }
            parameters.put("insure", criteria.getInsure());
        }
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            if (userContext.get().isDepartAdmin()) {
                String deptAdminSql = this.getDeptAdminSql(criteria.getTreeCodes());
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    cString = cString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    parameters.put("departmentIds", criteria.getDepartIds());
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (c.id=:selfEmployeeId or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
                    cString = cString + " and (c.id=:selfEmployeeId or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            } else {
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    cString = cString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (c.id=:selfEmployeeId)";
                    cString = cString + " and (c.id=:selfEmployeeId)";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            }
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=c.id and de.department.id in (:departmentIds))";
            cString = cString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=c.id and de.department.id in (:departmentIds))";
            parameters.put("departmentIds", criteria.getDepartIds());
        }
        qString = qString + " order by c.leaveTime desc ";
        TypedQuery employeeLeaveDtoTypedQuery = this.entityManager.createQuery(qString, Map.class);
        TypedQuery totalCountQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            employeeLeaveDtoTypedQuery.setParameter(key, parameters.get(key));
            totalCountQuery.setParameter(key, parameters.get(key));
        }
        long totalCount = (Long)totalCountQuery.getSingleResult();
        List result = employeeLeaveDtoTypedQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        List<Object> list = Collections.emptyList();
        if (result.size() > 0) {
            list = result.stream().map(ii -> {
                Timestamp leveTime = (Timestamp)ii.get("leaveTime");
                Date hiredDate = (Date)ii.get("hiredDate");
                Timestamp leaveRequestTime = (Timestamp)ii.get("leaveRequestTime");
                return new EmployeeLeaveDto((String)ii.get("id"), (String)ii.get("name"), (String)ii.get("telephone"), "", (CredentialType)ii.get("credentialType"), (String)ii.get("number"), hiredDate, leveTime, (String)ii.get("leaveNote"), (String)ii.get("operatorName"), leaveRequestTime, (TrueFalseStatus)ii.get("insure"));
            }).collect(Collectors.toList());
            Collection employeeIds = list.stream().map(ii -> ii.getId()).collect(Collectors.toList());
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
            mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
            List departDtos = mapTypedQuery.getResultList();
            Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (EmployeeLeaveDto rt : list) {
                if (departMap.get(rt.getId()) == null) continue;
                rt.assignDepart(departMap.get(rt.getId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")));
            }
        }
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), list);
    }

    public Pageable<InvitedToJoinQueuesDto> findInvitedToJoinQueuesMember(String organizationId, InvitedToJoinQueuesCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.InvitedToJoinQueuesDto(i.id,i.name,i.telephone,i.credentialType,i.credentialNumber,i.inviter,i.invitedType,i.departmentId,i.departmentName,i.occupationType,i.attendanceSiteName,i.invitedStatus) from InvitedToJoinQueuesEntity i  where i.organizationId = :organizationId and i.invitedStatus = 0";
        String cString = "select count(1) from InvitedToJoinQueuesEntity i where i.organizationId=:organizationId and i.invitedStatus = 0";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (i.name like :keyword or i.telephone like :keyword or i.credentialNumber like :keyword)";
            cString = cString + " and (i.name like :keyword or i.telephone like :keyword or i.credentialNumber like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getOccupationTypes())) {
            qString = qString + " and i.occupationType in :occupationType";
            cString = cString + " and i.occupationType in :occupationType";
            parameters.put("occupationType", criteria.getOccupationTypes());
        }
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            if (userContext.get().isDepartAdmin()) {
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and exists(select 1 from DepartmentAdminEntity x where x.department.id=i.departmentId and x.employee.id=:employeeId and i.departmentId in :departmentId)";
                    cString = cString + " and exists(select 1 from DepartmentAdminEntity x where x.department.id=i.departmentId and x.employee.id=:employeeId and i.departmentId in :departmentId)";
                    parameters.put("departmentId", criteria.getDepartIds());
                    parameters.put("employeeId", userContext.get().getEmployeeId());
                } else {
                    qString = qString + " and exists(select 1 from DepartmentAdminEntity x where x.department.id=i.departmentId and x.employee.id=:employeeId)";
                    cString = cString + " and exists(select 1 from DepartmentAdminEntity x where x.department.id=i.departmentId and x.employee.id=:employeeId)";
                    parameters.put("employeeId", userContext.get().getEmployeeId());
                }
            } else {
                qString = qString + " and i.id=:invalidId";
                cString = cString + " and i.id=:invalidId";
                parameters.put("invalidId", 0L);
            }
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and i.departmentId in :departmentId";
            cString = cString + " and i.departmentId in :departmentId";
            parameters.put("departmentId", criteria.getDepartIds());
        }
        TypedQuery invitedToJoinQueuesDtoTypedQuery = this.entityManager.createQuery(qString, InvitedToJoinQueuesDto.class);
        TypedQuery totalCountQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            invitedToJoinQueuesDtoTypedQuery.setParameter(key, parameters.get(key));
            totalCountQuery.setParameter(key, parameters.get(key));
        }
        long totalCount = (Long)totalCountQuery.getSingleResult();
        List result = invitedToJoinQueuesDtoTypedQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        List list = Collections.emptyList();
        if (result.size() > 0) {
            list = result.stream().map(ii -> new InvitedToJoinQueuesDto(ii.getId(), ii.getName(), ii.getTelephone(), ii.getCredentialType(), ii.getCredentialNumber(), ii.getInviter(), ii.getInvitedType(), ii.getDepartmentId(), ii.getDepartmentName(), ii.getOccupationType(), ii.getAttendanceSiteName(), ii.getInvitedStatus())).collect(Collectors.toList());
        }
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), list);
    }

    private String getDeptAdminSql(Collection<String> treeCodes) {
        String deptAdminSql = "";
        StringBuffer deptAdminSqlSb = new StringBuffer();
        if (!CollectionUtils.isEmpty(treeCodes)) {
            deptAdminSqlSb.append(" and ( ");
            for (String treeCode : treeCodes) {
                deptAdminSqlSb.append(" k.departmentIndexTree LIKE concat('").append(treeCode).append("', '%') ").append(" or");
            }
            deptAdminSql = deptAdminSqlSb.substring(0, deptAdminSqlSb.length() - 2).concat(") ");
        }
        return deptAdminSql;
    }

    public List<LeaveEmployeeExportDto> findLeaveEmployeeList(String organizationId, EmployeeLeaveCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.repositories.dtos.LeaveEmployeeExportDto(c.id,t.name,t.telephone,c.insure,s.credentialType,s.number,c.hiredDate,c.leaveTime,c.leaveNote,c.leaveOperator.name,c.leaveOperator.createdTime)  from EmployeeEntity c join c.tenantUser t left join t.selectedCredential s left join c.defaultDepartment x where c.status=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob  and c.organization.id=:organizationId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (criteria.getStartDate() != null) {
            qString = qString + " and c.leaveTime >=:startDate ";
            parameters.put("startDate", criteria.getStartDate());
        }
        if (criteria.getEndDate() != null) {
            qString = qString + " and c.leaveTime <=:endDate ";
            parameters.put("endDate", criteria.getEndDate());
        }
        if (criteria.getInsure() != null) {
            qString = criteria.getInsure().equals((Object)TrueFalseStatus.False) ? qString + " and (c.insure = :insure or c.insure is null) " : qString + " and c.insure =:insure ";
            parameters.put("insure", criteria.getInsure());
        }
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            if (userContext.get().isDepartAdmin()) {
                String deptAdminSql = this.getDeptAdminSql(criteria.getTreeCodes());
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    parameters.put("departmentIds", criteria.getDepartIds());
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (c.id=:selfEmployeeId or exists (SELECT k FROM c.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            } else {
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((c.id=:selfEmployeeId and exists(select k from c.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (c.id=:selfEmployeeId)";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            }
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=c.id and de.department.id in (:departmentIds))";
            parameters.put("departmentIds", criteria.getDepartIds());
        }
        qString = qString + " order by c.leaveTime desc ";
        TypedQuery employeeLeaveDtoTypedQuery = this.entityManager.createQuery(qString, LeaveEmployeeExportDto.class);
        for (String key : parameters.keySet()) {
            employeeLeaveDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        List list = employeeLeaveDtoTypedQuery.getResultList();
        if (list.size() > 0) {
            Collection employeeIds = list.stream().map(ii -> ii.getId()).collect(Collectors.toList());
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
            mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
            List departDtos = mapTypedQuery.getResultList();
            Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (LeaveEmployeeExportDto rt : list) {
                if (departMap.get(rt.getId()) == null) continue;
                rt.assignDepart(departMap.get(rt.getId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")));
            }
        }
        return list;
    }

    public List<ContractExportDto> findContractList(String organizationId, ContractCriteria criteria) {
        TenantUserContext userContext;
        String qString = "select new com.bcxin.tenant.domain.repositories.dtos.ContractExportDto(e.id,c.name,t.name,t.telephone,sc.credentialType,sc.number,c.aName,c.bName,  c.beginDate,c.endDate,c.dateLimitless,c.status,c.note,c.attachment,e.status,c.lastModifier,c.creator)  from ContractEntity c join c.employee e join e.tenantUser t left join t.selectedCredential sc where c.organization.id=:organizationId ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or t.selectedCredential.number like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeId())) {
            qString = qString + " and e.id=:employeeId1 ";
            parameters.put("employeeId1", criteria.getEmployeeId());
        }
        if (criteria.getOccupationTypes() != null && criteria.getOccupationTypes().size() > 0) {
            qString = qString + " and e.occupationType in :occupationTypes";
            parameters.put("occupationTypes", criteria.getOccupationTypes());
        }
        if (criteria.getEmploymentStatus() != null) {
            qString = qString + " and e.status=:employmentStatus";
            parameters.put("employmentStatus", criteria.getEmploymentStatus());
        }
        if (criteria.getStatus() != null) {
            switch (criteria.getStatus()) {
                case INCOMPLETE: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and (c.attachment is null or c.attachment ='') ";
                    break;
                }
                case BEEFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.beginDate > now() ";
                    break;
                }
                case EFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and now() between c.beginDate and c.endDate and c.attachment is not null and c.attachment !='' ";
                    break;
                }
                case STOP: {
                    qString = qString + " and (c.status = 0 or e.status = 1 or (c.dateLimitless=0 and c.endDate < now())) ";
                    break;
                }
                case DUE: {
                    Date dueDate = DateUtils.addMonths((Date)new Date(), (int)1);
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.dateLimitless=0 and c.endDate > now() and c.endDate < :dueDate ";
                    parameters.put("dueDate", dueDate);
                    break;
                }
            }
        }
        if (criteria.getDepartIds() != null && criteria.getDepartIds().size() > 0) {
            qString = qString + " and exists(select d from DepartmentEmployeeRelationEntity d where d.employee.id=e.id and d.department.id in :departIds)";
            parameters.put("departIds", criteria.getDepartIds());
        }
        if (criteria.getBeginDate() != null) {
            qString = qString + " and c.beginDate >=:beginDate";
            parameters.put("beginDate", criteria.getBeginDate());
        }
        if (criteria.getEndDate() != null) {
            qString = qString + " and c.endDate <=:endDate";
            parameters.put("endDate", criteria.getEndDate());
        }
        if (criteria.getBeginCreatedTime() != null) {
            qString = qString + " and DATE(c.creator.createdTime) >= DATE(:beginCreatedTime)";
            parameters.put("beginCreatedTime", criteria.getBeginCreatedTime());
        }
        if (criteria.getEndCreatedTime() != null) {
            qString = qString + " and DATE(c.creator.createdTime) <= DATE(:endCreatedTime)";
            parameters.put("endCreatedTime", criteria.getEndCreatedTime());
        }
        if ((userContext = TenantContext.getInstance().getUserContext()) != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists(select 1 from e.departmentEmployeeRelations k join k.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            parameters.put("employeeId", userContext.get().getEmployeeId());
        }
        qString = qString + " order by c.endDate ";
        TypedQuery employeeContractDtoTypedQuery = this.entityManager.createQuery(qString, ContractExportDto.class);
        for (String key : parameters.keySet()) {
            employeeContractDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        List list = employeeContractDtoTypedQuery.getResultList();
        if (list.size() > 0) {
            Map<String, DepartmentDto> departMaps = this.getDepartMaps(organizationId);
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in :employeeIds", DepartDto.class);
            List employeeIds = list.stream().map(ContractExportDto::getEmployeeId).collect(Collectors.toList());
            mapTypedQuery.setParameter("employeeIds", employeeIds);
            List departDtos = mapTypedQuery.getResultList();
            for (DepartDto departDto : departDtos) {
                if (departMaps.get(departDto.getDepartId()) == null) continue;
                departDto.resetDepartName(departMaps.get(departDto.getDepartId()).getIndexTree());
            }
            Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (ContractExportDto employeeContractDto : list) {
                if (departMap.get(employeeContractDto.getEmployeeId()) == null) continue;
                employeeContractDto.setEmployeeDepartName(departMap.get(employeeContractDto.getEmployeeId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(",")));
            }
        }
        return list;
    }

    private Map<String, DepartmentDto> getDepartMaps(String organizationId) {
        Collection<DepartmentDto> departmentDtos = this.getAllManagedDepartmentDtos(organizationId);
        for (DepartmentDto department : departmentDtos) {
            department.resetIndexTree("/" + department.getIndexTree().replaceAll("--", "#").replaceAll("-", "/") + "/");
        }
        for (DepartmentDto departmentDto : departmentDtos) {
            for (DepartmentDto department : departmentDtos) {
                department.resetIndexTree(department.getIndexTree().replace("/" + departmentDto.getId().replaceAll("--", "#") + "/", "/" + departmentDto.getName() + "/"));
            }
        }
        for (DepartmentDto department : departmentDtos) {
            department.resetIndexTree(department.getIndexTree().substring(1, department.getIndexTree().length() - 1));
        }
        return departmentDtos.stream().collect(Collectors.toMap(DepartmentDto::getId, Function.identity()));
    }

    public EmployeeReportDto findReport(String organizationId, EmployeeCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            sb.append(" and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)");
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCredentialTypes())) {
            sb.append(" and s.credentialType in :credentialType");
            parameters.put("credentialType", criteria.getCredentialTypes());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getAuthenticatedStatuses())) {
            sb.append(" and t.authenticateStatus in :authenticateStatus");
            parameters.put("authenticateStatus", criteria.getAuthenticatedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCheckedStatuses())) {
            sb.append(" and t.checkedStatus in :checkedStatus");
            parameters.put("checkedStatus", criteria.getCheckedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getOccupationTypes())) {
            sb.append(" and e.occupationType in :occupationType");
            parameters.put("occupationType", criteria.getOccupationTypes());
        }
        if (criteria.getHiredDate() != null) {
            sb.append(" and e.hiredDate=:hiredDate ");
            parameters.put("hiredDate", criteria.getHiredDate());
        }
        if (StringUtils.hasLength((String)criteria.getPosition())) {
            sb.append(" and e.position = :position ");
            parameters.put("position", criteria.getPosition());
        }
        if ("1".equals(criteria.getContractStatus())) {
            sb.append(" and exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        if ("0".equals(criteria.getContractStatus())) {
            sb.append(" and not exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        if ("1".equals(criteria.getCerStatus())) {
            sb.append(" and exists(select tuc from TenantUserCredentialsEntity tuc where tuc.tenantUser = t and tuc.credentialType=1) ");
        }
        if ("0".equals(criteria.getCerStatus())) {
            sb.append(" and not exists(select tuc from TenantUserCredentialsEntity tuc where tuc.tenantUser = t and tuc.credentialType=1) ");
        }
        if ("1".equals(criteria.getGradeCerStatus())) {
            sb.append(" and exists(select tuc from TenantUserCredentialsEntity tuc where tuc.tenantUser = t and tuc.credentialType=8) ");
        }
        if ("0".equals(criteria.getGradeCerStatus())) {
            sb.append(" and not exists(select tuc from TenantUserCredentialsEntity tuc where tuc.tenantUser = t and tuc.credentialType=8) ");
        }
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.EmployeeConDto(e.id,t.checkedStatus, e.occupationType, t.authenticateStatus,(select count(1) from ContractEntity c where c.employee = e and c.status = com.bcxin.Infrastructures.enums.ValidStatus.Valid and CURDATE() between c.beginDate and c.endDate))  from EmployeeEntity e join e.tenantUser t left join t.selectedCredential s  where e.status!=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob";
        if (StrUtil.isNotEmpty((CharSequence)organizationId)) {
            qString = qString + " and e.organization.id=:organId ";
            parameters.put("organId", organizationId);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getOrganName())) {
            qString = qString + " and e.organization.name like '%:organName%' ";
            parameters.put("organName", criteria.getOrganName());
        }
        qString = qString + sb;
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            String deptAdminSql = this.getDeptAdminSql(criteria.getTreeCodes());
            if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                qString = qString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                parameters.put("departmentIds", criteria.getDepartIds());
                parameters.put("selfDepartmentIds", criteria.getDepartIds());
            } else {
                qString = qString + " and (e.id=:selfEmployeeId or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
            }
            parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=e.id and de.department.id in (:departmentIds))";
            parameters.put("departmentIds", criteria.getDepartIds());
        }
        TypedQuery employeeTypedQuery = this.entityManager.createQuery(qString, EmployeeConDto.class);
        for (String key : parameters.keySet()) {
            employeeTypedQuery = employeeTypedQuery.setParameter(key, parameters.get(key));
        }
        List employeeConDtos = employeeTypedQuery.getResultList();
        return new EmployeeReportDto(Long.valueOf(employeeConDtos.size()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> UserCheckedStatus.None.equals((Object)employeeConDto.getCheckedStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> UserCheckedStatus.Matched.equals((Object)employeeConDto.getCheckedStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> UserCheckedStatus.Commit.equals((Object)employeeConDto.getCheckedStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> employeeConDto.getContractCount() > 0L).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && UserCheckedStatus.None.equals((Object)employeeConDto.getCheckedStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && UserCheckedStatus.Matched.equals((Object)employeeConDto.getCheckedStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && RealNameAuthenticatedStatus.Authenticating.equals((Object)employeeConDto.getAuthenticateStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && RealNameAuthenticatedStatus.Passed.equals((Object)employeeConDto.getAuthenticateStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && RealNameAuthenticatedStatus.Failed.equals((Object)employeeConDto.getAuthenticateStatus())).count()), Long.valueOf(employeeConDtos.stream().filter(employeeConDto -> OccupationType.SecurityGuard.equals((Object)employeeConDto.getOccupationType()) && employeeConDto.getContractCount() > 0L).count()));
    }

    public ContractReportDto findContractReport(String organizationId, ContractCriteria criteria) {
        TenantUserContext userContext;
        Date dueDate = DateUtils.addMonths((Date)new Date(), (int)1);
        String qString = "select new com.bcxin.tenant.domain.repositories.dtos.ContractReportDto(count(CASE WHEN c.id is not null THEN 1 END),count(CASE WHEN c.status = 1 and e.status <> 1 and (c.attachment is null or c.attachment ='') THEN 1 END),count(CASE WHEN c.status = 1 and e.status <> 1 and now() between c.beginDate and c.endDate and c.attachment is not null and c.attachment !='' THEN 1 END),count(CASE WHEN c.status = 1 and e.status <> 1 and c.beginDate > now() THEN 1 END),count(CASE WHEN c.status = 1 and e.status <> 1 and c.dateLimitless=0 and c.endDate > now() and c.endDate < :dueDate THEN 1 END),count(CASE WHEN c.id is not null and (c.status = 0 or e.status = 1 or (c.dateLimitless=0 and c.endDate < now())) THEN 1 END),count(CASE WHEN c.id is null THEN 1 END),count(CASE WHEN c.id is null and e.occupationType = 1 THEN 1 END),count(CASE WHEN c.id is not null and e.status = 1 THEN 1 END))  from EmployeeEntity e inner join e.tenantUser t left join ContractEntity c on c.employee=e where e.organization.id=:organizationId ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        parameters.put("dueDate", dueDate);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or t.selectedCredential.number like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeId())) {
            qString = qString + " and e.id=:employeeId1 ";
            parameters.put("employeeId1", criteria.getEmployeeId());
        }
        if (criteria.getOccupationTypes() != null && criteria.getOccupationTypes().size() > 0) {
            qString = qString + " and e.occupationType in :occupationTypes";
            parameters.put("occupationTypes", criteria.getOccupationTypes());
        }
        if (criteria.getEmploymentStatus() != null) {
            qString = qString + " and e.status=:employmentStatus";
            parameters.put("employmentStatus", criteria.getEmploymentStatus());
        }
        if (criteria.getStatus() != null) {
            switch (criteria.getStatus()) {
                case INCOMPLETE: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and (c.attachment is null or c.attachment ='') ";
                    break;
                }
                case BEEFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.beginDate > now() ";
                    break;
                }
                case EFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and now() between c.beginDate and c.endDate and c.attachment is not null and c.attachment !='' ";
                    break;
                }
                case STOP: {
                    qString = qString + " and (c.status = 0 or e.status = 1 or (c.dateLimitless=0 and c.endDate < now())) ";
                    break;
                }
                case DUE: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.dateLimitless=0 and now() between :dueDate and c.endDate ";
                    parameters.put("dueDate", dueDate);
                    break;
                }
            }
        }
        if (criteria.getDepartIds() != null && criteria.getDepartIds().size() > 0) {
            qString = qString + " and d.department.id in :departIds";
            parameters.put("departIds", criteria.getDepartIds());
        }
        if (criteria.getBeginDate() != null) {
            qString = qString + " and c.beginDate >=:beginDate";
            parameters.put("beginDate", criteria.getBeginDate());
        }
        if (criteria.getEndDate() != null) {
            qString = qString + " and c.endDate <=:endDate";
            parameters.put("endDate", criteria.getEndDate());
        }
        if ((userContext = TenantContext.getInstance().getUserContext()) != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists(select 1 from e.departmentEmployeeRelations k join k.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            parameters.put("employeeId", userContext.get().getEmployeeId());
        }
        TypedQuery employeeContractDtoTypedQuery = this.entityManager.createQuery(qString, ContractReportDto.class);
        for (String key : parameters.keySet()) {
            employeeContractDtoTypedQuery.setParameter(key, parameters.get(key));
        }
        return (ContractReportDto)employeeContractDtoTypedQuery.getSingleResult();
    }

    public Collection<EmployeeBasicDto> getSuperiorEmployeeBasics(String organizationId, Collection<String> ids) {
        TypedQuery employeeBasicDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeBasicDto(e.id,'','',true, e.status,e.masterSlaveType)  from EmployeeEntity e where e.organization.id=?1 and e.id in (?2) and exists(select 1 from EmployeeEntity e2 where e2.superior.id=e.id and e2.status = 0) ", EmployeeBasicDto.class);
        employeeBasicDtoTypedQuery.setParameter(1, (Object)organizationId);
        employeeBasicDtoTypedQuery.setParameter(2, ids);
        return employeeBasicDtoTypedQuery.getResultList();
    }

    public Collection<EmployeeCompositeDto> getEmployeeComposites(String organizationId, Collection<String> ids) {
        TypedQuery employeeCompositeDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeCompositeDto(e,(select true from EmployeeEntity e2 where e2.superior.id=e.id))  from EmployeeEntity e where e.organization.id=?1 and e.id in (?2) ", EmployeeCompositeDto.class);
        employeeCompositeDtoTypedQuery.setParameter(1, (Object)organizationId);
        employeeCompositeDtoTypedQuery.setParameter(2, ids);
        return employeeCompositeDtoTypedQuery.getResultList();
    }

    public Pageable<EmployeeContractDto> findEmployeeContracts(String organizationId, EmployeeContractCriteria criteria) {
        TenantUserContext userContext;
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.EmployeeContractDto(c.id,c.name,sc.number,sc.credentialType,c.aName,c.bName,e.id,t.name,t.telephone,e.occupationType,e.status,c.beginDate,c.endDate,  c.dateLimitless,c.attachment,c.note,c.status,c.lastModifier, c.creator)  from ContractEntity c join c.employee e join e.tenantUser t left join t.selectedCredential sc where c.organization.id=:organizationId ";
        String cString = "select count(1) from ContractEntity c join c.employee e join e.tenantUser t left join t.selectedCredential sc where c.organization.id=:organizationId ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("organizationId", organizationId);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword or t.selectedCredential.number like :keyword)";
            cString = cString + " and (t.name like :keyword or t.telephone like :keyword or t.selectedCredential.number like :keyword)";
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeId())) {
            qString = qString + " and e.id=:employeeId1 ";
            cString = cString + " and e.id=:employeeId1 ";
            parameters.put("employeeId1", criteria.getEmployeeId());
        }
        if (criteria.getOccupationTypes() != null && criteria.getOccupationTypes().size() > 0) {
            qString = qString + " and e.occupationType in :occupationTypes";
            cString = cString + " and e.occupationType in :occupationTypes";
            parameters.put("occupationTypes", criteria.getOccupationTypes());
        }
        if (criteria.getEmploymentStatus() != null) {
            qString = qString + " and e.status=:employmentStatus";
            cString = cString + " and e.status=:employmentStatus";
            parameters.put("employmentStatus", criteria.getEmploymentStatus());
        }
        if (criteria.getStatus() != null) {
            switch (criteria.getStatus()) {
                case INCOMPLETE: {
                    qString = qString + " and c.status = 1 and e.status <> 1  and c.endDate >= now() and (c.attachment is null or c.attachment ='') ";
                    cString = cString + " and c.status = 1 and e.status <> 1  and c.endDate >= now()  and (c.attachment is null or c.attachment ='') ";
                    break;
                }
                case BEEFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.beginDate > now() ";
                    cString = cString + " and c.status = 1 and e.status <> 1 and c.beginDate > now() ";
                    break;
                }
                case EFFECT: {
                    qString = qString + " and c.status = 1 and e.status <> 1 and now() between c.beginDate and c.endDate and c.attachment is not null and c.attachment !='' ";
                    cString = cString + " and c.status = 1 and e.status <> 1 and now() between c.beginDate and c.endDate and c.attachment is not null and c.attachment !='' ";
                    break;
                }
                case STOP: {
                    qString = qString + " and (c.status = 0 or e.status = 1 or (c.dateLimitless=0 and c.endDate < now())) ";
                    cString = cString + " and (c.status = 0 or e.status = 1 or (c.dateLimitless=0 and c.endDate < now())) ";
                    break;
                }
                case DUE: {
                    Date dueDate = DateUtils.addMonths((Date)new Date(), (int)1);
                    qString = qString + " and c.status = 1 and e.status <> 1 and c.dateLimitless=0 and c.endDate between now() and  :dueDate";
                    cString = cString + " and c.status = 1 and e.status <> 1 and c.dateLimitless=0 and  c.endDate between now() and  :dueDate";
                    parameters.put("dueDate", dueDate);
                    break;
                }
            }
        }
        if (criteria.getDepartIds() != null && criteria.getDepartIds().size() > 0) {
            qString = qString + " and exists(select d from DepartmentEmployeeRelationEntity d where d.employee.id=e.id and d.department.id in :departIds)";
            cString = cString + " and exists(select d from DepartmentEmployeeRelationEntity d where d.employee.id=e.id and d.department.id in :departIds)";
            parameters.put("departIds", criteria.getDepartIds());
        }
        if (criteria.getBeginDate() != null) {
            qString = qString + " and c.beginDate >=:beginDate";
            cString = cString + " and c.beginDate >=:beginDate";
            parameters.put("beginDate", criteria.getBeginDate());
        }
        if (criteria.getEndDate() != null) {
            qString = qString + " and c.endDate <=:endDate";
            cString = cString + " and c.endDate <=:endDate";
            parameters.put("endDate", criteria.getEndDate());
        }
        if (criteria.getBeginCreatedTime() != null) {
            qString = qString + " and DATE(c.creator.createdTime) >= DATE(:beginCreatedTime)";
            cString = cString + " and DATE(c.creator.createdTime) >= DATE(:beginCreatedTime)";
            parameters.put("beginCreatedTime", criteria.getBeginCreatedTime());
        }
        if (criteria.getEndCreatedTime() != null) {
            qString = qString + " and DATE(c.creator.createdTime) <= DATE(:endCreatedTime)";
            cString = cString + " and DATE(c.creator.createdTime) <= DATE(:endCreatedTime)";
            parameters.put("endCreatedTime", criteria.getEndCreatedTime());
        }
        if ((userContext = TenantContext.getInstance().getUserContext()) != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists(select 1 from e.departmentEmployeeRelations k join k.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            cString = cString + " and exists(select 1 from e.departmentEmployeeRelations k join k.department dp join DepartmentEntity dade on dp.indexTree LIKE concat(dade.indexTree,'%') join DepartmentAdminEntity da on da.employee.id=:employeeId and da.department.id = dade.id )";
            parameters.put("employeeId", userContext.get().getEmployeeId());
        }
        qString = qString + " order by c.endDate ";
        TypedQuery employeeContractDtoTypedQuery = this.entityManager.createQuery(qString, EmployeeContractDto.class);
        TypedQuery totalCountQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            employeeContractDtoTypedQuery.setParameter(key, parameters.get(key));
            totalCountQuery.setParameter(key, parameters.get(key));
        }
        long totalCount = (Long)totalCountQuery.getSingleResult();
        List list = employeeContractDtoTypedQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        if (list.size() > 0) {
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in :employeeIds", DepartDto.class);
            List employeeIds = list.stream().map(EmployeeContractDto::getEmployeeId).collect(Collectors.toList());
            mapTypedQuery.setParameter("employeeIds", employeeIds);
            List departDtos = mapTypedQuery.getResultList();
            Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (EmployeeContractDto employeeContractDto : list) {
                employeeContractDto.setContractStatus(criteria.getStatus());
                if (departMap.get(employeeContractDto.getEmployeeId()) == null) continue;
                employeeContractDto.setEmployeeDepartName(departMap.get(employeeContractDto.getEmployeeId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(",")));
            }
        }
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), (Collection)list);
    }

    public Collection<Map<String, EmployeeEntity>> getEmployeesByTelephones(String organizationId, Collection<String> telephones) {
        String qString = "select new map(t.telephone,u) from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.telephone in (?2)";
        TypedQuery mapTypedQuery = this.entityManager.createQuery(qString, Map.class);
        mapTypedQuery.setParameter(1, (Object)organizationId);
        mapTypedQuery.setParameter(2, telephones);
        List mapList = mapTypedQuery.getResultList();
        ArrayList<Map<String, EmployeeEntity>> response = new ArrayList<Map<String, EmployeeEntity>>();
        for (Map item : mapList) {
            HashMap<String, EmployeeEntity> mpItem = new HashMap<String, EmployeeEntity>();
            mpItem.put((String)item.get("0"), (EmployeeEntity)item.get("1"));
            response.add(mpItem);
        }
        return response;
    }

    public Collection<Map<String, EmployeeEntity>> getEmployeesByIdNums(String organizationId, Collection<String> idNums) {
        String qString = "select new map(sc.number,u) from EmployeeEntity u join u.tenantUser t join t.selectedCredential sc where u.organization.id=?1 and sc.number in (?2)";
        TypedQuery mapTypedQuery = this.entityManager.createQuery(qString, Map.class);
        mapTypedQuery.setParameter(1, (Object)organizationId);
        mapTypedQuery.setParameter(2, idNums);
        List mapList = mapTypedQuery.getResultList();
        ArrayList<Map<String, EmployeeEntity>> response = new ArrayList<Map<String, EmployeeEntity>>();
        for (Map item : mapList) {
            HashMap<String, EmployeeEntity> mpItem = new HashMap<String, EmployeeEntity>();
            mpItem.put((String)item.get("0"), (EmployeeEntity)item.get("1"));
            response.add(mpItem);
        }
        return response;
    }

    public Collection<String> getMyOrganApps(String organId) {
        try {
            TypedQuery typedQuery = this.entityManager.createQuery("select t.bindApplication from TDomainEntity t where t.id=?1", String.class);
            typedQuery.setParameter(1, (Object)organId);
            String bindAppJson = (String)typedQuery.getSingleResult();
            return this.jsonProvider.toObjects(String.class, bindAppJson);
        }
        catch (NoResultException ex) {
            return Collections.EMPTY_LIST;
        }
    }

    public EmployeeDetailDto getByEmployeeId(String organId, String employeeId) {
        TypedQuery employeeDetailDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeDetailDto(e.id,e.insure, xd.id,xd.name,s.id, t2.name,e.hiredDate,e.positiveDate,e.position,e.occupationType,t.id,t.name,t.email,t.wechatNicky, t.telephone, t.lonLatJson, t.checkedStatus,t.authenticateStatus,t.authenticatedResult,t.headPhoto,t.sex,t.nation,t.workYear,t.diseasesHistory,t.politicsStatus,t.stature,t.militaryStatus,t.birthdate,t.education,t.householdType,t.nativePlace,t.maritalStatus,t.oneInchColorWhitePhoto,t.twoInchColorBluePhoto,e.masterSlaveType,t.cid,t.emergencyContact,t.emergencyPhone,t.licenseLevel,t.placeOfNow,sc.credentialType,sc.name, sc.number,sc.validDateFrom,sc.validDateTo,sc.frontPhoto,sc.reversePhoto,sc.address,sc.headPhoto,e.leaveTime,e.leaveNote,t.thirdPartyLoginNo,t.imIdentity,e.interview,e.personStatus,e.probation,e.planPositiveDate,t.CertificateImage,e.salary)  from EmployeeEntity e join e.tenantUser t left join e.departmentEmployeeRelations x left join x.department xd  left join t.selectedCredential sc  left join e.superior s left join s.tenantUser t2 where e.organization.id=?1 and e.id=?2", EmployeeDetailDto.class);
        employeeDetailDtoTypedQuery.setParameter(1, (Object)organId);
        employeeDetailDtoTypedQuery.setParameter(2, (Object)employeeId);
        List employeeDetailDtos = employeeDetailDtoTypedQuery.getResultList();
        Optional employeeDetailOptional = employeeDetailDtos.stream().findFirst();
        if (employeeDetailOptional.isPresent()) {
            EmployeeDetailDto employeeDetailDto = (EmployeeDetailDto)employeeDetailOptional.get();
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id =:employeeId", DepartDto.class);
            mapTypedQuery.setParameter("employeeId", (Object)employeeDetailDto.getEmployeeId());
            List departDtos = mapTypedQuery.getResultList();
            employeeDetailDto.assignDepart(departDtos);
            return employeeDetailDto;
        }
        return null;
    }

    public InviteUserDto getByOranIdAndPhone(String organId, String phone) {
        TypedQuery inviteUserDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.InviteUserDto(e.id,t2.name,e.hiredDate,e.occupationType,sc.credentialType,sc.number)  from EmployeeEntity e join e.tenantUser t left join t.selectedCredential sc  left join e.superior s left join s.tenantUser t2 where e.organization.id=?1 and t.telephone=?2", InviteUserDto.class);
        inviteUserDtoTypedQuery.setParameter(1, (Object)organId);
        inviteUserDtoTypedQuery.setParameter(2, (Object)phone);
        List inviteUsers = inviteUserDtoTypedQuery.getResultList();
        Optional inviteUserOptional = inviteUsers.stream().findFirst();
        if (inviteUserOptional.isPresent()) {
            return (InviteUserDto)inviteUserOptional.get();
        }
        return null;
    }

    public InviteUserDto getByPhone(String phone) {
        TypedQuery inviteUserDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.InviteUserDto(t.name,sc.credentialType,sc.number,t.cid)  from TenantUserEntity t left join t.selectedCredential sc where t.telephone=?1", InviteUserDto.class);
        inviteUserDtoTypedQuery.setParameter(1, (Object)phone);
        List inviteUserDtos = inviteUserDtoTypedQuery.getResultList();
        Optional inviteUserOptional = inviteUserDtos.stream().findFirst();
        if (inviteUserOptional.isPresent()) {
            return (InviteUserDto)inviteUserOptional.get();
        }
        return null;
    }

    public InviteUserDto getByOranIdAndIdNum(String organId, String idNum) {
        TypedQuery inviteUserDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.InviteUserDto(e.id,t2.name,e.hiredDate,e.occupationType,sc.credentialType,sc.number)  from EmployeeEntity e join e.tenantUser t left join t.selectedCredential sc  left join e.superior s left join s.tenantUser t2 where e.organization.id=?1 and sc.number=?2", InviteUserDto.class);
        inviteUserDtoTypedQuery.setParameter(1, (Object)organId);
        inviteUserDtoTypedQuery.setParameter(2, (Object)idNum);
        List inviteUsers = inviteUserDtoTypedQuery.getResultList();
        Optional inviteUserOptional = inviteUsers.stream().findFirst();
        if (inviteUserOptional.isPresent()) {
            return (InviteUserDto)inviteUserOptional.get();
        }
        return null;
    }

    public InviteUserDto getByIdNum(String idNum) {
        TypedQuery inviteUserDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.InviteUserDto(t.name,sc.credentialType,sc.number)  from TenantUserEntity t left join t.selectedCredential sc where sc.number=?1", InviteUserDto.class);
        inviteUserDtoTypedQuery.setParameter(1, (Object)idNum);
        List inviteUserDtos = inviteUserDtoTypedQuery.getResultList();
        Optional inviteUserOptional = inviteUserDtos.stream().findFirst();
        if (inviteUserOptional.isPresent()) {
            return (InviteUserDto)inviteUserOptional.get();
        }
        return null;
    }

    public Pageable<OrganizationAdminDto> searchOrganAdmins(OrganizationAdminCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.OrganizationAdminDto(e.id,t.name,t.telephone, (select max(k.department.name) from e.departmentEmployeeRelations k ) ) from EmployeeEntity e join e.tenantUser t where e.domainAdmin=com.bcxin.Infrastructures.enums.TrueFalseStatus.True and e.organization.id=:id ";
        String cString = "select count(1) from EmployeeEntity e join e.tenantUser t where e.domainAdmin=com.bcxin.Infrastructures.enums.TrueFalseStatus.True and e.organization.id=:id  ";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", criteria.getOrganizationId());
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            qString = qString + " and (t.name like :keyword or t.telephone like :keyword) ";
            cString = cString + " and (t.name like :keyword or t.telephone like :keyword) ";
            params.put("keyword", criteria.getKeyword());
        }
        TypedQuery organizationAdminDtoTypedQuery = this.entityManager.createQuery(qString, OrganizationAdminDto.class);
        TypedQuery longTypedQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : params.keySet()) {
            organizationAdminDtoTypedQuery.setParameter(key, params.get(key));
            longTypedQuery.setParameter(key, params.get(key));
        }
        Long totalCount = (Long)longTypedQuery.getSingleResult();
        List organizations = organizationAdminDtoTypedQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)totalCount.intValue(), (Collection)organizations);
    }

    public Collection<String> getDuplicatedEmployeeRelationIds(Collection<String> sourceDepartIds, String destDepartId) {
        String qString = "select x.id from DepartmentEmployeeRelationEntity x where x.department.id in (?1) and x.employee.id in (select j.employee.id from DepartmentEmployeeRelationEntity j where j.department.id =?2)";
        TypedQuery typedQuery = this.entityManager.createQuery(qString, String.class);
        typedQuery.setParameter(1, sourceDepartIds);
        typedQuery.setParameter(2, (Object)destDepartId);
        return typedQuery.getResultList();
    }

    public boolean checkIfNotMatchLeaveCondition(Collection<String> employeeIds) {
        Query notMatchedEmployeeLeaveQuery = this.entityManager.createNativeQuery("select count(1) from vm_not_matched_employee_leave_condition k where k.id in (?1)");
        notMatchedEmployeeLeaveQuery.setParameter(1, employeeIds);
        Object result = notMatchedEmployeeLeaveQuery.getSingleResult();
        Long count = Long.parseLong(String.valueOf(result));
        return count <= 0L;
    }

    public List<EmployeeConditionDto> matchLeaveCondition(Collection<String> employeeIds) {
        Query notMatchedEmployeeLeaveQuery = this.entityManager.createNativeQuery("select k.id as employeeId,k.info from vm_not_matched_employee_leave_condition k where k.id in (?1) ");
        ((SQLQuery)notMatchedEmployeeLeaveQuery.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(EmployeeConditionDto.class));
        notMatchedEmployeeLeaveQuery.setParameter(1, employeeIds);
        return notMatchedEmployeeLeaveQuery.getResultList();
    }

    public List<EmployeeConditionDto> matchForAttendSite(Collection<String> employeeIds) {
        Query notMatchedEmployeeLeaveQuery = this.entityManager.createNativeQuery("select k.employeeId,k.info from vm_not_matched_employee_leave_condition_attend_site k where k.employeeId in (?1) ");
        ((SQLQuery)notMatchedEmployeeLeaveQuery.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(EmployeeConditionDto.class));
        notMatchedEmployeeLeaveQuery.setParameter(1, employeeIds);
        return notMatchedEmployeeLeaveQuery.getResultList();
    }

    public List<OrganizationExportDto> searchOrgList(com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria criteria) {
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationExportDto(o.name,o.approvedInformationValueType.status,o.industryCode,o.institutionalCode,o.placeOfRegister,o.placeOfBusiness,o.createdTime,o.approvedInformationValueType.lastUpdatedTime,(select regionFullName from RegionEntity r where r.id = o.superviseRegionCode), o.superviseDepartName)");
        sqlStr.append(" from OrganizationEntity o where 1=1 ");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getName())) {
            parameters.put("name", "%".concat(criteria.getName()).concat("%"));
            sqlStr.append(" and o.name like :name");
        }
        if (StringUtils.hasLength((String)criteria.getIndustryCode())) {
            parameters.put("industryCode", criteria.getIndustryCode());
            sqlStr.append(" and o.industryCode = :industryCode");
        }
        if (criteria.getPlaceOfSupervise() != null && criteria.getPlaceOfSupervise().getDistrict() != null && StringUtils.hasLength((String)criteria.getPlaceOfSupervise().getDistrict().getCode())) {
            parameters.put("superviseRegionCode", criteria.getPlaceOfSupervise().getDistrict().getCode());
            sqlStr.append(" and o.superviseRegionCode = :superviseRegionCode ");
        }
        if (criteria.getStatuses() != null && criteria.getStatuses().size() > 0) {
            Collection statuses = criteria.getStatuses();
            if (criteria.getStatuses().contains(ApprovedStatus.Init)) {
                sqlStr.append(" and (o.approvedInformationValueType.status=null or o.approvedInformationValueType.status in (:status)) ");
            } else {
                sqlStr.append(" and o.approvedInformationValueType.status in (:status) ");
            }
            parameters.put("status", statuses);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getStartDate())) {
            sqlStr.append(" and o.createdTime >='" + criteria.getStartDate() + "' ");
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getEndDate())) {
            sqlStr.append(" and o.createdTime <='" + criteria.getEndDate() + " 23:59:59' ");
        }
        TypedQuery organizationQuery = this.entityManager.createQuery(sqlStr.toString() + " order by o.createdTime desc,o.approvedInformationValueType.status asc", OrganizationExportDto.class);
        for (String key : parameters.keySet()) {
            organizationQuery.setParameter(key, parameters.get(key));
        }
        List organizations = organizationQuery.getResultList();
        return organizations;
    }

    public List<OrganizationExportDto> searchOrgList(com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria criteria, Collection<String> industryCodes) {
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationExportDto(o.name,o.approvedInformationValueType.status,o.industryCode,o.institutionalCode,o.placeOfRegister,o.placeOfBusiness,o.createdTime,o.approvedInformationValueType.lastUpdatedTime,(select regionFullName from RegionEntity r where r.id = o.superviseRegionCode), o.superviseDepartName)");
        sqlStr.append(" from OrganizationEntity o where 1=1 ");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getName())) {
            parameters.put("name", "%".concat(criteria.getName()).concat("%"));
            sqlStr.append(" and o.name like :name");
        }
        if (industryCodes != null && !industryCodes.isEmpty()) {
            parameters.put("industryCodes", industryCodes);
            sqlStr.append(" and o.industryCode in (:industryCodes)");
        }
        if (criteria.getPlaceOfSupervise() != null && criteria.getPlaceOfSupervise().getDistrict() != null && StringUtils.hasLength((String)criteria.getPlaceOfSupervise().getDistrict().getCode())) {
            parameters.put("superviseRegionCode", criteria.getPlaceOfSupervise().getDistrict().getCode());
            sqlStr.append(" and o.superviseRegionCode = :superviseRegionCode ");
        }
        if (criteria.getStatuses() != null && criteria.getStatuses().size() > 0) {
            Collection statuses = criteria.getStatuses();
            if (criteria.getStatuses().contains(ApprovedStatus.Init)) {
                sqlStr.append(" and (o.approvedInformationValueType.status=null or o.approvedInformationValueType.status in (:status)) ");
            } else {
                sqlStr.append(" and o.approvedInformationValueType.status in (:status) ");
            }
            parameters.put("status", statuses);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getStartDate())) {
            sqlStr.append(" and o.createdTime >='" + criteria.getStartDate() + "' ");
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getEndDate())) {
            sqlStr.append(" and o.createdTime <='" + criteria.getEndDate() + " 23:59:59' ");
        }
        TypedQuery organizationQuery = this.entityManager.createQuery(sqlStr.toString() + " order by o.createdTime desc,o.approvedInformationValueType.status asc", OrganizationExportDto.class);
        for (String key : parameters.keySet()) {
            organizationQuery.setParameter(key, parameters.get(key));
        }
        List organizations = organizationQuery.getResultList();
        return organizations;
    }

    public List<EmployeeExportViewEntity> searchEmployeeList(String organizationId, EmployeeCriteria criteria) {
        LocalDate now;
        String exists;
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            sb.append(" and (t.name like :keyword or t.telephone like :keyword or s.number like :keyword)");
            parameters.put("keyword", "%" + criteria.getKeyword() + "%");
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCredentialTypes())) {
            sb.append(" and s.credentialType in :credentialType");
            parameters.put("credentialType", criteria.getCredentialTypes());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getAuthenticatedStatuses())) {
            sb.append(" and t.authenticateStatus in :authenticateStatus");
            parameters.put("authenticateStatus", criteria.getAuthenticatedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCheckedStatuses())) {
            sb.append(" and t.checkedStatus in :checkedStatus");
            parameters.put("checkedStatus", criteria.getCheckedStatuses());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getOccupationTypes())) {
            sb.append(" and e.occupationType in :occupationType");
            parameters.put("occupationType", criteria.getOccupationTypes());
        }
        if (criteria.getHiredDate() != null) {
            sb.append(" and e.hiredDate=:hiredDate ");
            parameters.put("hiredDate", criteria.getHiredDate());
        }
        if (StringUtils.hasLength((String)criteria.getPosition())) {
            sb.append(" and e.position = :position ");
            parameters.put("position", criteria.getPosition());
        }
        if (criteria.getStartDate() != null) {
            sb.append(" and e.hiredDate >=:startDate ");
            parameters.put("startDate", criteria.getStartDate());
        }
        if (criteria.getEndDate() != null) {
            sb.append(" and e.hiredDate <=:endDate ");
            parameters.put("endDate", criteria.getEndDate());
        }
        if ("1".equals(criteria.getContractStatus())) {
            sb.append(" and exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        if ("0".equals(criteria.getContractStatus())) {
            sb.append(" and not exists(select ct from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate) ");
        }
        Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
        OrganizationEntity organizationEntity = (OrganizationEntity)organizationOptional.get();
        String areaCode = organizationEntity.getSuperviseRegionCode();
        if (StrUtil.isNotEmpty((CharSequence)criteria.getCerStatus())) {
            exists = " ";
            if ("0".equals(criteria.getCerStatus())) {
                exists = " not ";
            }
            sb.append(" and " + exists + " exists(select tucd from  TenantUserCredentialDetailsEntity tucd where t.id=tucd.tenantUserId  and tucd.state = '1' and tucd.active = true and tucd.certificateType='1'");
            if (!AuthUtil.isUnDistinguishArea()) {
                sb.append(" and tucd.areaCode like :areaCode ");
                parameters.put("areaCode", AuthUtil.getShortAreaCode((String)areaCode) + "%");
            }
            sb.append(") ");
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getGradeCerStatus()) || CollUtil.isNotEmpty((Collection)criteria.getLevel())) {
            exists = " ";
            if ("0".equals(criteria.getCerStatus())) {
                exists = " not ";
            }
            sb.append(" and " + exists + " exists(select tucd from  TenantUserCredentialDetailsEntity tucd  where t.id=tucd.tenantUserId and  tucd.state = '1' and tucd.active = true and tucd.certificateType='2'");
            if (StringUtils.hasLength((String)areaCode)) {
                sb.append(" and tucd.areaCode like :areaCode ");
                parameters.put("areaCode", AuthUtil.getShortAreaCode((String)areaCode) + "%");
            }
            if (CollUtil.isNotEmpty((Collection)criteria.getLevel())) {
                sb.append(" and tucd.appraisalGrade in :gradeLevels");
                Collection level = criteria.getLevel();
                ArrayList<String> gradeLevels = new ArrayList<String>();
                for (Integer i2 : level) {
                    gradeLevels.add(i2.toString());
                }
                parameters.put("gradeLevels", gradeLevels);
            }
            sb.append(") ");
        }
        if (criteria.getBeginAge() != null) {
            now = LocalDate.now();
            LocalDate bTime = now.minus(criteria.getBeginAge().intValue(), ChronoUnit.YEARS);
            sb.append(" and  t.birthdate <= :bTime");
            parameters.put("bTime", Date.from(bTime.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (criteria.getEndAge() != null) {
            now = LocalDate.now();
            LocalDate eTime = now.minus(criteria.getEndAge() + 1, ChronoUnit.YEARS);
            sb.append(" and  t.birthdate >= :eTime");
            parameters.put("eTime", Date.from(eTime.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (criteria.getInsure() != null) {
            if (criteria.getInsure().equals((Object)TrueFalseStatus.False)) {
                sb.append(" and  (e.insure = :insure or e.insure is null) ");
            } else {
                sb.append(" and  e.insure = :insure ");
            }
            parameters.put("insure", criteria.getInsure());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getBackgroundScreeningStatus())) {
            sb.append(" and t.backgroundScreeningStatus in :backgroundScreeningStatus");
            parameters.put("backgroundScreeningStatus", criteria.getBackgroundScreeningStatus());
        }
        String qString = "select new com.bcxin.tenant.domain.entities.EmployeeExportViewEntity(e.id,t.id,t.name,t.telephone,s.credentialType,s.number,t.checkedStatus,t.lastCheckedStatusTime,t.authenticateStatus,t.authenticatedResult,e.occupationType,p.name,e.position,e.hiredDate,e.positiveDate,t.sex,t.birthdate,t.nation,t.education,t.politicsStatus,t.householdType,t.stature,t.nativePlace,t.militaryStatus,t.maritalStatus,s.validDateFrom,s.validDateTo,s.address,(select count(1) from ContractEntity ct where ct.employee = e and ct.status=1 and CURDATE() between ct.beginDate and ct.endDate)>0,e.insure,e.createdTime,e.domainAdmin,e.organization.id,e.personStatus,e.probation,e.planPositiveDate,t.emergencyContact,t.emergencyPhone,t.licenseLevel,t.placeOfNow,e.hiredOperator)  from EmployeeEntity e join e.tenantUser t left join e.superior.tenantUser p left join t.selectedCredential s  where e.status!=com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob ";
        if (StrUtil.isNotEmpty((CharSequence)organizationId)) {
            qString = qString + " and e.organization.id=:organId ";
            parameters.put("organId", organizationId);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getOrganName())) {
            qString = qString + " and e.organization.name like '%:organName%' ";
            parameters.put("organName", criteria.getOrganName());
        }
        qString = qString + sb;
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (!criteria.isIgnorePermission() && userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            if (userContext.get().isDepartAdmin()) {
                String deptAdminSql = this.getDeptAdminSql(criteria.getTreeCodes());
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))) or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE k.department.id IN (:departmentIds) " + deptAdminSql + " ))";
                    parameters.put("departmentIds", criteria.getDepartIds());
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (e.id=:selfEmployeeId or exists (SELECT k FROM e.departmentEmployeeRelations k WHERE 1=1 " + deptAdminSql + " ))";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            } else {
                if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
                    qString = qString + " and ((e.id=:selfEmployeeId and exists(select k from e.departmentEmployeeRelations k where k.department.id in (:selfDepartmentIds))))";
                    parameters.put("selfDepartmentIds", criteria.getDepartIds());
                } else {
                    qString = qString + " and (e.id=:selfEmployeeId)";
                }
                parameters.put("selfEmployeeId", userContext.get().getEmployeeId());
            }
        } else if (!CollectionUtils.isEmpty((Collection)criteria.getDepartIds())) {
            qString = qString + " and exists(select de from DepartmentEmployeeRelationEntity de where de.employee.id=e.id and de.department.id in (:departmentIds))";
            parameters.put("departmentIds", criteria.getDepartIds());
        }
        TypedQuery employeeTypedQuery = this.entityManager.createQuery(qString, EmployeeExportViewEntity.class);
        for (String key : parameters.keySet()) {
            employeeTypedQuery = employeeTypedQuery.setParameter(key, parameters.get(key));
        }
        Map<String, DepartmentDto> departMaps = this.getDepartMaps(criteria.getOrganizationId());
        List result = employeeTypedQuery.getResultList();
        Collection employeeIds = result.stream().map(ii -> ii.getId()).collect(Collectors.toList());
        if (employeeIds.size() > 0) {
            List<TenantUserCredentialDetailsEntity> tenantUserCredentialDetailsEntities;
            String finalAreaCode;
            List<TenantUserCredentialDetailsEntity> cerDetailList;
            Map<String, List<TenantUserCredentialDetailsEntity>> cerDetailMap;
            TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName,dp.indexTree) from DepartmentEmployeeRelationEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
            mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
            List departDtos = mapTypedQuery.getResultList();
            for (Object departDto : departDtos) {
                if (departMaps.get(departDto.getDepartId()) == null) continue;
                departDto.resetDepartName(departMaps.get(departDto.getDepartId()).getIndexTree());
            }
            Map<String, List<DepartDto>> departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (EmployeeExportViewEntity rt : result) {
                if (departMap.get(rt.getId()) == null) continue;
                rt.assignDepart(departMap.get(rt.getId()).stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")));
            }
            mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentAdminEntity de join de.department dp where de.employee.id in (:employeeIds)", DepartDto.class);
            mapTypedQuery.setParameter("employeeIds", (Object)employeeIds);
            departDtos = mapTypedQuery.getResultList();
            departMap = departDtos.stream().collect(Collectors.groupingBy(DepartDto::getEmployeeId));
            for (EmployeeExportViewEntity rt : result) {
                if (departMap.get(rt.getId()) == null) continue;
                rt.assignAdminDepart(departMap.get(rt.getId()).stream().sorted(Comparator.comparing(DepartDto::getDepartName, Comparator.nullsLast(String::compareTo))).map(DepartDto::getDepartName).collect(Collectors.joining(", ")));
            }
            List<TenantUserCredentialDetailsEntity> cerDetails = this.getCerDetailsByUserIds(CerType.Qualification.getTypeValue(), result.stream().map(EmployeeExportViewEntity::getUserId).collect(Collectors.toList()));
            List<TenantUserCredentialDetailsEntity> gradeDetails = this.getCerDetailsByUserIds(CerType.Grade.getTypeValue(), result.stream().map(EmployeeExportViewEntity::getUserId).collect(Collectors.toList()));
            if (cerDetails != null && cerDetails.size() > 0) {
                cerDetailMap = cerDetails.stream().collect(Collectors.groupingBy(i -> i.getTenantUserId()));
                for (EmployeeExportViewEntity rt : result) {
                    cerDetailList = cerDetailMap.get(rt.getUserId());
                    if (cerDetailList == null) continue;
                    finalAreaCode = areaCode;
                    for (TenantUserCredentialDetailsEntity tenantUserCredentialDetailsEntity : cerDetailList) {
                        if (!StrUtil.isNotEmpty((CharSequence)tenantUserCredentialDetailsEntity.getAreaCode()) || tenantUserCredentialDetailsEntity.getAreaCode().length() < 2) continue;
                        if (AuthUtil.getShortAreaCode((String)tenantUserCredentialDetailsEntity.getAreaCode()).equals(AuthUtil.getShortAreaCode((String)finalAreaCode))) {
                            rt.setCerStatus(TrueFalseStatus.True);
                            tenantUserCredentialDetailsEntities = cerDetailMap.get(rt.getUserId());
                            for (TenantUserCredentialDetailsEntity userCredentialDetailsEntity : tenantUserCredentialDetailsEntities) {
                                rt.setCerNo(userCredentialDetailsEntity.getCerNo());
                            }
                            continue;
                        }
                        if (tenantUserCredentialDetailsEntity.getAreaCode() != "#") continue;
                        rt.setCerStatus(TrueFalseStatus.False);
                    }
                }
            }
            if (gradeDetails != null && gradeDetails.size() > 0) {
                cerDetailMap = gradeDetails.stream().collect(Collectors.groupingBy(i -> i.getTenantUserId()));
                for (EmployeeExportViewEntity rt : result) {
                    cerDetailList = cerDetailMap.get(rt.getUserId());
                    if (cerDetailList == null) continue;
                    finalAreaCode = areaCode;
                    for (TenantUserCredentialDetailsEntity tenantUserCredentialDetailsEntity : cerDetailList) {
                        if (!StrUtil.isNotEmpty((CharSequence)tenantUserCredentialDetailsEntity.getAreaCode()) || tenantUserCredentialDetailsEntity.getAreaCode().length() < 2) continue;
                        if (AuthUtil.getShortAreaCode((String)tenantUserCredentialDetailsEntity.getAreaCode()).equals(AuthUtil.getShortAreaCode((String)finalAreaCode))) {
                            rt.setGradeCerStatus(TrueFalseStatus.True);
                            tenantUserCredentialDetailsEntities = cerDetailMap.get(rt.getUserId());
                            for (TenantUserCredentialDetailsEntity userCredentialDetailsEntity : tenantUserCredentialDetailsEntities) {
                                rt.setGradeCerNo(userCredentialDetailsEntity.getCerNo());
                                rt.setGradeLevel(userCredentialDetailsEntity.getGradeLevel().getTypeValue());
                            }
                            continue;
                        }
                        if (tenantUserCredentialDetailsEntity.getAreaCode() != "#") continue;
                        rt.setGradeCerStatus(TrueFalseStatus.False);
                    }
                }
            }
        }
        return result.stream().sorted(Comparator.comparing(EmployeeExportViewEntity::getDepartName, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
    }

    private List<TenantUserCredentialDetailsEntity> getCerDetailsByUserIds(String cerType, List<String> userIds) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder("select de from  TenantUserCredentialDetailsEntity de ");
        sql.append(" where de.tenantUserId in :userIds and de.certificateType= :cerType and de.state = '1' and de.active = true");
        TypedQuery mapTypedQuery = this.entityManager.createQuery(sql.toString(), TenantUserCredentialDetailsEntity.class);
        mapTypedQuery.setParameter("userIds", userIds);
        mapTypedQuery.setParameter("cerType", (Object)cerType);
        return mapTypedQuery.getResultList();
    }

    public Collection<DepartmentDto> getManagedDepartmentDtos(String organId) {
        String qString = "select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level, -1l, d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree)  from DepartmentEntity d where d.organization.id=?1 and d.deleted=false ";
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        HashMap<Integer, String> parameters = new HashMap<Integer, String>();
        parameters.put(1, organId);
        if (userContext != null && userContext.get() != null && !userContext.get().isMaster() && StringUtils.hasLength((String)userContext.get().getEmployeeId())) {
            qString = qString + " and exists (select da from DepartmentAdminEntity da where da.employee.id=?2 and d.indexTree like concat(da.department.indexTree ,'%'))";
            parameters.put(2, userContext.get().getEmployeeId());
        }
        TypedQuery departmentDtoTypedQuery = this.entityManager.createQuery(qString, DepartmentDto.class);
        for (Integer pIndex : parameters.keySet()) {
            departmentDtoTypedQuery.setParameter(pIndex.intValue(), parameters.get(pIndex));
        }
        return departmentDtoTypedQuery.getResultList();
    }

    public Collection<DepartmentDto> getAllManagedDepartmentDtos(String organId) {
        String qString = "select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level, -1l, d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree)  from DepartmentEntity d where d.organization.id=?1 and d.deleted=false ";
        HashMap<Integer, String> parameters = new HashMap<Integer, String>();
        parameters.put(1, organId);
        TypedQuery departmentDtoTypedQuery = this.entityManager.createQuery(qString, DepartmentDto.class);
        for (Integer pIndex : parameters.keySet()) {
            departmentDtoTypedQuery.setParameter(pIndex.intValue(), parameters.get(pIndex));
        }
        return departmentDtoTypedQuery.getResultList();
    }

    public Collection<EmployeeDepartIdDto> getEmployeeDepartIds(String organizationId, Collection<String> employeeIds) {
        TypedQuery employeeDepartIdDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeDepartIdDto(d.department.id,d.employee.id)  from DepartmentEmployeeRelationEntity d where d.employee.id in (?1)", EmployeeDepartIdDto.class);
        employeeDepartIdDtoTypedQuery.setParameter(1, employeeIds);
        return employeeDepartIdDtoTypedQuery.getResultList();
    }

    public int checkIfTelephoneExists(String telephone) {
        TypedQuery tenantUserCountQuery = this.entityManager.createQuery("select count(t) from TenantUserEntity t where t.telephone=?1", Long.class);
        tenantUserCountQuery.setParameter(1, (Object)telephone);
        Long count = (Long)tenantUserCountQuery.getSingleResult();
        return count.intValue();
    }

    public Pageable<OrganizationDto> searchOrganizations(OrganizationCriteria criteria) {
        String qString = "select new com.bcxin.tenant.domain.readers.dtos.OrganizationDto(o.id,o.code,o.name,o.approvedInformationValueType.status,o.industryCode,o.institutionalCode,o.placeOfRegister,o.placeOfBusiness,o.createdTime,o.approvedInformationValueType.lastUpdatedTime,o.lonLatJson,(select regionFullName from RegionEntity r where r.id = o.superviseRegionCode), o.superviseDepartName)  from OrganizationEntity o where 1=1 ";
        String cString = "select count(1) from OrganizationEntity o where 1=1 ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)criteria.getName())) {
            parameters.put("name", "%".concat(criteria.getName()).concat("%"));
            qString = qString + " and o.name like :name";
            cString = cString + " and o.name like :name";
        }
        if (criteria.getIndustryCodes() != null && !criteria.getIndustryCodes().isEmpty()) {
            parameters.put("industryCodes", criteria.getIndustryCodes());
            qString = qString + " and o.industryCode in (:industryCodes)";
            cString = cString + " and o.industryCode in (:industryCodes)";
        } else if (StringUtils.hasLength((String)criteria.getIndustryCode())) {
            parameters.put("industryCode", criteria.getIndustryCode());
            qString = qString + " and o.industryCode = :industryCode";
            cString = cString + " and o.industryCode = :industryCode";
        }
        if (StringUtils.hasLength((String)criteria.getSuperviseRegionCode())) {
            parameters.put("superviseRegionCode", criteria.getSuperviseRegionCode());
            qString = qString + " and o.superviseRegionCode = :superviseRegionCode";
            cString = cString + " and o.superviseRegionCode = :superviseRegionCode";
        }
        if (criteria.getStatuses() != null && criteria.getStatuses().size() > 0) {
            Collection statuses = criteria.getStatuses();
            if (criteria.getStatuses().contains(ApprovedStatus.Init)) {
                qString = qString + " and (o.approvedInformationValueType.status=null or o.approvedInformationValueType.status in (:status)) ";
                cString = cString + " and (o.approvedInformationValueType.status=null or o.approvedInformationValueType.status in (:status)) ";
            } else {
                qString = qString + " and o.approvedInformationValueType.status in (:status) ";
                cString = cString + " and o.approvedInformationValueType.status in (:status) ";
            }
            parameters.put("status", statuses);
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getStartDate())) {
            qString = qString + " and o.createdTime >='" + criteria.getStartDate() + "' ";
            cString = cString + " and o.createdTime >='" + criteria.getStartDate() + "' ";
        }
        if (StrUtil.isNotEmpty((CharSequence)criteria.getEndDate())) {
            qString = qString + " and o.createdTime <='" + criteria.getEndDate() + " 23:59:59' ";
            cString = cString + " and o.createdTime <='" + criteria.getEndDate() + " 23:59:59' ";
        }
        TypedQuery organizationQuery = this.entityManager.createQuery(qString + " order by o.createdTime desc,o.approvedInformationValueType.status asc", OrganizationDto.class);
        TypedQuery organizationCountQuery = this.entityManager.createQuery(cString, Long.class);
        for (String key : parameters.keySet()) {
            organizationQuery.setParameter(key, parameters.get(key));
            organizationCountQuery.setParameter(key, parameters.get(key));
        }
        Long totalCount = (Long)organizationCountQuery.getSingleResult();
        List organizations = organizationQuery.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)totalCount.intValue(), (Collection)organizations);
    }

    public TenantUserCredentialsDto getCertificateByEmployeeId(String employeeId) {
        TypedQuery tenantUserCredentialsQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.TenantUserCredentialsDto(t.name,t.number)  from EmployeeEntity sc join TenantUserCredentialsEntity t on t.tenantUser.id = sc.tenantUser.id and t.credentialType = com.bcxin.Infrastructures.enums.CredentialType.IdCard where sc.id=?1", TenantUserCredentialsDto.class);
        tenantUserCredentialsQuery.setParameter(1, (Object)employeeId);
        try {
            return (TenantUserCredentialsDto)tenantUserCredentialsQuery.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public TenantUserDto getTenantUserById(String id) {
        TypedQuery tenantDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.TenantUserDto(t.id,t.name,t.email,t.wechatNicky, t.telephone, t.lonLatJson, t.checkedStatus,t.authenticateStatus,t.authenticatedResult,t.headPhoto,t.sex,t.nation,t.workYear,t.diseasesHistory,t.politicsStatus,t.stature,t.militaryStatus,t.birthdate,t.education,t.householdType,t.nativePlace,t.maritalStatus,t.oneInchColorWhitePhoto,t.twoInchColorBluePhoto,t.cid,t.emergencyContact,t.emergencyPhone,t.licenseLevel,t.placeOfNow,sc.credentialType,sc.name, sc.number,sc.validDateFrom,sc.validDateTo,sc.frontPhoto,sc.reversePhoto,sc.address,sc.headPhoto,t.thirdPartyLoginNo,t.imIdentity,t.CertificateImage)  from TenantUserEntity t left join t.selectedCredential sc  where t.id=?1", TenantUserDto.class);
        tenantDtoTypedQuery.setParameter(1, (Object)id);
        try {
            return (TenantUserDto)tenantDtoTypedQuery.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public TenantUserDto getTenantUserByThirdPartyLoginNo(String id) {
        TypedQuery tenantDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.TenantUserDto(t.id,t.name,t.email,t.wechatNicky, t.telephone, t.lonLatJson, t.checkedStatus,t.authenticateStatus,t.authenticatedResult,t.headPhoto,t.sex,t.nation,t.workYear,t.diseasesHistory,t.politicsStatus,t.stature,t.militaryStatus,t.birthdate,t.education,t.householdType,t.nativePlace,t.maritalStatus,t.oneInchColorWhitePhoto,t.twoInchColorBluePhoto,t.cid,t.emergencyContact,t.emergencyPhone,t.licenseLevel,t.placeOfNow,sc.credentialType,sc.name, sc.number,sc.validDateFrom,sc.validDateTo,sc.frontPhoto,sc.reversePhoto,sc.address,sc.headPhoto,t.thirdPartyLoginNo,t.imIdentity,t.CertificateImage)  from TenantUserEntity t left join t.selectedCredential sc  where t.thirdPartyLoginNo=?1", TenantUserDto.class);
        tenantDtoTypedQuery.setParameter(1, (Object)id);
        try {
            return (TenantUserDto)tenantDtoTypedQuery.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<CompanyDto> exactSearch(String name, String unifySocialCreditCode) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.CompanyDto(u.id,u.name,c.unifySocialCreditCode)";
        sql = sql + " from OrganizationEntity u left join CompanyEntity c on c.id = u.id where 1=1 ";
        int index = 0;
        if (!StringUtils.isEmpty((Object)name)) {
            sql = sql + " and u.name=?" + ++index;
        }
        if (!StringUtils.isEmpty((Object)unifySocialCreditCode)) {
            sql = sql + " and c.unifySocialCreditCode=?" + ++index;
        }
        TypedQuery companyQuery = this.entityManager.createQuery(sql, CompanyDto.class);
        if (!StringUtils.isEmpty((Object)name)) {
            companyQuery.setParameter(1, (Object)name);
        }
        if (!StringUtils.isEmpty((Object)unifySocialCreditCode)) {
            companyQuery.setParameter(index, (Object)unifySocialCreditCode);
        }
        return companyQuery.getResultList();
    }

    public Collection<TenantEventEntity> getTopNTenantEvents(Long startVersion, Collection<String> mapKeys, Collection<String> eventIds, int topN) {
        String qString = "select t from TenantEventEntity t where t.version>?2 and t.mapKey in (?1)  ";
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        parameters.put(1, mapKeys);
        if (!CollectionUtils.isEmpty(eventIds)) {
            parameters.put(2, 0L);
            qString = qString + " and t.id in (?3) ";
            parameters.put(3, eventIds);
        } else {
            parameters.put(2, startVersion);
            qString = qString + " and t.createdTime<?3 ";
            parameters.put(3, Timestamp.from(Instant.now().minus(3L, ChronoUnit.MINUTES)));
        }
        qString = qString + " order by t.version asc";
        TypedQuery eventEntityTypedQuery = this.entityManager.createQuery(qString, TenantEventEntity.class);
        for (Integer key : parameters.keySet()) {
            eventEntityTypedQuery.setParameter(key.intValue(), parameters.get(key));
        }
        eventEntityTypedQuery = eventEntityTypedQuery.setMaxResults(topN);
        return eventEntityTypedQuery.getResultList();
    }

    public Collection<String> getTopNPendingTenantEvents(Collection<String> mapKeys, boolean isForFailed, int topN) {
        String qString = "select t.id from TenantEventEntity t where t.mapKey in (?1) and  (t.lastProcessedTime<?2 or (t.lastProcessedTime is null and t.createdTime<?3)) and t.status=?4 ";
        HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
        parameters.put(1, mapKeys);
        Timestamp comparedTimestamp = Timestamp.from(Instant.now().minus(5L, ChronoUnit.SECONDS));
        parameters.put(2, comparedTimestamp);
        parameters.put(3, comparedTimestamp);
        if (isForFailed) {
            parameters.put(4, EventProcessedStatus.Failed);
        } else {
            parameters.put(4, EventProcessedStatus.Init);
        }
        qString = qString + " order by t.lastProcessedTime asc";
        TypedQuery eventEntityTypedQuery = this.entityManager.createQuery(qString, String.class);
        for (Integer key : parameters.keySet()) {
            eventEntityTypedQuery.setParameter(key.intValue(), parameters.get(key));
        }
        eventEntityTypedQuery = eventEntityTypedQuery.setMaxResults(topN);
        return eventEntityTypedQuery.getResultList();
    }

    public Collection<EmployeeEntity> getEmployeesByIds(Collection<String> ids) {
        TypedQuery eventEntityTypedQuery = this.entityManager.createQuery("select t from EmployeeEntity t where t.id in (?1)", EmployeeEntity.class);
        eventEntityTypedQuery.setParameter(1, ids);
        return eventEntityTypedQuery.getResultList();
    }

    public List<EmployeeEntity> getEmployeesByUserId(String userId) {
        TypedQuery eventEntityTypedQuery = this.entityManager.createQuery("select t from EmployeeEntity t where t.tenantUser.id =?1 and t.status <> 1", EmployeeEntity.class);
        eventEntityTypedQuery.setParameter(1, (Object)userId);
        return eventEntityTypedQuery.getResultList();
    }

    public EmployeeBasicDto getEmployeeBasic(String organizationId, String id) {
        TypedQuery query = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeBasicDto(e.id,t.telephone,sc.number,false,e.status,e.masterSlaveType) from EmployeeEntity e join e.tenantUser t join t.selectedCredential sc  where e.organization.id = ?1 and e.id = ?2 ", EmployeeBasicDto.class);
        query.setParameter(1, (Object)organizationId);
        query.setParameter(2, (Object)id);
        List resultList = query.getResultList();
        if (resultList.size() > 0) {
            return (EmployeeBasicDto)resultList.get(0);
        }
        return null;
    }

    public Pageable<CredentialResponse> getCredentials(String id, String organizationId, GetCredentialRequest request) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", id);
        String sqlStr = "select a.id,a.create_time as created_time,a.fzjgmc as address,case a.certificateType when '1' then 7 when '2' then 8 when '3' then 9 when '11' then 11 when '12' then 12 when '13' then 13 else 0 end credential_type,a.electronCerUrl as front_photo,a.zsbh as number,'' as reverse_photo,fzrq as valid_date_from,'9999-12-31' as valid_date_to,a.tenant_user_id,'' as head_photo,xm as name,0 as selected from tenant_user_credential_details a join tenant_employees as b on b.tenant_user_id = a.tenant_user_id   where b.id=:id and a.state = '1'  ";
        String sqlCount = "select count(1) as sum from tenant_user_credential_details a join tenant_employees as b on b.tenant_user_id = a.tenant_user_id  where b.id=:id and a.state = '1' ";
        Collection credentialDetailType = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)request.getCredentialTypes())) {
            credentialDetailType = request.getCredentialTypes().stream().map(credentialType -> {
                switch (credentialType) {
                    case "7": {
                        return "1";
                    }
                    case "8": {
                        return "2";
                    }
                    case "9": {
                        return "3";
                    }
                }
                return credentialType;
            }).collect(Collectors.toList());
            sqlStr = sqlStr + " and a.certificatetype in (:credentialDetailType)";
            sqlCount = sqlCount + " and a.certificatetype in (:credentialDetailType)";
            parameters.put("credentialDetailType", credentialDetailType);
        }
        if (CollUtil.isEmpty(credentialDetailType)) {
            throw new NotSupportTenantException("\u4e0d\u652f\u6301\u8be5\u8bc1\u4ef6\u7c7b\u578b");
        }
        if (StringUtils.hasLength((String)request.getName())) {
            sqlStr = sqlStr + " and a.xm = :name";
            sqlCount = sqlCount + " and a.xm = :name";
            parameters.put("name", request.getName());
        }
        if (StringUtils.hasLength((String)request.getNumber())) {
            sqlStr = sqlStr + " and a.zsbh = :number";
            sqlCount = sqlCount + " and a.zsbh =:number";
            parameters.put("number", request.getNumber());
        }
        Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
        if (request.getSkipAreaCodeFilter() != null && request.getSkipAreaCodeFilter().booleanValue()) {
            sqlStr = sqlStr + "and a.areacode like :areaCode";
            sqlCount = sqlCount + "and a.areacode like :areaCode";
            parameters.put("areaCode", AuthUtil.getShortAreaCode((String)((OrganizationEntity)organizationOptional.get()).getSuperviseRegionCode()) + "%");
        }
        Query query = this.entityManager.createNativeQuery(sqlStr, TenantUserCredentialsEntity.class);
        Query cquery = this.entityManager.createNativeQuery(sqlCount);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
            cquery.setParameter(key, parameters.get(key));
        }
        query.setFirstResult(request.getSkip()).setMaxResults(request.getPageSize());
        ArrayList<CredentialResponse> credentialResponses = new ArrayList<CredentialResponse>();
        List resultList = query.getResultList();
        int sum = Integer.valueOf(cquery.getResultList().get(0).toString());
        for (TenantUserCredentialsEntity tenantUserCredentialsEntity : resultList) {
            CredentialResponse credentialResponse = new CredentialResponse();
            BeanUtil.copyProperties((Object)tenantUserCredentialsEntity, (Object)credentialResponse, (String[])new String[0]);
            credentialResponse.setCredentialTypeName(tenantUserCredentialsEntity.getCredentialType().getTypeName());
            credentialResponse.setCreatedTime(tenantUserCredentialsEntity.getCreatedTime());
            String sqlDetail = "select id,native_code,active,create_time,update_time,update_by,isOldData,xm,companyName,address,csrq,idnum,zsbh,fzrq,zzrq,zzzt,securitypersonid,fzjgmc,fzjgbh,isprint,havephoto,printcount,printTime,updateflag,receiveState,rkkflag,state,examDate,score,cancelDate,cancelReason,cancelOrgName,cancelOrg,revokeReason,revokeOrgName,revokeOrg,revokeDate,snapshotId,isDraw,userid,areaCode,nation,personId,orgId,sex,phone,trainId,trainName,companyId,populationAddress,push,seq,headImg,electronCerUrl,certificateType,trainTime,appraisalTime,appraisalGrade,companyCode,securityCertificateNo,securityCertificateId,uploadCompanyName,trainType,pushDate,personGradeId,profession,trainStartTime,trainEndTime,tenant_user_id,organization_id from tenant_user_credential_details where id  = ?1";
            Query detailsQuery = this.entityManager.createNativeQuery(sqlDetail);
            ((SQLQuery)detailsQuery.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            detailsQuery.setParameter(1, (Object)tenantUserCredentialsEntity.getId());
            credentialResponse.setDetail(detailsQuery.getResultList());
            credentialResponses.add(credentialResponse);
        }
        return Pageable.create((int)request.getPageIndex(), (int)request.getPageSize(), (int)sum, credentialResponses);
    }

    public List<CurrentCredentialResponse> getCredentials(QueryCredentialRequest queryRequest) {
        StringBuilder sql = new StringBuilder("select de from TenantUserCredentialDetailsEntity de  ");
        sql.append(" where de.tenantUserId =:userId  and de.state = '1' and de.active = true ");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", queryRequest.getUserId());
        TypedQuery query = this.entityManager.createQuery(sql.toString(), TenantUserCredentialDetailsEntity.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List cerList = query.getResultList();
        if (cerList.size() > 0) {
            ArrayList<CurrentCredentialResponse> resultList = new ArrayList<CurrentCredentialResponse>();
            List<EmployeeEntity> employees = this.getEmployeesByUserId(queryRequest.getUserId());
            List<Object> organizationEntityList = new ArrayList();
            if (employees.size() > 0) {
                organizationEntityList = employees.stream().map(ii -> ii.getOrganization()).collect(Collectors.toList());
            }
            for (TenantUserCredentialDetailsEntity credentialDetailsEntity : cerList) {
                CurrentCredentialResponse cerResponse = CurrentCredentialResponse.create((String)credentialDetailsEntity.getName(), (String)credentialDetailsEntity.getCerTypeName(), (String)credentialDetailsEntity.getCerNo(), (String)credentialDetailsEntity.getOrgName(), (Date)credentialDetailsEntity.getCerDate());
                resultList.add(cerResponse);
                if (organizationEntityList.size() == 0) continue;
                ArrayList<String> comIds = new ArrayList<String>();
                for (OrganizationEntity organizationEntity : organizationEntityList) {
                    if (!AuthUtil.isUnDistinguishArea((String)organizationEntity.getSuperviseRegionCode()) && !organizationEntity.getSuperviseRegionCode().equals(credentialDetailsEntity.getAreaCode())) continue;
                    comIds.add(organizationEntity.getId());
                }
                cerResponse.setComIds(comIds);
            }
            return resultList;
        }
        return null;
    }

    public List<QualificationCredentialResponse> getQualificationCredentials(QueryCredentialRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String sqlStr = "select a.* from tenant_user_credential_details a where ";
        String idNumValue = request.getIdnum();
        if (StringUtils.hasLength((String)idNumValue)) {
            if (idNumValue.matches("^\\d{17}[\\dXx]$|^\\d{15}$")) {
                sqlStr = sqlStr + " a.idnum = :idnum";
                parameters.put("idnum", idNumValue);
            } else {
                if (idNumValue.matches("^[\\u4e00-\\u9fa5]+$")) {
                    return new ArrayList<QualificationCredentialResponse>();
                }
                sqlStr = sqlStr + " a.zsbh = :zsbh";
                parameters.put("zsbh", idNumValue);
            }
        } else {
            return new ArrayList<QualificationCredentialResponse>();
        }
        sqlStr = sqlStr + " and a.areacode like :areacode and a.state = '1' and a.active = 1 ";
        sqlStr = CredentialType.GradeCer.compareTo((Enum)request.getCredentialType()) == 0 ? sqlStr + " and a.certificateType = 2 " : sqlStr + " and a.certificateType = 1 ";
        parameters.put("areacode", request.getAreaCode() + "%");
        Query query = this.entityManager.createNativeQuery(sqlStr, TenantUserCredentialDetailsEntity.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        ArrayList<QualificationCredentialResponse> credentialResponses = new ArrayList<QualificationCredentialResponse>();
        List resultList = query.getResultList();
        for (TenantUserCredentialDetailsEntity tenantUserCredentialsEntity : resultList) {
            credentialResponses.add(QualificationCredentialResponse.create((String)tenantUserCredentialsEntity.getName(), (String)tenantUserCredentialsEntity.getIdnum(), (String)tenantUserCredentialsEntity.getOrgName(), (String)tenantUserCredentialsEntity.getCerNo(), (String)"", (Date)tenantUserCredentialsEntity.getCerDate()));
        }
        return credentialResponses;
    }

    public List<TenantUserCredentialDetailsEntity> getQualificationCredential(String idnum) {
        TypedQuery query = this.entityManager.createQuery("select t from TenantUserCredentialDetailsEntity t where t.idnum = :idnum  and (t.state='1' or t.state is null) and t.active = true ", TenantUserCredentialDetailsEntity.class);
        query.setParameter("idnum", (Object)idnum);
        List credentialDetailsEntities = query.getResultList();
        if (credentialDetailsEntities.size() > 0) {
            return credentialDetailsEntities;
        }
        return null;
    }

    public List<DepartDto> findDepartAdminsByEmployeeId(String employeeId) {
        TypedQuery mapTypedQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.DepartDto(de.employee.id as employeeId, dp.id as departId, dp.name as departName) from DepartmentAdminEntity de join de.department dp where de.employee.id =:employeeId", DepartDto.class);
        mapTypedQuery.setParameter("employeeId", (Object)employeeId);
        return mapTypedQuery.getResultList();
    }

    public LoginUserDto getLoginUserByIdNum(String idNum) {
        TypedQuery query = this.entityManager.createQuery("select  new com.bcxin.tenant.domain.readers.dtos.LoginUserDto(t.id,t.name,t.telephone) from TenantUserEntity t  where t.selectedCredential.number = ?1", LoginUserDto.class);
        query.setParameter(1, (Object)idNum);
        List resultList = query.getResultList();
        if (resultList.size() > 0) {
            return (LoginUserDto)resultList.get(0);
        }
        return null;
    }

    public boolean isUserByUserName(String userName) {
        IdentityUserpasswordEntity user = this.tenantUserRepository.getByUserName(userName);
        return user != null;
    }

    public List<EmployeeEntity> getAllByIdNums(Collection<String> idNums, String areaCode) {
        String sql = "select e from EmployeeEntity e join e.tenantUser t join e.organization o  where t.selectedCredential.number in (:idNums) ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("idNums", idNums);
        if (StrUtil.isNotEmpty((CharSequence)areaCode) && areaCode.length() >= 2) {
            sql = sql + " and o.superviseRegionCode like concat(:areaCode,'%') ";
            parameters.put("areaCode", areaCode.substring(0, 2));
        }
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeEntity.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List resultList = query.getResultList();
        return resultList;
    }

    public List<EmployeeEntity> getAllByTelephones(Collection<String> telephones, String areaCode) {
        String sql = "select e from EmployeeEntity e join e.tenantUser t join e.organization o  where t.telephone in (:telephones) ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("telephones", telephones);
        if (StrUtil.isNotEmpty((CharSequence)areaCode) && areaCode.length() >= 2) {
            sql = sql + " and o.superviseRegionCode like concat(:areaCode,'%') ";
            parameters.put("areaCode", areaCode.substring(0, 2));
        }
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeEntity.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List resultList = query.getResultList();
        return resultList;
    }

    public List<EmployeeEntity> getSecurityGuardByIdNums(Collection<String> idNums, String areaCode) {
        String sql = "select e from EmployeeEntity e join e.tenantUser t join e.organization o  where t.selectedCredential.number in (:idNums) and e.occupationType=com.bcxin.Infrastructures.enums.OccupationType.SecurityGuard and e.status <> 1 ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("idNums", idNums);
        if (StrUtil.isNotEmpty((CharSequence)areaCode) && areaCode.length() >= 2) {
            sql = sql + " and o.superviseRegionCode like concat(:areaCode,'%') ";
            parameters.put("areaCode", areaCode.substring(0, 2));
        }
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeEntity.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List resultList = query.getResultList();
        return resultList;
    }

    public List<UserRegionDto> getUsersByRegion(TenantUserRegionCriteria criteria) {
        Query regionQuery = this.entityManager.createNativeQuery("select name,number,oneInchColorWhitePhoto  from  auth_users_view  where region like :region");
        regionQuery.setParameter("region", (Object)("%" + criteria.getRegion() + "%"));
        List<UserRegionDto> res = ((SQLQuery)regionQuery.unwrap(SQLQuery.class)).setMaxResults(100).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).getResultList().stream().map(item -> {
            Map map = (Map)BeanUtil.toBean((Object)item, Map.class);
            return new UserRegionDto((String)map.get("NAME"), (String)map.get("number"), (String)map.get("oneInchColorWhitePhoto"));
        }).collect(Collectors.toList());
        return res;
    }

    @Modifying
    @Transactional
    public void updateTenantUserRealNameRequest(List<UpdateTenantUserRealNameRequest> requests) {
        for (UpdateTenantUserRealNameRequest request : requests) {
            Query query = this.entityManager.createNativeQuery(String.format("UPDATE tenant_users u, tenant_user_credentials tuc set u.authenticated_status = %s, authenticated_result = '%s', authenticated_time = NOW()  where u.selected_credential_id = tuc.id  and tuc.number = '%s';", request.getStatus().ordinal(), request.getResult(), request.getNumber()));
            int n = query.executeUpdate();
        }
    }

    public UserCredentialDto queryUserCredential(String id, Integer credentialType, String credentialNumber) {
        boolean b = true;
        String sqlStr = "SELECT u.`name`,u.authenticated_status AS authenticatedStatus,u.checked_status AS checkedStatus,u.telephone,(CAST(uc.credential_type as UNSIGNED)) AS credentialType ,uc.number,uc.reverse_photo AS reversePhoto,uc.front_photo AS frontPhoto,u.head_photo AS headPhoto,uc.number as idnum,(CAST(null as CHAR)) as fzjgmc,(cast(null as date)) as fzrq,uc.address AS address FROM tenant_users u  LEFT JOIN tenant_user_credentials uc ON u.id = uc.tenant_user_id   WHERE uc.tenant_user_id = ?1 AND uc.credential_type = ?2 AND uc.number = ?3 and u.id = ?4";
        Collection excludeCredentialTypes = Stream.of(CredentialType.IdCard, CredentialType.IdCardOfXiangGang, CredentialType.IdCardOfAoMen, CredentialType.IdCardOfTaiwan, CredentialType.Passport, CredentialType.Arms, CredentialType.PoliceNo).collect(Collectors.toList());
        if (!excludeCredentialTypes.stream().anyMatch(ii -> ii.ordinal() == credentialType.intValue())) {
            sqlStr = "SELECT u.`name`,u.authenticated_status AS authenticatedStatus,u.checked_status AS checkedStatus,u.telephone,(CASE WHEN ucd.certificateType = '1' THEN 7 WHEN ucd.certificateType = '2' THEN 8 WHEN ucd.certificateType = '3' THEN 9 WHEN ucd.certificateType = '11' THEN 11 ELSE 0 END) as credentialType,ucd.zsbh as number,'' AS reversePhoto,ucd.electronCerUrl AS frontPhoto,u.head_photo AS headPhoto,ucd.idnum,ucd.fzjgmc,ucd.fzrq,ucp.address FROM tenant_users u  LEFT JOIN tenant_user_credentials ucp ON ucp.tenant_user_id = u.id AND ucp.credential_type = 0 LEFT JOIN tenant_user_credential_details ucd ON ucd.tenant_user_id = u.id WHERE ucd.tenant_user_id = ?1 AND ucd.certificatetype = ?2 AND ucd.zsbh = ?3 AND u.id = ?4";
            b = false;
        }
        String credentialDetailType = "";
        if (!b) {
            switch (credentialType) {
                case 7: {
                    credentialDetailType = "1";
                    break;
                }
                case 8: {
                    credentialDetailType = "2";
                    break;
                }
                case 9: {
                    credentialDetailType = "3";
                    break;
                }
                case 11: {
                    credentialDetailType = "11";
                    break;
                }
                default: {
                    credentialDetailType = "";
                }
            }
            if (StringUtils.isEmpty((Object)credentialDetailType)) {
                throw new NotSupportTenantException("\u4e0d\u652f\u6301\u8be5\u8bc1\u4ef6\u7c7b\u578b");
            }
        }
        Query nativeQuery = this.entityManager.createNativeQuery(sqlStr);
        ((SQLQuery)nativeQuery.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(UserCredentialDto.class));
        nativeQuery.setParameter(1, (Object)id);
        if (b) {
            nativeQuery.setParameter(2, (Object)credentialType);
        } else {
            nativeQuery.setParameter(2, (Object)credentialDetailType);
        }
        nativeQuery.setParameter(3, (Object)credentialNumber);
        nativeQuery.setParameter(4, (Object)id);
        List list = nativeQuery.getResultList();
        return list != null && !list.isEmpty() ? (UserCredentialDto)list.get(0) : null;
    }

    public Collection<String> queryCanBeDeletedEventSubscriberLogs(int pageSize) {
        Collection handlers = Stream.of(EventAction.TenantUserAfterCreatedEventForSms.name()).collect(Collectors.toList());
        TypedQuery eventSubscriberActionLogQuery = this.entityManager.createQuery("select ev.id from EventSubscribedActionLogEntity ev where ev.subscriber.handler not in (:handlers) and ev.createdTime<:createdTime", String.class);
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.add(2, -2);
        DateTime expiredDateTime = DateTime.of((Calendar)nowCalendar);
        eventSubscriberActionLogQuery.setParameter("handlers", (Object)handlers);
        eventSubscriberActionLogQuery.setParameter("createdTime", (Object)expiredDateTime);
        return eventSubscriberActionLogQuery.setMaxResults(pageSize).getResultList();
    }

    public EmployeeStatusDto getEmployeeIdByOrganIdAndIdNumAndType(String organId, CredentialType credentialType, String credentialNumber) {
        Query employeeIdQuery = this.entityManager.createNativeQuery("select ee.id,ee.status from tenant_employees ee join tenant_user_credentials cc on ee.tenant_user_id=cc.tenant_user_id\nwhere cc.number=?1 and cc.credential_type=?2 and ee.organization_id=?3");
        ((SQLQuery)employeeIdQuery.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(EmployeeStatusDto.class));
        employeeIdQuery.setParameter(1, (Object)credentialNumber);
        employeeIdQuery.setParameter(2, (Object)credentialType.ordinal());
        employeeIdQuery.setParameter(3, (Object)organId);
        List result = employeeIdQuery.getResultList();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return (EmployeeStatusDto)result.get(0);
    }

    public EmployeeStatusDto getEmployeeIdByOrganIdAndTelephone(String organId, String telephone) {
        TypedQuery employeeIdQuery = this.entityManager.createQuery("select new com.bcxin.tenant.domain.readers.dtos.EmployeeStatusDto(ee.id,ee.status) from EmployeeEntity ee join ee.tenantUser u  where ee.organization.id=:organId and u.telephone=:telephone", EmployeeStatusDto.class);
        employeeIdQuery.setParameter("telephone", (Object)telephone);
        employeeIdQuery.setParameter("organId", (Object)organId);
        List result = employeeIdQuery.getResultList();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return (EmployeeStatusDto)result.get(0);
    }

    public List<BatchEmployeeValidationDto> getOnDutyEmployeeValidationDtoByIdAndAreaCode(String tenantUserId, String areaCode) {
        if (!StringUtils.hasLength((String)areaCode)) {
            throw new ArgumentTenantException("\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (areaCode.length() < 2) {
            throw new ArgumentTenantException(String.format("\u8be5\u7ec4\u7ec7\u533a\u57df(%s)\u7f16\u7801\u65e0\u6548!", areaCode));
        }
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.BatchEmployeeValidationDto(e.id,o.id,o.name, e.occupationType,e.status,e.hiredDate,e.leaveTime) from EmployeeEntity e join e.organization o   where e.status=com.bcxin.Infrastructures.enums.EmploymentStatus.OnJob and e.tenantUser.id=:tenantUserId  and o.superviseRegionCode like concat(:areaCode,'%')";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tenantUserId", tenantUserId);
        parameters.put("areaCode", areaCode.substring(0, 2));
        TypedQuery query = this.entityManager.createQuery(sql, BatchEmployeeValidationDto.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List resultList = query.getResultList();
        return resultList;
    }

    public Collection<EmployeeTenantUserIdNumDto> getTenantUserIdMapByIdNums(Collection<String> idNums) {
        String sql = "select new com.bcxin.tenant.domain.dto.EmployeeTenantUserIdNumDto(tc.tenantUser.id,tc.number) from TenantUserCredentialsEntity tc   where tc.credentialType=com.bcxin.Infrastructures.enums.CredentialType.IdCard and tc.number in (:idNums) ";
        HashMap<String, Collection<String>> parameters = new HashMap<String, Collection<String>>();
        parameters.put("idNums", idNums);
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeTenantUserIdNumDto.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        return query.getResultList();
    }

    public Collection<EmployeeOccupationTypeValidationBasicDto> getOnDutyEmployeeValidationDtoByIdsAndAreaCode(String areaCode, String organizationId, Collection<String> tenantUserIds) {
        if (CollectionUtils.isEmpty(tenantUserIds)) {
            return Collections.EMPTY_LIST;
        }
        String sql = "select new com.bcxin.tenant.domain.dto.EmployeeOccupationTypeValidationBasicDto(e.tenantUser.id,tc.credentialType,tc.number, e.occupationType,o.id,o.name, o.superviseRegionCode,e.status) from EmployeeEntity e join e.organization o join TenantUserCredentialsEntity tc on tc.tenantUser.id = e.tenantUser.id and tc.credentialType in (:credentialTypes) where e.status=com.bcxin.Infrastructures.enums.EmploymentStatus.OnJob and  e.tenantUser.id in (:tenantUserIds)";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("tenantUserIds", tenantUserIds);
        Collection credentialTypes = Stream.of(CredentialType.IdCard, CredentialType.IdCardOfAoMen, CredentialType.IdCardOfXiangGang, CredentialType.IdCardOfAoMen, CredentialType.IdCardOfTaiwan, CredentialType.Passport, CredentialType.Arms, CredentialType.PoliceNo).collect(Collectors.toList());
        parameters.put("credentialTypes", credentialTypes);
        if (StringUtils.hasLength((String)areaCode) && areaCode.length() > 2) {
            sql = sql + " and o.superviseRegionCode like concat(:areaCode,'%')";
            parameters.put("areaCode", areaCode.substring(0, 2));
        }
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeOccupationTypeValidationBasicDto.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List resultList = query.getResultList();
        return resultList;
    }

    public String getTelephoneByCredentialNumber(CredentialType credentialType, String number) {
        String sql = "select tc.tenantUser.telephone from TenantUserCredentialsEntity tc  where tc.credentialType=:credentialType  and tc.number=:number";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("credentialType", credentialType);
        parameters.put("number", number);
        TypedQuery query = this.entityManager.createQuery(sql, String.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        return (String)query.getSingleResult();
    }

    public Collection<TenantUserTelephoneCredentialDto> getTenantUserTelephoneCredentialsByNumberOrTel(Collection<String> numbers, Collection<String> telephones) {
        String sql = "select new com.bcxin.tenant.domain.dto.TenantUserTelephoneCredentialDto(u.id,u.telephone,tc.credentialType,tc.number) from TenantUserEntity u join u.credentials tc where tc.number in (:numbers) or u.telephone in (:telephones) ";
        HashMap<String, Collection<String>> parameters = new HashMap<String, Collection<String>>();
        parameters.put("numbers", numbers);
        parameters.put("telephones", telephones);
        TypedQuery query = this.entityManager.createQuery(sql, TenantUserTelephoneCredentialDto.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List result = query.getResultList();
        return result;
    }

    public Pageable<EmployeeRecordDto> searchEmployeeRecords(EmployeeRecordCriteria criteria) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.EmployeeRecordDto( ee.tenantUserId,u.name,u.credentialType,u.number,ee.occupationType, ee.actionTime,ee.status,ee.actionNote,ee.operator.name,ee.operator.createdTime) from TenantUserCredentialsEntity u join EmployeeRecordEntity ee on u.tenantUser.id=ee.tenantUserId and u.selected=com.bcxin.Infrastructures.enums.TrueFalseStatus.True  where ee.employeeId =:employeeId and ee.organizationId=:organizationId order by ee.id desc ";
        String countSql = "select count(ee) from TenantUserCredentialsEntity u join EmployeeRecordEntity ee on u.tenantUser.id=ee.tenantUserId and u.selected=com.bcxin.Infrastructures.enums.TrueFalseStatus.True  where ee.employeeId =:employeeId and ee.organizationId=:organizationId  ";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employeeId", criteria.getEmployeeId());
        parameters.put("organizationId", criteria.getOrganizationId());
        TypedQuery query = this.entityManager.createQuery(sql, EmployeeRecordDto.class);
        long totalCount = 0L;
        TypedQuery countQuery = this.entityManager.createQuery(countSql, Long.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
            countQuery.setParameter(key, parameters.get(key));
        }
        totalCount = (Long)countQuery.getSingleResult();
        List result = new ArrayList();
        if (totalCount > 0L) {
            result = query.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        }
        return Pageable.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (int)((int)totalCount), result);
    }

    public boolean isOrganizationPromoter(String organizationId) {
        Query isOrganizationPromoterQuery = this.entityManager.createNativeQuery("select count(1) from shoppingrules.tlk_activate t where t.ITEM_COMPANY_ID = ?1 and ((t.ITEM_START_TIME <= CURDATE() and t.ITEM_END_TIME >= CURDATE()) or t.ITEM_END_TIME is NULL) ");
        isOrganizationPromoterQuery.setParameter(1, (Object)organizationId);
        Object result = isOrganizationPromoterQuery.getSingleResult();
        Long count = Long.parseLong(String.valueOf(result));
        return count > 0L;
    }

    public Pageable<OperateLogResponse> getOperateLogList(SearchOperateLogRequest request, String orgId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select id, tenant_user_id, user_name, real_name, operate_type, operate_time, operate_content, operate_result, ip_address from t_operate_log tol where 1=1 ");
        StringBuffer sqlCount = new StringBuffer(1024);
        sqlCount.append("select count(1) as total from t_operate_log tol where 1=1 ");
        if (StringUtils.hasLength((String)orgId)) {
            sql.append(" and tol.tenant_user_id in (select te.tenant_user_id from tenant_employees te where te.status = 0 and te.organization_id = :orgId) ");
            sqlCount.append(" and tol.tenant_user_id in (select te.tenant_user_id from tenant_employees te where te.status = 0 and te.organization_id = :orgId) ");
            parameters.put("orgId", orgId);
        }
        if (StringUtils.hasLength((String)request.getTenantUserId())) {
            sql.append(" and tol.tenant_user_id = :tenantUserId");
            sqlCount.append(" and tol.tenant_user_id = :tenantUserId");
            parameters.put("tenantUserId", request.getTenantUserId());
        }
        if (StringUtils.hasLength((String)request.getRealName())) {
            sql.append(" and tol.real_name like :realName");
            sqlCount.append(" and tol.real_name like :realName");
            parameters.put("realName", "%" + request.getRealName() + "%");
        }
        if (StringUtils.hasLength((String)request.getUserName())) {
            sql.append(" and tol.user_name like :userName");
            sqlCount.append(" and tol.user_name like :userName");
            parameters.put("userName", "%" + request.getUserName() + "%");
        }
        if (request.getOperateType() != null) {
            sql.append(" and tol.operate_type = :operateType");
            sqlCount.append(" and tol.operate_type = :operateType");
            parameters.put("operateType", request.getOperateType());
        }
        if (StringUtils.hasLength((String)request.getOperateTimeStart())) {
            sql.append(" and tol.operate_time >= :operateTimeStart");
            sqlCount.append(" and tol.operate_time >= :operateTimeStart");
            parameters.put("operateTimeStart", request.getOperateTimeStart().concat(" 00:00:00"));
        }
        if (StringUtils.hasLength((String)request.getOperateTimeEnd())) {
            sql.append(" and tol.operate_time <= :operateTimeEnd");
            sqlCount.append(" and tol.operate_time <= :operateTimeEnd");
            parameters.put("operateTimeEnd", request.getOperateTimeEnd().concat(" 23:59:59"));
        }
        sql.append(" order by tol.operate_time desc ");
        Query query = this.entityManager.createNativeQuery(sql.toString(), OperateLogEntity.class);
        Query countQuery = this.entityManager.createNativeQuery(sqlCount.toString());
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
            countQuery.setParameter(key, parameters.get(key));
        }
        query.setFirstResult(request.getSkip()).setMaxResults(request.getPageSize());
        ArrayList<OperateLogResponse> responseList = new ArrayList<OperateLogResponse>();
        List resultList = query.getResultList();
        int total = Integer.valueOf(countQuery.getResultList().get(0).toString());
        for (OperateLogEntity operateLogEntity : resultList) {
            OperateLogResponse response = new OperateLogResponse();
            BeanUtils.copyProperties((Object)operateLogEntity, (Object)response);
            response.setOperateTimeStr(DateUtil.formatDateTime((Date)operateLogEntity.getOperateTime()));
            responseList.add(response);
        }
        return Pageable.create((int)request.getPageIndex(), (int)request.getPageSize(), (int)total, responseList);
    }

    public Collection<OrganizationAdminiInfoDto> getOrganizationAdminInfo(String organizationId) {
        String sql = "select new com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto(e.id,u.id,u.name,u.telephone) from EmployeeEntity e join e.tenantUser as u where e.organization.id = :organizationId and e.status = 0 and e.domainAdmin = 1";
        TypedQuery query = this.entityManager.createQuery(sql, OrganizationAdminiInfoDto.class);
        query.setParameter("organizationId", (Object)organizationId);
        return query.getResultList();
    }

    public Collection<UserAppealDto> getUserAppeals(UserAppealsCriteria criteria) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.UserAppealDto( a.createdTime,a.status,a.result,a.lastApproverDepartName,a.lastApproverName,a.lastApproverTime) from TenantUserAppealsEntity a where a.tenantUser.id =:userId order by a.createdTime ";
        TypedQuery query = this.entityManager.createQuery(sql, UserAppealDto.class);
        query.setParameter("userId", (Object)criteria.getUserId());
        List result = query.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        return result;
    }

    public Collection<ExternalMemberDTO> search(ExternalMemberSearchCriteria criteria) {
        String sql = "select new com.bcxin.tenant.domain.repositories.dtos.ExternalMemberDTO(e.id,e.inviteType,e.inviteCode,u.id,u.name,u.telephone,c.credentialType,c.number,e.approvedInformationValueType.status,e.approvedInformationValueType.note,e.inviteGroupId,e.inviteGroupName,e.createdTime,e.memberType )  from ExternalMemberEntity e join e.tenantUser u left join u.selectedCredential c where e.referenceType=:referenceType and e.referenceNumber=:referenceNumber ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("referenceType", ResourceReferenceType.Organization);
        parameters.put("referenceNumber", criteria.getOrganizationId());
        Collection statuses = criteria.getStatuses();
        if (CollectionUtils.isEmpty((Collection)criteria.getStatuses())) {
            statuses = Stream.of(ApprovedStatus.Passed, ApprovedStatus.Init, ApprovedStatus.NoPassed).collect(Collectors.toList());
        }
        sql = sql + " and e.approvedInformationValueType.status in :statuses";
        parameters.put("statuses", statuses.stream().collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)criteria.getGroupIds())) {
            if (criteria.getGroupIds().stream().anyMatch(ii -> ii == null)) {
                sql = sql + " and JSON_LENGTH(e.groupIdsJson) = 0";
            } else {
                List groupIds = criteria.getGroupIds().stream().collect(Collectors.toList());
                sql = sql + " and e.groupIdsJson like :groupIds";
                parameters.put("groupIds", "%".concat(((String)groupIds.get(0)).concat("%")));
            }
        }
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            sql = sql + " and u.name like :name";
            parameters.put("name", criteria.getKeyword() + "%");
        }
        sql = statuses.contains(ApprovedStatus.Init) && statuses.size() == 1 ? sql + " order by e.createdTime desc " : sql + " order by e.approvedInformationValueType.status asc, e.createdTime desc";
        TypedQuery query = this.entityManager.createQuery(sql, ExternalMemberDTO.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List result = query.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        Collection memberIds = result.stream().map(ii -> ii.getId()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)memberIds)) {
            String groupSql = "select new com.bcxin.tenant.domain.readers.dtos.ExternalGroupDto(g.id,g.principal.id) from ExternalGroupEntity g where g.principal.id in (:principalIds)";
            TypedQuery groupGroupQuery = this.entityManager.createQuery(groupSql, ExternalGroupDto.class);
            groupGroupQuery.setParameter("principalIds", (Object)memberIds);
            List groups = groupGroupQuery.getResultList();
            for (ExternalMemberDTO em : result) {
                Collection matchedGroupIds = groups.stream().filter(ii -> em.getId().equalsIgnoreCase(ii.getPrincipalId())).map(ii -> ii.getId()).distinct().collect(Collectors.toList());
                em.addPrincipalGroupIds(matchedGroupIds);
            }
        }
        return result;
    }

    public Collection<MyExternalMemberRecordDTO> getMyExternalMemberRecords(MyExternalMemberRecordCriteria criteria) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.MyExternalMemberRecordDTO(e.id,o.id,o.name,e.approvedInformationValueType.status,e.approvedInformationValueType.note,e.approvedInformationValueType.lastUpdatedTime,e.createdTime)  from ExternalMemberEntity e join OrganizationEntity o on e.referenceType=com.bcxin.Infrastructures.enums.ResourceReferenceType.Organization and e.referenceNumber=o.id where e.tenantUser.id=:userId";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", criteria.getTenantUserId());
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            sql = sql + " and o.name like :keyword";
            parameters.put("keyword", "%".concat(criteria.getKeyword().concat("%")));
        }
        TypedQuery query = this.entityManager.createQuery(sql, MyExternalMemberRecordDTO.class);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        List result = query.setFirstResult(criteria.getSkip()).setMaxResults(criteria.getPageSize()).getResultList();
        return result;
    }

    public Collection<MyTeamDto> getMyTeamsByUserId(String userId) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.MyTeamDto(oo.id,oo.name,oo.industryCode,oo.institutionalCode,oo.superviseRegionCode,ee.createdTime, oo.organizationLevel,ee.tenantUser.id, ee.id,ee.memberType) from ExternalMemberEntity ee join OrganizationEntity oo  on ee.referenceType = com.bcxin.Infrastructures.enums.ResourceReferenceType.Organization and  ee.referenceNumber=oo.id where oo.approvedInformationValueType.status in (1) and ee.approvedInformationValueType.status in (1) and ee.tenantUser.id=:userId ";
        TypedQuery query = this.entityManager.createQuery(sql, MyTeamDto.class);
        query.setParameter("userId", (Object)userId);
        List result = query.getResultList();
        return result;
    }

    public Collection<MyRegistrationOrganizationDto> getMyRegistrationsByUserId(String userId, int pageIndex, int pageSize) {
        String sql = "select new com.bcxin.tenant.domain.readers.dtos.MyRegistrationOrganizationDto(oo.id,oo.name,oo.approvedInformationValueType.status,oo.approvedInformationValueType.lastUpdatedTime,oo.approvedInformationValueType.note,oo.institutionalCode,oo.industryCode,oo.createdTime) from OrganizationEntity oo where oo.tenantUser.id=:userId";
        sql = sql + " order by oo.createdTime desc ";
        TypedQuery query = this.entityManager.createQuery(sql, MyRegistrationOrganizationDto.class);
        query.setParameter("userId", (Object)userId);
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        int skip = (pageIndex - 1) * pageSize;
        query = query.setFirstResult(skip).setMaxResults(pageSize);
        return query.getResultList();
    }
}

