/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentDto;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface DepartmentJpaRepository
extends DepartmentRepository,
JpaRepository<DepartmentEntity, String> {
    @Query(value="select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l, d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.parent.id=?2  and d.deleted = false")
    public Collection<DepartmentDto> getDtoByOrganIdAndParentId(String var1, String var2);

    @Query(value="select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.id=?2")
    public DepartmentDto getDtoByOrganIdAndId(String var1, String var2);

    @Query(value="select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    public Collection<DepartmentDto> getRootDtoByOrganId(String var1);

    @Query(value="select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.deleted = false")
    public Collection<DepartmentDto> getDtosByOrganId(String var1);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    public Collection<DepartmentEntity> getRootsByOrganId(String var1);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and (d.name in (?2) or d.parent is null) and d.deleted = false")
    public Collection<DepartmentEntity> getDepartAndRootByOrganIdName(String var1, Collection<String> var2);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and d.id in (?2) and d.deleted = false")
    public Collection<DepartmentEntity> getByIds(String var1, Collection<String> var2);

    @Modifying
    @Query(value="update DepartmentEntity d set d.deleted =true,d.parent= null,d.name = concat(d.name,'#',d.id) ,d.lastUpdatedTime=now() where d.organization.id=?1 and d.id in (?2) and d.parent.id is not null")
    public int deleteByIds(String var1, Collection<String> var2);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and d.deleted = false order by d.parent,d.level")
    public Collection<DepartmentEntity> getAllByOrganId(String var1);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and d.code=?2 and d.deleted = false")
    public DepartmentEntity getByOrganIdAndCode(String var1, String var2);

    @Query(value="select d from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    public DepartmentEntity getRootByOrganId(String var1);

    @Modifying
    @Query(value="delete from DepartmentEmployeeRelationEntity x where x.id in (?1)")
    public void clearDuplicatedEmployeeRelationIds(Collection<String> var1);

    @Modifying
    @Query(value="delete from DepartmentEmployeeRelationEntity x where x.employee.id in (?1)")
    public void clearDuplicatedEmployeeRelationByEmployeeIds(Collection<String> var1);

    @Modifying
    @Query(value="delete from DepartmentEmployeeRelationEntity x where x.employee.id in (?1) and x.department.id=?2")
    public void clearDuplicatedEmployeeRelationByEmployeeIdsAndDepartId(Collection<String> var1, String var2);

    @Modifying
    @Query(value="delete from DepartmentAdminEntity x where x.department.id in (?1)")
    public void clearDepartmentAdminByDepartIds(Collection<String> var1);

    @Modifying
    @Query(value="UPDATE tenant_departments d SET d.index_tree = REPLACE(d.index_tree, ?1, ?2),  d.level =  (LENGTH(d.index_tree) - LENGTH(REPLACE(d.index_tree, '-', ''))) WHERE d.organization_id = ?3 AND d.index_tree LIKE ?4 ", nativeQuery=true)
    public int updateTreeByDepartmentIndexTree1(String var1, String var2, String var3, String var4);

    @Modifying
    @Query(value="UPDATE tenant_department_admins d SET d.department_index_tree = REPLACE(d.department_index_tree, ?1, ?2)  WHERE d.organization_id = ?3 AND d.department_index_tree LIKE ?4 ", nativeQuery=true)
    public int updateTreeByDepartmentIndexTree2(String var1, String var2, String var3, String var4);

    @Modifying
    @Query(value="UPDATE tenant_department_employee_relations d SET d.department_index_tree = REPLACE(d.department_index_tree, ?1, ?2)  WHERE d.department_id IN (SELECT t.id FROM tenant_departments t WHERE t.organization_id = ?3) AND d.department_index_tree LIKE ?4 ", nativeQuery=true)
    public int updateTreeByDepartmentIndexTree3(String var1, String var2, String var3, String var4);

    @Query(value="select d from DepartmentEntity d where d.organization.id = ?1 and d.indexTree like ?2 and d.deleted = false")
    public List<DepartmentEntity> findBySelfAndChild(String var1, String var2);
}

