/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.translates.impls;

import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.tenant.domain.readers.dtos.DepartAdminDto;
import com.bcxin.tenant.domain.readers.dtos.MyDepartImContactDto;
import com.bcxin.tenant.domain.readers.dtos.MyImContactDto;
import com.bcxin.tenant.domain.readers.dtos.MyImDepartDto;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentAdminExportDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartAdminReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartmentReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.EmployeeContactReadDto;
import com.bcxin.tenant.domain.repository.translates.DataTranslate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataTranslateImpl
implements DataTranslate {
    @Override
    public Collection<MyDepartImContactDto> translate2MyDepartImContacts(Collection<DepartmentReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MyDepartImContactDto> departImContacts = new ArrayList<MyDepartImContactDto>();
        data.forEach(ii -> {
            if (!departImContacts.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyDepartImContactDto myDepartImContactDto = MyDepartImContactDto.create((String)ii.getId(), (String)ii.getName(), (String)ii.getParentId(), (int)ii.getDisplayOrder());
                departImContacts.add(myDepartImContactDto);
            }
        });
        return departImContacts;
    }

    @Override
    public Collection<MyImDepartDto> translate2MyImDeparts(Collection<DepartmentReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MyImDepartDto> departs = new ArrayList<MyImDepartDto>();
        data.forEach(ii -> {
            if (!departs.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyImDepartDto myImDepartDto = MyImDepartDto.create((String)ii.getId(), (String)ii.getName(), (String)ii.getParentId(), (int)ii.getDisplayOrder());
                departs.add(myImDepartDto);
            }
        });
        return departs;
    }

    @Override
    public Collection<MyImContactDto> translate2MyImContacts(Collection<EmployeeContactReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MyImContactDto> contacts = new ArrayList<MyImContactDto>();
        data.forEach(ii -> {
            if (!contacts.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyImContactDto myImContactDto = MyImContactDto.create((String)ii.getId(), (String)ii.getEmpId(), (String)ii.getName(), (Sex)ii.getSex(), (String)ii.getHeadPhoto(), (String)ii.getTelephone(), (String)ii.getImIdentity());
                contacts.add(myImContactDto);
            }
        });
        return contacts;
    }

    @Override
    public Collection<DepartAdminDto> translate2DepartAdmins(Collection<DepartAdminReadDto> departAdminReads) {
        ArrayList<DepartAdminDto> wholeDepartAdmins = new ArrayList<DepartAdminDto>();
        Map<String, List<DepartAdminReadDto>> employeeMaps = departAdminReads.stream().collect(Collectors.groupingBy(DepartAdminReadDto::getEmployeeId));
        for (DepartAdminReadDto readDto : departAdminReads) {
            Optional<DepartAdminDto> selectedDepartAdminOptional = wholeDepartAdmins.stream().filter(ii -> ii.getEmployeeId().equals(readDto.getEmployeeId())).findFirst();
            if (selectedDepartAdminOptional.isPresent()) continue;
            String departName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getDepartName).distinct().collect(Collectors.joining(","));
            String manangeDepartName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getManagedDepartName).distinct().collect(Collectors.joining(","));
            wholeDepartAdmins.add(DepartAdminDto.create((String)readDto.getEmployeeId(), (String)readDto.getUserName(), (String)readDto.getUserTelephone(), (String)departName, (String)manangeDepartName));
        }
        return wholeDepartAdmins;
    }

    @Override
    public List<DepartmentAdminExportDto> translate2DepartExportAdmins(Collection<DepartAdminReadDto> departAdminReads) {
        ArrayList<DepartmentAdminExportDto> wholeDepartAdmins = new ArrayList<DepartmentAdminExportDto>();
        Map<String, List<DepartAdminReadDto>> employeeMaps = departAdminReads.stream().collect(Collectors.groupingBy(DepartAdminReadDto::getEmployeeId));
        for (DepartAdminReadDto readDto : departAdminReads) {
            Optional<DepartmentAdminExportDto> selectedDepartAdminOptional = wholeDepartAdmins.stream().filter(ii -> ii.getEmployeeId().equals(readDto.getEmployeeId())).findFirst();
            if (selectedDepartAdminOptional.isPresent()) continue;
            String departName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getDepartName).distinct().collect(Collectors.joining(","));
            String manangeDepartName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getManagedDepartName).distinct().collect(Collectors.joining(","));
            wholeDepartAdmins.add(DepartmentAdminExportDto.create((String)readDto.getEmployeeId(), (String)readDto.getUserName(), (String)readDto.getUserTelephone(), (String)departName, (String)manangeDepartName));
        }
        return wholeDepartAdmins;
    }
}

