/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.IAggregate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class UnitWorkImpl
implements UnitWork {
    private final EntityManager entityManager;
    private final PlatformTransactionManager transactionManager;
    private static ThreadLocal<Map<String, TransactionStatus>> _container = new ThreadLocal();
    private final DefaultTransactionDefinition propagation_required = new DefaultTransactionDefinition(0);

    public UnitWorkImpl(EntityManager entityManager, PlatformTransactionManager transactionManager) {
        this.entityManager = entityManager;
        this.transactionManager = transactionManager;
        this.propagation_required.setTimeout(3000);
    }

    public String beginTransaction() {
        return this.generateTranId();
    }

    public void commit(String tid) {
        TransactionStatus status = this.getTranStatus(tid);
        if (status != null) {
            this.transactionManager.commit(status);
        }
    }

    public void detachAll() {
        this.entityManager.clear();
    }

    public void rollback(String tid) {
        TransactionStatus status = this.getTranStatus(tid);
        if (status != null) {
            this.transactionManager.rollback(status);
        }
    }

    public void executeNewTran(Runnable runnable) {
        TransactionStatus status = null;
        boolean hasCommitted = false;
        try {
            status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            runnable.run();
            hasCommitted = true;
            this.transactionManager.commit(status);
        }
        catch (Exception ex) {
            if (!hasCommitted && status != null) {
                this.transactionManager.rollback(status);
            }
            throw ex;
        }
    }

    public void detach(IAggregate aggregate) {
        this.entityManager.detach((Object)aggregate);
    }

    public <T extends IAggregate> void detachAll(Collection<T> aggregates) {
        if (aggregates != null) {
            aggregates.forEach(ii -> this.entityManager.detach(ii));
        }
    }

    public void executeTran(Runnable runnable) {
        String tranId = null;
        boolean hasCommitted = false;
        try {
            tranId = this.beginTransaction();
            runnable.run();
            hasCommitted = true;
            this.commit(tranId);
        }
        catch (Exception ex) {
            if (!hasCommitted) {
                this.rollback(tranId);
            }
            throw ex;
        }
    }

    private String generateTranId() {
        String uuId = UUID.randomUUID().toString();
        Map<String, TransactionStatus> transactionStatusMap = _container.get();
        if (transactionStatusMap == null) {
            transactionStatusMap = new HashMap<String, TransactionStatus>();
        }
        if (transactionStatusMap.size() == 0) {
            transactionStatusMap.put(uuId, this.transactionManager.getTransaction((TransactionDefinition)this.propagation_required));
        }
        _container.set(transactionStatusMap);
        return uuId;
    }

    private TransactionStatus getTranStatus(String tranId) {
        Map<String, TransactionStatus> transactionStatusMap = _container.get();
        if (transactionStatusMap == null || transactionStatusMap.size() == 0) {
            return null;
        }
        TransactionStatus status = transactionStatusMap.get(tranId);
        transactionStatusMap.remove(tranId);
        _container.set(transactionStatusMap);
        return status;
    }
}

