package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
@ApiModel("企业社会统一信用代码信息")
@Getter
public class CompanyUSCCResponse extends ResponseAbstract {
    //企业名称
    @ApiModelProperty(value = "企业名称")
    private final String companyName;
    //社会统一信用代码
    @ApiModelProperty(value = "社会统一信用代码")
    private final String creditCode;

    public CompanyUSCCResponse(String companyName, String creditCode) {
        this.companyName = companyName;
        this.creditCode = creditCode;
    }

    public static CompanyUSCCResponse create(String companyName, String creditCode) {
        return new CompanyUSCCResponse(companyName, creditCode);
    }

}
