package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

@ApiModel("企业信息修改")
@Data
public class CompanyApprovedUpdateRequest extends RequestAbstract {

    private String id;

    //基本信息
    @ApiModelProperty(value = "公司名称")
    private String name;

    @ApiModelProperty(value = "注册地区")
    private LocationRequest placeOfRegister;

    @ApiModelProperty(value = "经营地区")
    private LocationRequest placeOfBusiness;

    //法人或负责人信息
    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人证件类型", notes = "com.bcxin.Infrastructures.enums.CredentialType")
    private CredentialType legalPersonCredentialType;

    @ApiModelProperty(value = "法人证件号码")
    private String legalPersonCredentialNumber;

    //注册信息
    @ApiModelProperty(value = "注册资本（万元）")
    private String registeredCapital;

    @ApiModelProperty(value = "统一社会信用代码")
    private String unifySocialCreditCode;

    @ApiModelProperty(value = "营业执照扫描件")
    private String unifySocialCreditCodeFile;


    //资质信息
    @ApiModelProperty(value = "保安服务许可/保安培训备案证号（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitNumber;

    @ApiModelProperty(value = "发证机关名称（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String nameOfIssuingAuthority;

    @ApiModelProperty(value = "保安服务许可证首次发证日期或者培训单位的发证日期（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private Date firstIssueServicePermit;

    @ApiModelProperty(value = "保安服务许可证扫描件或者保安培训许可（备案）证扫描件（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitAttachment;


    @ApiModelProperty(value = "批准文号（机构类型 = 保安服务公司 必填）")
    private String securityApprovalNumber;

    @ApiModelProperty(value = "服务范围（机构类型 = 保安服务公司 必填）")
    private List<String> serviceScopeList;

    @ApiModelProperty(value = "培训单位的培训内容（机构类型 = 保安培训单位 必填）")
    private String trainContent;


    //监管归属
    @ApiModelProperty(value = "监管地区")
    private LocationRequest placeOfSupervise;

    @ApiModelProperty(value = "监管机构")
    private String superviseDepartId;

    @ApiModelProperty(value = "监管机构名称")
    private String superviseDepartName;


    @ApiModelProperty(value = "系统管理员")
    private CompanyUpdateRequest.ContactRequest administrator;

    public LocationRequest getPlaceOfSupervise() {
        if (this.placeOfSupervise != null
                && (this.placeOfSupervise.getDistrict() == null || StringUtils.isBlank(this.placeOfSupervise.getDistrict().getCode()))) {
            //监管地区不为空  &&  区为空，需要给区赋值，方便后面取值
            LocationRequest.ItemValueRequest district = new LocationRequest.ItemValueRequest();
            if (this.placeOfSupervise.getCity() != null && StringUtils.isNotBlank(this.placeOfSupervise.getCity().getCode())) {
                district.setCode(this.placeOfSupervise.getCity().getCode());
                district.setName(this.placeOfSupervise.getCity().getName());
            } else if (this.placeOfSupervise.getProvince() != null && StringUtils.isNotBlank(this.placeOfSupervise.getProvince().getCode())) {
                district.setCode(this.placeOfSupervise.getProvince().getCode());
                district.setName(this.placeOfSupervise.getProvince().getName());
            }
            this.placeOfSupervise.setDistrict(district);
        }
        return placeOfSupervise;
    }
}
