/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Date;

@ApiModel(value="\u5165\u79bb\u804c\u8bb0\u5f55\u4fe1\u606f")
public class EmployeeRecordResponse
extends ResponseAbstract {
    @ApiModelProperty(value="\u5f53\u524d\u7684\u7528\u6237id")
    private String tenantUserId;
    @ApiModelProperty(value="\u59d3\u540d")
    private String name;
    @ApiModelProperty(value="\u8bc1\u4ef6\u7c7b\u578b")
    private String credentialType;
    @ApiModelProperty(value="\u8bc1\u4ef6\u53f7\u7801")
    private String credentialNumber;
    @ApiModelProperty(value="\u804c\u4e1a\u7c7b\u578b")
    private String occupationType;
    @ApiModelProperty(value="\u5165/\u79bb/\u590d\u804c\u65f6\u95f4")
    private String actionTime;
    @ApiModelProperty(value="\u5165/\u79bb\u804c\u72b6\u6001")
    private String status;
    @ApiModelProperty(value="\u5907\u6ce8")
    private String actionNode;
    @ApiModelProperty(value="\u64cd\u4f5c\u4eba")
    private String operatorName;
    @ApiModelProperty(value="\u64cd\u4f5c\u65f6\u95f4")
    private String operatorTime;

    public EmployeeRecordResponse() {
    }

    public EmployeeRecordResponse(String tenantUserId, String name, CredentialType credentialType, String credentialNumber, OccupationType occupationType, Date actionTime, EmploymentStatus status, String actionNode, String operatorName, Date operatorTime) {
        this.tenantUserId = tenantUserId;
        this.name = name;
        this.credentialType = credentialType.getTypeName();
        this.credentialNumber = credentialNumber;
        this.occupationType = occupationType.getTypeName();
        this.status = status == EmploymentStatus.OnJob ? "\u5165\u804c" : "\u79bb\u804c";
        this.actionNode = org.springframework.util.StringUtils.hasLength((String)actionNode) && (actionNode.contains("\u8865\u5145\u79bb\u804c\u4fe1\u606f") || actionNode.contains("\u8865\u5145\u5165\u804c\u4fe1\u606f") || "\u8865\u5145\u4fe1\u606f".equalsIgnoreCase(actionNode)) ? "" : actionNode;
        this.operatorName = operatorName;
        if (actionTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.actionTime = dateFormat.format(actionTime);
        }
        if (!StringUtils.isEmpty((String)this.operatorName) && operatorTime != null) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.operatorTime = dateTimeFormat.format(operatorTime);
        }
    }

    public static EmployeeRecordResponse create(String tenantUserId, String name, CredentialType credentialType, String credentialNumber, OccupationType occupationType, Date actionTime, EmploymentStatus status, String actionNode, String operatorName, Date operatorTime) {
        return new EmployeeRecordResponse(tenantUserId, name, credentialType, credentialNumber, occupationType, actionTime, status, actionNode, operatorName, operatorTime);
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getName() {
        return this.name;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialNumber() {
        return this.credentialNumber;
    }

    public String getOccupationType() {
        return this.occupationType;
    }

    public String getActionTime() {
        return this.actionTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getActionNode() {
        return this.actionNode;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getOperatorTime() {
        return this.operatorTime;
    }
}

