/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components.models;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;

public abstract class CacheItemAbstract<T>
implements Serializable {
    private final Timestamp createdTime = Timestamp.from(Instant.now());
    private int expiredInSeconds = 600;
    private final T data;

    public CacheItemAbstract(T data) {
        this.data = data;
    }

    public void assignExpiredInSeconds(int seconds) {
        this.expiredInSeconds = seconds;
    }

    public boolean isExpired() {
        Timestamp comparedTime = Timestamp.from(Instant.now().minusSeconds(this.getExpiredInSeconds()));
        return this.createdTime.after(comparedTime);
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public int getExpiredInSeconds() {
        return this.expiredInSeconds;
    }

    public T getData() {
        return this.data;
    }
}

