/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures;

import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.InjectResolver;
import com.bcxin.Infrastructures.TenantConfigProperty;
import com.bcxin.Infrastructures.TenantContext;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.bcxin.Infrastructures", "com.bcxin.Infrastructures.components"})
@EnableConfigurationProperties(value={TenantConfigProperty.class})
public class InitConfig {
    private final Random workerRandom = new Random();

    public InitConfig(final ApplicationContext beanFactory) {
        TenantContext.getInstance().setInjectResolver(new InjectResolver(){

            @Override
            public <T> T resolve(Class<T> tClass) {
                return (T)beanFactory.getBean(tClass);
            }

            @Override
            public <T> Collection<T> resolveAll(Class<T> tClass) {
                Map maps = beanFactory.getBeansOfType(tClass);
                return maps.values();
            }
        });
    }

    @Bean
    public IdWorker idWorker() {
        return new IdWorker.SnowflakeIdWorker(this.workerRandom.nextInt(31), this.workerRandom.nextInt(31));
    }
}

