package com.bcxin.identity.api;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.commons.OperateLogRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.*;

@EnableConfigurationProperties(NacosDataSourceConfig.class)
@Configuration
@EnableDubbo(scanBasePackages = "com.bcxin.identity.api.impls")
@ComponentScan({
        "com.bcxin.identity.domains.services.impls",
        "com.bcxin.identity.domains.components",
        "com.bcxin.api.interfaces.tenants",
        "com.bcxin.api.interfaces.buses",
        "com.bcxin.identity.domain.repositories",
        "com.bcxin.identity.domains.configs"
})
@Import(InitConfig.class)
public class IdentityConfiguration {

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final UserRpcProvider userRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final MessageRpcProvider messageRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final OperateLogRpcProvider operateLogRpcProvider;

    public IdentityConfiguration(UserRpcProvider userRpcProvider,
                                 MessageRpcProvider messageRpcProvider,
                                 OperateLogRpcProvider operateLogRpcProvider) {
        this.userRpcProvider = userRpcProvider;
        this.messageRpcProvider = messageRpcProvider;
        this.operateLogRpcProvider = operateLogRpcProvider;
    }
}
