package com.bcxin.identity.domain.repositories.impls;

import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.UserNamePasswordPrincipalEntity;
import com.bcxin.identity.domains.entities.WechatPrincipalEntity;
import com.bcxin.identity.domains.repositories.IdentityUserRepository;
import com.bcxin.identity.domains.repositories.dtos.IdentityUserNamePasswordDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;

@Repository
public interface IdentityUserJpaRepository extends IdentityUserRepository,
        JpaRepository<IdentityUserEntity,String> {
    @Query("select new com.bcxin.identity.domains.repositories.dtos.IdentityUserNamePasswordDTO(x.id,x.tenantUserId, x.name,x.idNum,u.password) from UserNamePasswordPrincipalEntity u join u.identityUser x where u.userName=?1")
    IdentityUserNamePasswordDTO findOne(String userName);

    @Query("select x from UserNamePasswordPrincipalEntity c join c.identityUser x where x.tenantUserId =?1 and c.userName=?2")
    IdentityUserEntity getByUserName(String id, String userName);

    @Query("select u from UserNamePasswordPrincipalEntity u where u.userName=?1")
    UserNamePasswordPrincipalEntity getUserNamePasswordPrincipalByUserName(String userName);

    @Query("select w from WechatPrincipalEntity w where w.openId=?1")
    WechatPrincipalEntity findByOpenId(String openId);

    @Query("select c.identityUser from UserNamePasswordPrincipalEntity c where c.userName=?1")
    IdentityUserEntity getDirectlyByUserName(String userName);

    @Query("select c.identityUser from WechatPrincipalEntity c where c.unionId=?1")
    IdentityUserEntity findIdentityUserByUnionId(String unionId);

    @Query("select c from IdentityUserEntity c where c.tenantUserId=?1")
    IdentityUserEntity getByTenantUserId(String tenantUserId);
}
