package com.bcxin.identity.domain.repositories.impls;

import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.identity.domains.readers.IdentityDbReader;
import com.bcxin.identity.domains.readers.dtos.UserReaderDto;
import com.bcxin.identity.domains.readers.dtos.WechatDTO;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@Component
public class IdentityDbReaderImpl implements IdentityDbReader {
    private final EntityManager entityManager;

    private final NamedParameterJdbcTemplate jdbcTemplate;

    public IdentityDbReaderImpl(EntityManager entityManager,
                                NamedParameterJdbcTemplate jdbcTemplate) {
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public UserReaderDto getByUserName(String userName) {
        Query userQuery =
                this.entityManager.createNativeQuery(
                        "select  i.id,t.name, t.telephone,t.authenticated_status,sc.head_photo,t.checked_status from tenant_users t join tenant_user_credentials sc on t.selected_credential_id=sc.id join identity_user i on t.id=i.tenant_user_id " +
                                "where i.idNum=? limit 1");
        userQuery.setParameter(1, userName);

        try {
            List rt = userQuery.getResultList();
            if(CollectionUtils.isEmpty(rt)) {
                return null;
            }

            Object[] result = (Object[]) rt.get(0);

            String id = (String) result[0];
            String name = (String) result[1];
            String telephone = (String) result[2];
            Optional<RealNameAuthenticatedStatus> statusOptional =
                    Arrays.stream(RealNameAuthenticatedStatus.values()).filter(ii -> ii.ordinal() == (Integer) result[3])
                    .findFirst();
            String headPhoto = (String) result[4];
            Optional<UserCheckedStatus> checkedStatusOptional = Arrays.stream(UserCheckedStatus.values()).filter(ii -> ii.ordinal() == (Integer) result[5])
                    .findFirst();

            return UserReaderDto.create(id, name, telephone,
                    (statusOptional.isPresent() ? statusOptional.get() : null), headPhoto,
                    checkedStatusOptional.isPresent() ? checkedStatusOptional.get() : null);

        } catch (NoResultException ex) {
            return null;
        }
    }
}
