/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.web.commons;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.exceptions.AbnormalPersonnelException;
import com.bcxin.Infrastructures.exceptions.AccountLockedException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.DataOperationTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.rest.web.commons.ResponseBuilder;
import com.bcxin.rest.web.commons.ValidationErrorResponse;
import com.bcxin.rest.web.commons.WebLoggerProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    private final WebLoggerProvider webLoggerProvider;
    private final JsonProvider jsonProvider;

    public RestResponseEntityExceptionHandler(WebLoggerProvider webLoggerProvider, JsonProvider jsonProvider) {
        this.webLoggerProvider = webLoggerProvider;
        this.jsonProvider = jsonProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExceptionHandler
    public ResponseEntity exceptionHandle(Exception ex, WebRequest request) {
        boolean recordLog = false;
        try {
            MethodArgumentNotValidException invalidException = (MethodArgumentNotValidException)ExceptionUtil.cast((Exception)ex, MethodArgumentNotValidException.class);
            if (invalidException != null) {
                Collection errors = invalidException.getBindingResult().getAllErrors().stream().map(ii -> {
                    StringBuilder msg = new StringBuilder();
                    Object[] arguments = ii.getArguments();
                    if (arguments != null && arguments.length > 0) {
                        String fieldName = Arrays.stream(arguments).map(arg -> {
                            DefaultMessageSourceResolvable dmsr = (DefaultMessageSourceResolvable)arg;
                            if (dmsr != null) {
                                return dmsr.getDefaultMessage();
                            }
                            return null;
                        }).filter(arg -> arg != null).collect(Collectors.joining(","));
                        msg.append(fieldName);
                        msg.append(" ");
                    }
                    msg.append(ii.getDefaultMessage());
                    return msg.toString();
                }).collect(Collectors.toList());
                recordLog = true;
                ResponseEntity responseEntity = ResponseBuilder.build(HttpStatus.BAD_REQUEST, errors);
                return responseEntity;
            }
            DataOperationTenantException dtx = (DataOperationTenantException)ExceptionUtil.cast((Exception)ex, DataOperationTenantException.class);
            if (dtx != null) {
                ResponseEntity responseEntity = ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, dtx.getData(), dtx.getCode(), dtx.getMessage(), null);
                return responseEntity;
            }
            UnAuthorizedTenantException authorizedException = (UnAuthorizedTenantException)ExceptionUtil.cast((Exception)ex, UnAuthorizedTenantException.class);
            if (authorizedException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.UNAUTHORIZED, null, ex.getMessage(), null);
                return detail;
            }
            ForbidTenantException forbidException = (ForbidTenantException)ExceptionUtil.cast((Exception)ex, ForbidTenantException.class);
            if (forbidException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.FORBIDDEN, null, forbidException.getMessage(), null);
                return detail;
            }
            NotFoundTenantException notFoundException = (NotFoundTenantException)ExceptionUtil.cast((Exception)ex, NotFoundTenantException.class);
            if (notFoundException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.NOT_FOUND, null, notFoundException.getMessage(), null);
                return detail;
            }
            NotAllowedTenantException notAllowedException = (NotAllowedTenantException)ExceptionUtil.cast((Exception)ex, NotAllowedTenantException.class);
            if (notAllowedException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, null, notAllowedException.getMessage(), null);
                return detail;
            }
            AccountLockedException accountLockedException = (AccountLockedException)ExceptionUtil.cast((Exception)ex, AccountLockedException.class);
            if (accountLockedException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, "1000429", accountLockedException.getMessage(), null);
                return detail;
            }
            AbnormalPersonnelException abnormalPersonnelException = (AbnormalPersonnelException)ExceptionUtil.cast((Exception)ex, AbnormalPersonnelException.class);
            if (abnormalPersonnelException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, abnormalPersonnelException.getExceptionList(), abnormalPersonnelException.getCode(), abnormalPersonnelException.getMessage(), null);
                return detail;
            }
            ConflictTenantException conflictTenantException = (ConflictTenantException)ExceptionUtil.cast((Exception)ex, ConflictTenantException.class);
            if (conflictTenantException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, conflictTenantException.getMessage(), null);
                return detail;
            }
            TenantExceptionAbstract tenantException = (TenantExceptionAbstract)ExceptionUtil.cast((Exception)ex, TenantExceptionAbstract.class);
            if (tenantException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, tenantException.getMessage(), null);
                return detail;
            }
            ValidationException validationException = (ValidationException)ExceptionUtil.cast((Exception)ex, ValidationException.class);
            if (validationException != null) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, validationException.getMessage(), null);
                return detail;
            }
            String detailException = ExceptionUtil.getStackMessage((Throwable)ex);
            if (detailException.contains("IdentityNotFoundException") || detailException.contains("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!")) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!", null);
                return detail;
            }
            if (detailException.contains("IdentityNotMatchedException") || detailException.contains("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e")) {
                ResponseEntity detail = ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e!", null);
                return detail;
            }
            recordLog = true;
            if (detailException.contains("TenantException:") && detailException.contains("\n")) {
                int index = detailException.indexOf("TenantException:") + 16;
                int lastIndex = detailException.indexOf("\r");
                if (detailException.length() > index && lastIndex > index) {
                    String msg = detailException.substring(index, lastIndex);
                    ResponseEntity responseEntity = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, msg, null);
                    return responseEntity;
                }
                ResponseEntity responseEntity = ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, detailException, null);
                return responseEntity;
            }
            ResponseEntity responseEntity = ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", null);
            return responseEntity;
        }
        finally {
            if (recordLog) {
                String detail = ExceptionUtil.getStackMessage((Throwable)ex);
                this.logError("RestResponseEntityExceptionHandler.exceptionHandle", detail, request);
            }
        }
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ValidationErrorResponse validationErrorResponse = new ValidationErrorResponse("\u8bf7\u6c42\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42");
        for (ObjectError error : ex.getBindingResult().getAllErrors()) {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                validationErrorResponse.addFieldMessage(fieldError.getField(), fieldError.getDefaultMessage(), fieldError.getRejectedValue());
                continue;
            }
            validationErrorResponse.addFieldMessage(error.getObjectName(), error.getDefaultMessage());
        }
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, validationErrorResponse);
    }

    private void logError(String title, String detail, WebRequest request) {
        try {
            this.webLoggerProvider.error(title, detail, request);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseEntity responseEntity = super.handleExceptionInternal(ex, body, headers, status, request);
        if (status == HttpStatus.BAD_REQUEST || status == HttpStatus.INTERNAL_SERVER_ERROR) {
            String detail = String.format("body=%s;exception=%s", this.jsonProvider.getJson(body), ExceptionUtil.getStackMessage((Throwable)ex));
            try {
                String friendMessage = "\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                if (ex instanceof HttpMessageConversionException) {
                    friendMessage = "\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u786e\u8ba4(02)";
                }
                ResponseEntity responseEntity2 = ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, friendMessage, null);
                return responseEntity2;
            }
            finally {
                this.logError("RestResponseEntityExceptionHandler.handleExceptionInternal", detail, request);
            }
        }
        return responseEntity;
    }
}

