/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.rm;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import com.bcxin.rbac.domain.rm.GroupEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rabc_modules")
@Entity
public class ModuleEntity
extends MetaEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name", length=200, nullable=false)
    private String name;
    @Column(name="online", nullable=false)
    private TrueFalseStatus online;
    @OneToMany
    private Collection<GroupEntity> groups;

    protected ModuleEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ModuleEntity create(String name, boolean online) {
        ModuleEntity module = new ModuleEntity();
        module.setId(UUIDUtil.getShortUuid());
        module.setName(name);
        module.setOnline(online ? TrueFalseStatus.True : TrueFalseStatus.False);
        return module;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TrueFalseStatus getOnline() {
        return this.online;
    }

    public Collection<GroupEntity> getGroups() {
        return this.groups;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setOnline(TrueFalseStatus online) {
        this.online = online;
    }

    protected void setGroups(Collection<GroupEntity> groups) {
        this.groups = groups;
    }
}

