/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.events.MemberCreatedEvent;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentRepository;
import com.bcxin.tenant.domain.v5.services.TMcNoticeService;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.CreateMcNoticeCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncMemberCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MemberCreatedEvent_V5Handler
extends DomainEventHandlerAbstract<MemberCreatedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MemberCreatedEvent_V5Handler.class);
    private final TUserService userService;
    private final TDepartmentRepository departmentRepository;
    private final TMcNoticeService mcNoticeService;
    private final JsonProvider jsonProvider;

    public MemberCreatedEvent_V5Handler(TUserService userService, TDepartmentRepository departmentRepository, TMcNoticeService mcNoticeService, JsonProvider jsonProvider) {
        this.userService = userService;
        this.departmentRepository = departmentRepository;
        this.mcNoticeService = mcNoticeService;
        this.jsonProvider = jsonProvider;
    }

    protected void execute(MemberCreatedEvent event) {
        if (!event.isIgnoreTUser()) {
            this.userService.dispatch(new SyncMemberCommand(event.getId(), event.getOrganizationId(), event.getMemberType(), event.getName(), "", event.getTelephone()));
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)event.getAdminIds())) {
                String content = String.format("\u60a8\u7684%s\u6709\u65b0\u7684\u4eba\u5458\u52a0\u5165\u7533\u8bf7\uff0c\u8bf7\u67e5\u6536\u3002", event.getOrganizationName());
                Collection items = event.getAdminIds().stream().map(ii -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("content", content);
                    map.put("employeeId", (String)ii);
                    map.put("newEmployeeId", event.getId());
                    map.put("newEmployeeName", event.getName());
                    return CreateMcNoticeCommand.CreateMcNoticeCommandItem.create(ii, String.format("<span class='notice_type' type='%s'></span><span class='notice_summary'>%s</span>", "20", content), "{}", event.getOrganizationId(), "\u56e2\u961f\u52a0\u5165", "20", this.jsonProvider.getJson(map));
                }).collect(Collectors.toList());
                this.mcNoticeService.create(CreateMcNoticeCommand.create(items));
            }
        }
        catch (Exception ex) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38:{}", (Object)this.jsonProvider.getJson((Object)ex), (Object)ex);
        }
    }
}

