/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.utils;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.tenant.domain.entities.EventSubscriberEntity;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.repositories.EventSubscribedActionLogRepository;
import com.bcxin.tenant.domain.repositories.EventSubscriberRepository;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExecuteUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTenantEventAction(TenantEventEntity eventEntity, EventSubscriberEntity subscriber, Runnable runnable, RetryProvider retryProvider, EventSubscribedActionLogRepository eventSubscribedActionLogRepository, EventSubscriberRepository eventSubscriberRepository, TenantEventRepository tenantEventRepository, UnitWork unitWork) {
        String message = "";
        try {
            retryProvider.execute(runnable, 10);
        }
        catch (Exception ex) {
            message = ex.getMessage();
            logger.error(String.format("ExecuteUtils.executeTenantEventAction:%s", subscriber.getSelector()), (Throwable)ex);
        }
        finally {
            try {
                if (StringUtils.hasLength((String)message)) {
                    subscriber.error(eventSubscribedActionLogRepository, eventEntity, ProcessedStatus.Error, message);
                    eventEntity.error(message);
                } else {
                    subscriber.done(eventSubscribedActionLogRepository, eventEntity, ProcessedStatus.Done, "\u8ba2\u9605\u6267\u884c\u6210\u529f");
                    eventEntity.done("\u4e8b\u4ef6\u6d88\u8d39\u6210\u529f");
                }
                retryProvider.execute(() -> unitWork.executeNewTran(() -> {
                    tenantEventRepository.save((EntityAbstract)eventEntity);
                    eventSubscriberRepository.save((EntityAbstract)subscriber);
                }), 10);
            }
            catch (Exception ex) {
                unitWork.detachAll();
                ex.printStackTrace();
            }
        }
    }
}

