/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UpdateDepartAdminCommand
extends CommandAbstract {
    private final String organizationId;
    private final String employeeId;
    private final Collection<String> departIds;

    public UpdateDepartAdminCommand(String organizationId, String employeeId, Collection<String> departIds) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.departIds = departIds;
    }

    public void validate() {
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u64cd\u4f5c\u7684\u4f01\u4e1a\u65e0\u6548!");
        }
        if (StrUtil.isEmpty((CharSequence)this.getEmployeeId())) {
            throw new ArgumentTenantException("\u804c\u5458\u4fe1\u606f\u65e0\u6548!");
        }
        if (CollectionUtils.isEmpty(this.getDepartIds()) || this.getDepartIds().stream().anyMatch(ii -> !StringUtils.hasLength((String)ii))) {
            throw new ArgumentTenantException("\u90e8\u95e8\u4fe1\u606f\u65e0\u6548!");
        }
    }

    public static UpdateDepartAdminCommand create(String organizationId, String employeeId, Collection<String> departIds) {
        return new UpdateDepartAdminCommand(organizationId, employeeId, departIds);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public Collection<String> getDepartIds() {
        return this.departIds;
    }
}

