/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.repository;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.IAggregate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class UnitWorkImpl
implements UnitWork {
    private final EntityManager entityManager;
    private final PlatformTransactionManager transactionManager;
    private static ThreadLocal<Map<String, TransactionStatus>> _container = new ThreadLocal();
    private final DefaultTransactionDefinition propagation_required = new DefaultTransactionDefinition(0);

    public UnitWorkImpl(EntityManager entityManager, PlatformTransactionManager transactionManager) {
        this.entityManager = entityManager;
        this.transactionManager = transactionManager;
        this.propagation_required.setTimeout(3000);
    }

    public String beginTransaction() {
        return this.generateTranId();
    }

    public void commit(String tid) {
        TransactionStatus status = this.getTranStatus(tid);
        if (status != null) {
            this.transactionManager.commit(status);
        }
        System.err.println(String.format("\u6267\u884cCommit[tid=%s;status=%s]", tid, status));
    }

    public void detachAll() {
        this.entityManager.clear();
    }

    public void rollback(String tid) {
        TransactionStatus status = this.getTranStatus(tid);
        if (status != null) {
            this.transactionManager.rollback(status);
        }
        System.err.println(String.format("\u6267\u884crollback[tid=%s;status=%s]", tid, status));
    }

    public void executeNewTran(Runnable runnable) {
        TransactionStatus status = null;
        boolean hasCommitted = false;
        try {
            status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            runnable.run();
            this.entityManager.flush();
            hasCommitted = true;
            this.transactionManager.commit(status);
        }
        catch (Exception ex) {
            if (!hasCommitted && status != null) {
                this.transactionManager.rollback(status);
            }
            throw ex;
        }
    }

    public void detach(IAggregate aggregate) {
        this.entityManager.detach((Object)aggregate);
    }

    public <T extends IAggregate> void detachAll(Collection<T> aggregates) {
        if (aggregates != null) {
            aggregates.forEach(ii -> this.entityManager.detach(ii));
        }
    }

    public void executeTran(Runnable runnable) {
        String tranId = null;
        boolean hasCommitted = false;
        try {
            tranId = this.beginTransaction();
            runnable.run();
            this.entityManager.flush();
            hasCommitted = true;
            this.commit(tranId);
        }
        catch (Exception ex) {
            if (!hasCommitted) {
                this.rollback(tranId);
            }
            throw ex;
        }
    }

    private String generateTranId() {
        String uuId = UUID.randomUUID().toString();
        Map<String, TransactionStatus> transactionStatusMap = _container.get();
        if (transactionStatusMap == null) {
            transactionStatusMap = new HashMap<String, TransactionStatus>();
        }
        System.err.println(String.format("BEGIN-%s: TID=%s;Size=%s;UID=%s;s=%s;", Arrays.stream(Thread.currentThread().getStackTrace()).map(ii -> String.format("%s.%s", ii.getClassName(), ii.getMethodName())), Thread.currentThread().getId(), transactionStatusMap.size(), uuId, transactionStatusMap.size() == 1 ? transactionStatusMap.keySet().stream().findFirst().get() : "null"));
        if (transactionStatusMap.size() == 0) {
            transactionStatusMap.put(uuId, this.transactionManager.getTransaction((TransactionDefinition)this.propagation_required));
        }
        _container.set(transactionStatusMap);
        return uuId;
    }

    private TransactionStatus getTranStatus(String tranId) {
        Map<String, TransactionStatus> transactionStatusMap = _container.get();
        if (transactionStatusMap == null || transactionStatusMap.size() == 0) {
            return null;
        }
        TransactionStatus status = transactionStatusMap.get(tranId);
        transactionStatusMap.remove(tranId);
        _container.set(transactionStatusMap);
        System.err.println(String.format("END-%s: TID=%s;Size=%s;UID=%s;STATUS=%s;", Arrays.stream(Thread.currentThread().getStackTrace()).map(ii -> String.format("%s.%s", ii.getClassName(), ii.getMethodName())), Thread.currentThread().getId(), transactionStatusMap.size(), tranId, status));
        return status;
    }
}

