/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.infrastructure.offices.utils;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class TitleHandler
implements SheetWriteHandler {
    private Map<Integer, List<String>> dropDownMap;
    private static final Integer rowSize = 3000;

    public TitleHandler(Map<Integer, List<String>> dropDownMap) {
        this.dropDownMap = dropDownMap;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        String hiddenName = "hidden";
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet hidden = workbook.createSheet(hiddenName);
        for (Map.Entry<Integer, List<String>> entry : this.dropDownMap.entrySet()) {
            CellRangeAddressList addressList = new CellRangeAddressList(1, rowSize.intValue(), entry.getKey().intValue(), entry.getKey().intValue());
            String excelLine = TitleHandler.getExcelLine(entry.getKey());
            List<String> values = entry.getValue();
            int length = values.size();
            for (int i = 0; i < length; ++i) {
                hidden.createRow(i).createCell(entry.getKey().intValue()).setCellValue(values.get(i));
            }
            Name category1Name = workbook.createName();
            category1Name.setNameName(hiddenName);
            String refers = "=" + hiddenName + "!$" + excelLine + "$1:$" + excelLine + "$" + (values.size() + 1);
            DataValidationConstraint constraint = helper.createFormulaListConstraint(refers);
            DataValidation dataValidation = helper.createValidation(constraint, addressList);
            writeSheetHolder.getSheet().addValidationData(dataValidation);
        }
        int hiddenIndex = workbook.getSheetIndex("hidden");
        if (!workbook.isSheetHidden(hiddenIndex)) {
            workbook.setSheetHidden(hiddenIndex, true);
        }
    }

    public static String getExcelLine(int num) {
        String line = "";
        int first = num / 26;
        int second = num % 26;
        if (first > 0) {
            line = (char)(65 + first - 1) + "";
        }
        line = line + (char)(65 + second) + "";
        return line;
    }
}

