/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.InviteType;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="invite_organization_relationships")
@Entity
public class InviteOrganizationRelationshipEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(nullable=false)
    private long id;
    @Column(name="code", length=30, nullable=false)
    private String code;
    @Column(name="organization_id", length=50, nullable=false)
    private String organizationId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="invite_type", length=3, nullable=false)
    private InviteType inviteType;
    @Column(name="content", length=2000)
    private String content;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="creator_id", length=50, nullable=false)
    private String creatorId;

    public InviteOrganizationRelationshipEntity() {
        this.setCreatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public InviteOrganizationRelationshipEntity(String code, String organizationId, InviteType inviteType, String content, String creatorId) {
        this();
        this.code = code;
        this.organizationId = organizationId;
        this.inviteType = inviteType;
        this.content = content;
        this.creatorId = creatorId;
    }

    public static InviteOrganizationRelationshipEntity create(String code, String organizationId, InviteType inviteType, String content, String creatorId) {
        return new InviteOrganizationRelationshipEntity(code, organizationId, inviteType, content, creatorId);
    }

    public long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public InviteType getInviteType() {
        return this.inviteType;
    }

    public String getContent() {
        return this.content;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    protected void setInviteType(InviteType inviteType) {
        this.inviteType = inviteType;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }
}

