/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.api.interfaces.tenants.responses.TenantUserExtensionResponse;
import com.bcxin.tenant.domain.entities.TenantUserExtensionEntity;
import com.bcxin.tenant.domain.repositories.TenantUserExtensionRepository;
import com.bcxin.tenant.domain.services.commands.tenantUsers.TenantUserExtensionCommand;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TenantUserExtensionService {
    private static final Logger log = LoggerFactory.getLogger(TenantUserExtensionService.class);
    private final Logger logger = LoggerFactory.getLogger(TenantUserExtensionService.class);
    private final TenantUserExtensionRepository tenantUserExtensionRepository;
    private final UnitWork unitWork;
    private final String envRegionCode;

    public TenantUserExtensionService(TenantUserExtensionRepository tenantUserExtensionRepository, UnitWork unitWork, @Value(value="${env.region-code:110000}") String envRegionCode) {
        this.tenantUserExtensionRepository = tenantUserExtensionRepository;
        this.unitWork = unitWork;
        this.envRegionCode = envRegionCode;
    }

    public List<TenantUserExtensionResponse> getExtensionListByTenantUserId(String tenantUserId) {
        List<TenantUserExtensionEntity> existList;
        ArrayList<TenantUserExtensionResponse> responseList = new ArrayList<TenantUserExtensionResponse>();
        if ("140500".equals(this.envRegionCode) && CollectionUtil.isNotEmpty(existList = this.tenantUserExtensionRepository.findByTenantUserId(tenantUserId))) {
            for (TenantUserExtensionEntity entity : existList) {
                responseList.add(new TenantUserExtensionResponse(entity.getExtensionKey(), entity.getExtensionValue()));
            }
        }
        return responseList;
    }

    public void saveTenantUserExtension(String tenantUserId, List<TenantUserExtensionCommand> extensionList) {
        try {
            log.info("\u4fdd\u5b58\u7528\u6237\u62d3\u5c55\u4fe1\u606f\uff0c\u53c2\u6570\uff1atenantUserId\uff1a{}\uff0c extensionList\uff1a{}\uff0c ", (Object)tenantUserId, extensionList);
            if ("140500".equals(this.envRegionCode) && CollectionUtil.isNotEmpty(extensionList)) {
                this.unitWork.executeTran(() -> {
                    List<TenantUserExtensionEntity> existList = this.tenantUserExtensionRepository.findByTenantUserId(tenantUserId);
                    for (TenantUserExtensionCommand command : extensionList) {
                        TenantUserExtensionEntity entity;
                        Optional<TenantUserExtensionEntity> sameExtension = existList.stream().filter(exist -> exist.getExtensionKey().equals(command.getExtensionKey())).findFirst();
                        if (sameExtension.isPresent()) {
                            entity = sameExtension.get();
                            entity.setExtensionValue(command.getExtensionValue());
                        } else {
                            entity = new TenantUserExtensionEntity();
                            entity.setTenantUserId(tenantUserId);
                            entity.setExtensionKey(command.getExtensionKey());
                            entity.setExtensionValue(command.getExtensionValue());
                            entity.setCreateTime(new Date());
                        }
                        this.tenantUserExtensionRepository.save(entity);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u7528\u6237\u62d3\u5c55\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

