/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchCreateDepartAdminCommand
extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;
    private final Collection<String> departIds;

    public BatchCreateDepartAdminCommand(String organizationId, Collection<String> employeeIds, Collection<String> departIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
        this.departIds = departIds;
    }

    public void validate() {
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u64cd\u4f5c\u7684\u4f01\u4e1a\u65e0\u6548!");
        }
        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength((String)ii))) {
            throw new ArgumentTenantException("\u804c\u5458\u4fe1\u606f\u65e0\u6548!");
        }
        if (CollectionUtils.isEmpty(this.getDepartIds()) || this.getDepartIds().stream().anyMatch(ii -> !StringUtils.hasLength((String)ii))) {
            throw new ArgumentTenantException("\u90e8\u95e8\u4fe1\u606f\u65e0\u6548!");
        }
    }

    public static BatchCreateDepartAdminCommand create(String organizationId, Collection<String> employeeIds, Collection<String> departIds) {
        return new BatchCreateDepartAdminCommand(organizationId, employeeIds, departIds);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<String> getEmployeeIds() {
        return this.employeeIds;
    }

    public Collection<String> getDepartIds() {
        return this.departIds;
    }
}

