/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.AppealStatus;
import com.bcxin.Infrastructures.enums.BackgroundScreeningStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.enums.UserType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.StringUtil;
import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserAppealsEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.TenantCheckStatusChangedEvent;
import com.bcxin.tenant.domain.events.TenantCredentialChangedEvent;
import com.bcxin.tenant.domain.events.TenantCredentialChangedValidateEvent;
import com.bcxin.tenant.domain.events.TenantUserTelephoneChangedEvent;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import com.bcxin.tenant.domain.snapshots.GisLocationSnapshot;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Table(name="tenant_users")
@Entity
public class TenantUserEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=50, nullable=false)
    private String id;
    @Column(name="third_party_loginNo", length=200)
    private String thirdPartyLoginNo;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="head_photo")
    private String headPhoto;
    @Column(name="im_identity", length=100)
    private String imIdentity;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="sex")
    private Sex sex;
    @Column(nullable=false, name="telephone", length=50)
    private String telephone;
    @Column(nullable=true, name="email", length=50)
    private String email;
    @Column(nullable=true, name="lon_lat_json", length=200)
    private String lonLatJson;
    @Temporal(value=TemporalType.DATE)
    @Column(nullable=true, name="birthdate")
    private Date birthdate;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="checked_status")
    private UserCheckedStatus checkedStatus;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="authenticated_status")
    private RealNameAuthenticatedStatus authenticateStatus;
    @Column(name="authenticated_result")
    private String authenticatedResult;
    @Column(name="authenticated_time")
    private Timestamp authenticatedTime;
    @Column(name="stature", length=50)
    private String stature;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="user_type", nullable=false)
    private UserType userType;
    @Column(name="nation", length=100)
    private String nation;
    @Column(name="nationality")
    private String nationality;
    @Column(name="work_year")
    private Integer workYear;
    @Column(name="diseases_history")
    private String diseasesHistory;
    @Column(name="politics_status", length=100)
    private String politicsStatus;
    @Column(name="military_status", length=100)
    private String militaryStatus;
    @Column(name="household_type", length=100)
    private String householdType;
    @Column(name="education", length=100)
    private String education;
    @Column(name="native_place", length=100)
    private String nativePlace;
    @Column(name="marital_status", length=100)
    private String maritalStatus;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @OneToMany(mappedBy="tenantUser", cascade={CascadeType.ALL})
    private Collection<TenantUserCredentialsEntity> credentials;
    @OneToOne(cascade={CascadeType.ALL})
    private TenantUserCredentialsEntity selectedCredential;
    @Column(name="habit_setting", length=800)
    private String habitSetting;
    @Column(name="one_inch_color_white_photo", length=1000)
    private String oneInchColorWhitePhoto;
    @Column(name="two_inch_color_blue_photo", length=1000)
    private String twoInchColorBluePhoto;
    @Column(name="cid", length=200)
    private String cid;
    @Column(name="wechat", length=100)
    private String wechat;
    @Column(name="wechat_nicky", length=100)
    private String wechatNicky;
    @Column(name="last_updated_time", nullable=true)
    private Timestamp lastUpdatedTime;
    @Column(name="last_checked_status_time", nullable=true)
    private Timestamp lastCheckedStatusTime;
    @Column(name="last_sync_time")
    private Timestamp lastSyncTime;
    @Column(name="background_screening_status", nullable=false)
    private BackgroundScreeningStatus backgroundScreeningStatus;
    @Column(name="last_background_screening_time", nullable=true)
    private Timestamp lastBackGroundScreeningTime;
    @Column(name="emergency_contact")
    private String emergencyContact;
    @Column(name="emergency_phone")
    private String emergencyPhone;
    @Column(name="license_level")
    private String licenseLevel;
    @Column(name="certificate_image")
    private String CertificateImage;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_now_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_now_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_now_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_now_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_now_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_now_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_now_address"))})
    private LocationValueType placeOfNow;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="last_appeal_status")
    private AppealStatus lastAppealStatus;
    @Column(name="last_appeal_result")
    private String lastAppealResult;
    @Temporal(value=TemporalType.DATE)
    @Column(name="last_appeal_time")
    private Date lastAppealTime;
    @OneToMany(mappedBy="tenantUser", cascade={CascadeType.REFRESH}, fetch=FetchType.LAZY)
    private Collection<TenantUserAppealsEntity> appeals;
    @OneToMany(mappedBy="tenantUser", cascade={CascadeType.REFRESH})
    private Collection<OrganizationEntity> organizations;
    @OneToMany(mappedBy="tenantUser", cascade={CascadeType.REFRESH})
    private Collection<EmployeeEntity> employeeEntities;

    public void addCredential(CredentialType credentialType, String credentialNumber, boolean isDefault) {
        credentialNumber = StringUtils.toUpperCase((String)org.springframework.util.StringUtils.trimAllWhitespace((String)credentialNumber));
        Collection<TenantUserCredentialsEntity> tenantUserCredentialsEntities = this.getCredentials();
        if (tenantUserCredentialsEntities == null) {
            tenantUserCredentialsEntities = new ArrayList<TenantUserCredentialsEntity>();
        }
        TenantUserCredentialsEntity tenantUserCredential = TenantUserCredentialsEntity.create(this, credentialType, credentialNumber);
        tenantUserCredentialsEntities.add(tenantUserCredential);
        this.setCredentials(tenantUserCredentialsEntities);
        if (isDefault) {
            this.setSelectedCredential(tenantUserCredential);
        }
    }

    public TenantUserEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    protected TenantUserEntity(String name, String telephone) {
        this();
        if (!org.springframework.util.StringUtils.hasLength((String)name)) {
            throw new ArgumentTenantException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!org.springframework.util.StringUtils.hasLength((String)telephone)) {
            throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.setId(UUIDUtil.getShortUuid());
        this.setBackgroundScreeningStatus(BackgroundScreeningStatus.Init);
        this.setName(name);
        this.setTelephone(telephone);
        this.setAuthenticateStatus(RealNameAuthenticatedStatus.UnAuthenticated);
        this.changeCheckStatus(null, UserCheckedStatus.None);
        this.setSex(Sex.Unknown);
        this.setUserType(UserType.normal);
        this.setImIdentity(this.getId());
        this.setLastAppealStatus(AppealStatus.None);
    }

    public static TenantUserEntity create(TenantEventService eventService, String name, String telephone, boolean ignoreSms) {
        telephone = org.springframework.util.StringUtils.trimAllWhitespace((String)telephone);
        TenantUserEntity tenantUser = new TenantUserEntity(name, telephone);
        if (!ignoreSms) {
            eventService.create(CreateTenantEventCommand.create(EventAction.TenantUserAfterCreatedEventForSms, tenantUser.getId(), tenantUser.getTelephone()));
        }
        eventService.create(CreateTenantEventCommand.create(EventAction.TenantUserAfterCreatedEventForIdentity, tenantUser.getId(), tenantUser.getTelephone()));
        return tenantUser;
    }

    public static TenantUserEntity createImport(TenantEventService eventService, String name, String telephone, Sex sex, Date birthdate, String nation, String education, String politicsStatus, String militaryStatus, String maritalStatus, String emergencyContact, String emergencyPhone, String address, String householdType) {
        telephone = org.springframework.util.StringUtils.trimAllWhitespace((String)telephone);
        TenantUserEntity tenantUser = new TenantUserEntity(name, telephone);
        tenantUser.setSex(sex == null ? Sex.Unknown : sex);
        tenantUser.changeBirthdate(birthdate);
        tenantUser.setNation(nation);
        tenantUser.setEducation(education);
        tenantUser.setPoliticsStatus(politicsStatus);
        tenantUser.setMilitaryStatus(militaryStatus);
        tenantUser.setMaritalStatus(maritalStatus);
        tenantUser.setEmergencyContact(emergencyContact);
        tenantUser.setEmergencyPhone(emergencyPhone);
        tenantUser.setPlaceOfNow(LocationValueType.create(null, null, null, address));
        tenantUser.setHouseholdType(householdType);
        eventService.create(CreateTenantEventCommand.create(EventAction.TenantUserAfterCreatedEventForSms, tenantUser.getId(), tenantUser.getTelephone()));
        eventService.create(CreateTenantEventCommand.create(EventAction.TenantUserAfterCreatedEventForIdentity, tenantUser.getId(), tenantUser.getTelephone()));
        return tenantUser;
    }

    public void assignOrganization(OrganizationEntity organization) {
        Collection<OrganizationEntity> organizations = this.getOrganizations();
        if (organizations == null) {
            organizations = new ArrayList<OrganizationEntity>();
        }
        organizations.add(organization);
        this.setOrganizations(organizations);
    }

    public void change(Sex sex, String nation, String diseasesHistory, String workYear, String politicsStatus, String stature, String militaryStatus, Date birthdate, String education, String householdType, String nativePlace, String maritalStatus, String emergencyContact, String emergencyPhone, String licenseLevel, LocationValueType placeOfNow) {
        this.setSex(sex);
        this.setNation(nation);
        this.setDiseasesHistory(diseasesHistory);
        if (org.springframework.util.StringUtils.hasLength((String)workYear)) {
            try {
                this.setWorkYear(Integer.parseInt(workYear));
            }
            catch (Exception ex) {
                this.setWorkYear(null);
            }
        } else {
            this.setWorkYear(null);
        }
        this.setPoliticsStatus(politicsStatus);
        this.setStature(stature);
        this.setMilitaryStatus(militaryStatus);
        this.changeBirthdate(birthdate);
        this.setEducation(education);
        this.setHouseholdType(householdType);
        this.setNativePlace(nativePlace);
        this.setMaritalStatus(maritalStatus);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        this.setEmergencyContact(emergencyContact);
        this.setEmergencyPhone(emergencyPhone);
        this.setLicenseLevel(licenseLevel);
        this.setPlaceOfNow(placeOfNow);
    }

    public void changeEmail(String email) {
        this.setEmail(email);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeName(String name) {
        this.setName(name);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeTelephone(String telephone) {
        this.setTelephone(telephone);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeSex(Sex sex) {
        this.setSex(sex);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeBirthdate(Date birthdate) {
        if (birthdate != null) {
            this.setBirthdate(birthdate);
            this.setLastUpdatedTime(Timestamp.from(Instant.now()));
            this.setLastSyncTime(Timestamp.from(Instant.now()));
        }
    }

    public void changeBasic(String name, String telephone) {
        String oldName = this.getName();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name) && !oldName.equals(name)) {
            this.setName(name);
        }
        String oldPhone = this.getTelephone();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)telephone) && !oldPhone.equals(telephone)) {
            telephone = org.springframework.util.StringUtils.trimAllWhitespace((String)telephone);
            this.setTelephone(telephone);
            this.recordEvent(TenantUserTelephoneChangedEvent.create(this.getId(), this.getTelephone(), oldPhone, this.getName(), this.getSelectIdNum()));
        }
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeLocation(String latitude, String longitude, JsonProvider jsonProvider) {
        String json = jsonProvider.getJson((Object)GisLocationSnapshot.create(latitude, longitude));
        this.setLonLatJson(json);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void changeDeviceId(String cid) {
        this.setCid(cid);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void assignThirdPartyLoginNo(String thirdPartyLoginNo) {
        if (!org.springframework.util.StringUtils.hasLength((String)this.thirdPartyLoginNo)) {
            this.setThirdPartyLoginNo(thirdPartyLoginNo);
            this.setLastUpdatedTime(Timestamp.from(Instant.now()));
            this.setLastSyncTime(Timestamp.from(Instant.now()));
        }
    }

    public void assignBirthdateAndSex(Date date, Sex sex) {
        if (date != null) {
            this.birthdate = date;
        }
        if (sex != null) {
            this.sex = sex;
        }
        if (date != null || sex != null) {
            this.setLastUpdatedTime(Timestamp.from(Instant.now()));
            this.setLastSyncTime(Timestamp.from(Instant.now()));
        }
    }

    public void changeCredential(String headPhoto, String frontPhoto, String reversePhoto, String address, Date validDateFrom, Date validDateTo, boolean updateNicknameHeadPhoto) {
        Optional<TenantUserCredentialsEntity> selectedTenantUserCredentialOptional;
        Collection<TenantUserCredentialsEntity> credentials = this.getCredentials();
        if (credentials == null) {
            credentials = new ArrayList<TenantUserCredentialsEntity>();
        }
        if (!(selectedTenantUserCredentialOptional = credentials.stream().filter(ii -> ii.getSelected() == TrueFalseStatus.True).findFirst()).isPresent()) {
            selectedTenantUserCredentialOptional = credentials.stream().findFirst();
        }
        TenantUserCredentialsEntity userCredentialsEntity = null;
        if (!selectedTenantUserCredentialOptional.isPresent()) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        userCredentialsEntity = selectedTenantUserCredentialOptional.get();
        this.setCredentials(credentials);
        this.setSelectedCredential(userCredentialsEntity);
        if (org.springframework.util.StringUtils.isEmpty((Object)this.getHeadPhoto()) || !updateNicknameHeadPhoto) {
            this.setHeadPhoto(headPhoto);
        }
        userCredentialsEntity.changeDetail(headPhoto, frontPhoto, reversePhoto, address, validDateFrom, validDateTo);
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeCredential(String name, CredentialType credentialType, String headPhoto, String number, Date validDateFrom, Date validDateTo, String frontPhoto, String reversePhoto, String address, boolean fromMobile, String certificateImage, boolean updateNicknameHeadPhoto) {
        DateTime birthDate;
        Optional<TenantUserCredentialsEntity> selectedTenantUserCredentialOptional;
        Collection<TenantUserCredentialsEntity> credentials;
        boolean allowedChangedCertificate;
        boolean bl = allowedChangedCertificate = this.getAuthenticateStatus() == RealNameAuthenticatedStatus.UnAuthenticated || this.getAuthenticateStatus() == RealNameAuthenticatedStatus.Failed || this.getCheckedStatus() == UserCheckedStatus.None;
        if (CredentialType.IdCard == credentialType && !allowedChangedCertificate) {
            throw new NotAllowedTenantException(String.format("\u8be5\u7528\u6237{%s}\u5df2\u7ecf\u8ba4\u8bc1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u91cd\u65b0\u6838\u9a8c\u3002", this.getName()));
        }
        number = StringUtils.toUpperCase((String)org.springframework.util.StringUtils.trimAllWhitespace((String)number));
        this.recordEvent(TenantCredentialChangedValidateEvent.create(this.getId(), this.getName(), credentialType, number, fromMobile));
        if (!fromMobile && UserCheckedStatus.Matched.equals((Object)this.getCheckedStatus()) && (RealNameAuthenticatedStatus.UnAuthenticated.equals((Object)this.getAuthenticateStatus()) || RealNameAuthenticatedStatus.Failed.equals((Object)this.getAuthenticateStatus()))) {
            if (!AuthUtil.isAdmin()) {
                throw new ArgumentTenantException("\u5df2\u6838\u9a8c(\u672a\u8ba4\u8bc1\u901a\u8fc7)\u72b6\u6001\uff0c\u53ea\u6709\u7ec4\u7ec7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u59d3\u540d\uff01");
            }
            credentialType = this.getSelectedCredential().getCredentialType();
            number = this.getSelectedCredential().getNumber();
            headPhoto = this.getSelectedCredential().getHeadPhoto();
            validDateFrom = this.getSelectedCredential().getValidDateFrom();
            validDateTo = this.getSelectedCredential().getValidDateTo();
            frontPhoto = this.getSelectedCredential().getFrontPhoto();
            reversePhoto = this.getSelectedCredential().getReversePhoto();
            address = this.getSelectedCredential().getAddress();
        }
        if ((credentials = this.getCredentials()) == null) {
            credentials = new ArrayList<TenantUserCredentialsEntity>();
        }
        if (!(selectedTenantUserCredentialOptional = credentials.stream().filter(ii -> ii.getSelected() == TrueFalseStatus.True).findFirst()).isPresent()) {
            CredentialType finalCredentialType = credentialType;
            selectedTenantUserCredentialOptional = credentials.stream().filter(ii -> ii.getCredentialType() == finalCredentialType).findFirst();
        }
        TenantUserCredentialsEntity userCredentialsEntity = null;
        if (selectedTenantUserCredentialOptional.isPresent()) {
            userCredentialsEntity = selectedTenantUserCredentialOptional.get();
        } else {
            userCredentialsEntity = TenantUserCredentialsEntity.create(this, credentialType, number);
            credentials.add(userCredentialsEntity);
        }
        this.setCredentials(credentials);
        this.setSelectedCredential(userCredentialsEntity);
        Timestamp timestamp = Timestamp.from(Instant.now());
        if (credentialType == CredentialType.IdCard && allowedChangedCertificate && fromMobile) {
            String oldNumber = userCredentialsEntity.getNumber();
            this.setAuthenticateStatus(RealNameAuthenticatedStatus.Authenticating);
            this.setAuthenticatedTime(timestamp);
            if (!org.springframework.util.StringUtils.hasLength((String)certificateImage)) {
                throw new BadTenantException("\u7cfb\u7edf\u5f02\u5e38, \u6d3b\u4f53\u91c7\u96c6\u5934\u50cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.setCertificateImage(certificateImage);
            this.setLastCheckedStatusTime(timestamp);
            if (this.getCheckedStatus() == UserCheckedStatus.None) {
                if (credentialType == CredentialType.IdCard) {
                    this.changeCheckStatus(number, UserCheckedStatus.Matched);
                } else {
                    this.changeCheckStatus(number, UserCheckedStatus.Commit);
                }
            }
            this.setName(name);
            if (org.springframework.util.StringUtils.isEmpty((Object)this.getHeadPhoto()) || !updateNicknameHeadPhoto) {
                this.setHeadPhoto(headPhoto);
            }
            userCredentialsEntity.changeDetail(credentialType, name, number, headPhoto, frontPhoto, reversePhoto, address, validDateFrom, validDateTo);
            if (org.springframework.util.StringUtils.hasLength((String)oldNumber) && !StringUtil.equal((String)oldNumber, (String)number)) {
                this.setBackgroundScreeningStatus(BackgroundScreeningStatus.Init);
            }
        } else if (credentialType != CredentialType.IdCard || allowedChangedCertificate) {
            this.setName(name);
            if (org.springframework.util.StringUtils.isEmpty((Object)this.getHeadPhoto()) || !updateNicknameHeadPhoto) {
                this.setHeadPhoto(headPhoto);
            }
            userCredentialsEntity.changeDetail(credentialType, name, number, headPhoto, frontPhoto, reversePhoto, address, validDateFrom, validDateTo);
        }
        if (org.springframework.util.StringUtils.hasLength((String)number) && credentialType == CredentialType.IdCard && (birthDate = IdcardUtil.getBirthDate((String)number)) != null) {
            this.setBirthdate((Date)birthDate);
        }
        this.setLastUpdatedTime(timestamp);
        this.setLastSyncTime(timestamp);
    }

    public void changePhoto(String oneInchColorWhitePhoto, String twoInchColorBluePhoto) {
        this.setOneInchColorWhitePhoto(oneInchColorWhitePhoto);
        this.setTwoInchColorBluePhoto(twoInchColorBluePhoto);
        Timestamp timestamp = Timestamp.from(Instant.now());
        this.setLastUpdatedTime(timestamp);
        this.setLastSyncTime(timestamp);
    }

    public void changeNickHeadPhoto(String nick, String headPhoto) {
        if (org.springframework.util.StringUtils.hasLength((String)nick)) {
            this.setWechatNicky(nick);
        }
        if (org.springframework.util.StringUtils.hasLength((String)headPhoto)) {
            this.setHeadPhoto(headPhoto);
        }
        Timestamp timestamp = Timestamp.from(Instant.now());
        this.setLastUpdatedTime(timestamp);
        this.setLastSyncTime(timestamp);
    }

    public void changeWechat(String wechat, String nicky, boolean updateNicknameHeadPhoto) {
        this.setWechat(wechat);
        if (org.springframework.util.StringUtils.isEmpty((Object)this.getWechatNicky()) || !updateNicknameHeadPhoto) {
            this.setWechatNicky(nicky);
        }
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void redoAuthenticate() {
        if (this.getAuthenticateStatus() != RealNameAuthenticatedStatus.Failed) {
            throw new NotAllowedTenantException("\u60a8\u5df2\u63d0\u4ea4\u8ba4\u8bc1\uff01");
        }
        this.setAuthenticateStatus(RealNameAuthenticatedStatus.Authenticating);
        this.setAuthenticatedResult("\u624b\u52a8\u91cd\u65b0\u8ba4\u8bc1");
        Timestamp lastUpdatedTime = Timestamp.from(Instant.now());
        this.setAuthenticatedTime(lastUpdatedTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setLastSyncTime(lastUpdatedTime);
    }

    public void resetAuthenticateStatus() {
        this.setAuthenticateStatus(RealNameAuthenticatedStatus.Authenticating);
        this.setAuthenticatedResult("\u5e73\u53f0\u64cd\u4f5c\u91cd\u65b0\u8ba4\u8bc1");
        Timestamp lastUpdatedTime = Timestamp.from(Instant.now());
        this.setAuthenticatedTime(lastUpdatedTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setLastSyncTime(lastUpdatedTime);
    }

    public String getSelectIdNum() {
        if (this.selectedCredential != null) {
            return this.selectedCredential.getNumber();
        }
        return null;
    }

    public void recordCredentialChangeEvent() {
        this.recordEvent(TenantCredentialChangedEvent.create(this.getId(), this.getName(), this.selectedCredential.getCredentialType(), this.getTelephone(), this.selectedCredential.getNumber()));
    }

    public void changeAppealStatus(AppealStatus appealStatus) {
        this.setLastAppealStatus(appealStatus);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeCheckStatus(String idCardNum, UserCheckedStatus checkedStatus) {
        this.setCheckedStatus(checkedStatus);
        if (checkedStatus != UserCheckedStatus.None) {
            assert (idCardNum != null);
            ((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class)).dispatch((DomainEventAbstract)TenantCheckStatusChangedEvent.create(this, idCardNum));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getThirdPartyLoginNo() {
        return this.thirdPartyLoginNo;
    }

    public String getName() {
        return this.name;
    }

    public String getHeadPhoto() {
        return this.headPhoto;
    }

    public String getImIdentity() {
        return this.imIdentity;
    }

    public Sex getSex() {
        return this.sex;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getLonLatJson() {
        return this.lonLatJson;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public UserCheckedStatus getCheckedStatus() {
        return this.checkedStatus;
    }

    public RealNameAuthenticatedStatus getAuthenticateStatus() {
        return this.authenticateStatus;
    }

    public String getAuthenticatedResult() {
        return this.authenticatedResult;
    }

    public Timestamp getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    public String getStature() {
        return this.stature;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getNation() {
        return this.nation;
    }

    public String getNationality() {
        return this.nationality;
    }

    public Integer getWorkYear() {
        return this.workYear;
    }

    public String getDiseasesHistory() {
        return this.diseasesHistory;
    }

    public String getPoliticsStatus() {
        return this.politicsStatus;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getHouseholdType() {
        return this.householdType;
    }

    public String getEducation() {
        return this.education;
    }

    public String getNativePlace() {
        return this.nativePlace;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Collection<TenantUserCredentialsEntity> getCredentials() {
        return this.credentials;
    }

    public TenantUserCredentialsEntity getSelectedCredential() {
        return this.selectedCredential;
    }

    public String getHabitSetting() {
        return this.habitSetting;
    }

    public String getOneInchColorWhitePhoto() {
        return this.oneInchColorWhitePhoto;
    }

    public String getTwoInchColorBluePhoto() {
        return this.twoInchColorBluePhoto;
    }

    public String getCid() {
        return this.cid;
    }

    public String getWechat() {
        return this.wechat;
    }

    public String getWechatNicky() {
        return this.wechatNicky;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getLastCheckedStatusTime() {
        return this.lastCheckedStatusTime;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public BackgroundScreeningStatus getBackgroundScreeningStatus() {
        return this.backgroundScreeningStatus;
    }

    public Timestamp getLastBackGroundScreeningTime() {
        return this.lastBackGroundScreeningTime;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public String getEmergencyPhone() {
        return this.emergencyPhone;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public String getCertificateImage() {
        return this.CertificateImage;
    }

    public LocationValueType getPlaceOfNow() {
        return this.placeOfNow;
    }

    public AppealStatus getLastAppealStatus() {
        return this.lastAppealStatus;
    }

    public String getLastAppealResult() {
        return this.lastAppealResult;
    }

    public Date getLastAppealTime() {
        return this.lastAppealTime;
    }

    public Collection<TenantUserAppealsEntity> getAppeals() {
        return this.appeals;
    }

    public Collection<OrganizationEntity> getOrganizations() {
        return this.organizations;
    }

    public Collection<EmployeeEntity> getEmployeeEntities() {
        return this.employeeEntities;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setThirdPartyLoginNo(String thirdPartyLoginNo) {
        this.thirdPartyLoginNo = thirdPartyLoginNo;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setHeadPhoto(String headPhoto) {
        this.headPhoto = headPhoto;
    }

    protected void setImIdentity(String imIdentity) {
        this.imIdentity = imIdentity;
    }

    protected void setSex(Sex sex) {
        this.sex = sex;
    }

    protected void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    protected void setEmail(String email) {
        this.email = email;
    }

    protected void setLonLatJson(String lonLatJson) {
        this.lonLatJson = lonLatJson;
    }

    protected void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    protected void setCheckedStatus(UserCheckedStatus checkedStatus) {
        this.checkedStatus = checkedStatus;
    }

    protected void setAuthenticateStatus(RealNameAuthenticatedStatus authenticateStatus) {
        this.authenticateStatus = authenticateStatus;
    }

    protected void setAuthenticatedResult(String authenticatedResult) {
        this.authenticatedResult = authenticatedResult;
    }

    protected void setAuthenticatedTime(Timestamp authenticatedTime) {
        this.authenticatedTime = authenticatedTime;
    }

    protected void setStature(String stature) {
        this.stature = stature;
    }

    protected void setUserType(UserType userType) {
        this.userType = userType;
    }

    protected void setNation(String nation) {
        this.nation = nation;
    }

    protected void setNationality(String nationality) {
        this.nationality = nationality;
    }

    protected void setWorkYear(Integer workYear) {
        this.workYear = workYear;
    }

    protected void setDiseasesHistory(String diseasesHistory) {
        this.diseasesHistory = diseasesHistory;
    }

    protected void setPoliticsStatus(String politicsStatus) {
        this.politicsStatus = politicsStatus;
    }

    protected void setMilitaryStatus(String militaryStatus) {
        this.militaryStatus = militaryStatus;
    }

    protected void setHouseholdType(String householdType) {
        this.householdType = householdType;
    }

    protected void setEducation(String education) {
        this.education = education;
    }

    protected void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace;
    }

    protected void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setCredentials(Collection<TenantUserCredentialsEntity> credentials) {
        this.credentials = credentials;
    }

    protected void setSelectedCredential(TenantUserCredentialsEntity selectedCredential) {
        this.selectedCredential = selectedCredential;
    }

    protected void setHabitSetting(String habitSetting) {
        this.habitSetting = habitSetting;
    }

    protected void setOneInchColorWhitePhoto(String oneInchColorWhitePhoto) {
        this.oneInchColorWhitePhoto = oneInchColorWhitePhoto;
    }

    protected void setTwoInchColorBluePhoto(String twoInchColorBluePhoto) {
        this.twoInchColorBluePhoto = twoInchColorBluePhoto;
    }

    protected void setCid(String cid) {
        this.cid = cid;
    }

    protected void setWechat(String wechat) {
        this.wechat = wechat;
    }

    protected void setWechatNicky(String wechatNicky) {
        this.wechatNicky = wechatNicky;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setLastCheckedStatusTime(Timestamp lastCheckedStatusTime) {
        this.lastCheckedStatusTime = lastCheckedStatusTime;
    }

    protected void setLastSyncTime(Timestamp lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    protected void setBackgroundScreeningStatus(BackgroundScreeningStatus backgroundScreeningStatus) {
        this.backgroundScreeningStatus = backgroundScreeningStatus;
    }

    protected void setLastBackGroundScreeningTime(Timestamp lastBackGroundScreeningTime) {
        this.lastBackGroundScreeningTime = lastBackGroundScreeningTime;
    }

    protected void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    protected void setEmergencyPhone(String emergencyPhone) {
        this.emergencyPhone = emergencyPhone;
    }

    protected void setLicenseLevel(String licenseLevel) {
        this.licenseLevel = licenseLevel;
    }

    protected void setCertificateImage(String CertificateImage) {
        this.CertificateImage = CertificateImage;
    }

    protected void setPlaceOfNow(LocationValueType placeOfNow) {
        this.placeOfNow = placeOfNow;
    }

    protected void setLastAppealStatus(AppealStatus lastAppealStatus) {
        this.lastAppealStatus = lastAppealStatus;
    }

    protected void setLastAppealResult(String lastAppealResult) {
        this.lastAppealResult = lastAppealResult;
    }

    protected void setLastAppealTime(Date lastAppealTime) {
        this.lastAppealTime = lastAppealTime;
    }

    protected void setAppeals(Collection<TenantUserAppealsEntity> appeals) {
        this.appeals = appeals;
    }

    protected void setOrganizations(Collection<OrganizationEntity> organizations) {
        this.organizations = organizations;
    }

    protected void setEmployeeEntities(Collection<EmployeeEntity> employeeEntities) {
        this.employeeEntities = employeeEntities;
    }
}

