/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchMoveEmployeesCommand
extends CommandAbstract {
    private final String organId;
    private final String destDepartId;
    private final Collection<String> employeeIds;

    public void validate() {
        if (!StringUtils.hasLength((String)this.getOrganId())) {
            throw new BadTenantException("\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getDestDepartId())) {
            throw new BadTenantException(String.format("\u8f6c\u79fb\u7684\u76ee\u6807\u90e8\u95e8(%s)\u4e0d\u80fd\u4e3a\u7a7a!", this.getDestDepartId()));
        }
        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength((String)ii))) {
            throw new BadTenantException("\u8981\u8f6c\u79fb\u7684\u4eba\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public BatchMoveEmployeesCommand(String organId, Collection<String> employeeIds, String destDepartId) {
        this.organId = organId;
        this.employeeIds = employeeIds;
        this.destDepartId = destDepartId;
    }

    public static BatchMoveEmployeesCommand create(String organId, Collection<String> employeeIds, String destDepartId) {
        return new BatchMoveEmployeesCommand(organId, employeeIds, destDepartId);
    }

    public String getOrganId() {
        return this.organId;
    }

    public String getDestDepartId() {
        return this.destDepartId;
    }

    public Collection<String> getEmployeeIds() {
        return this.employeeIds;
    }
}

