/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.customize;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.components.models.CacheItemAbstract;
import com.bcxin.Infrastructures.components.models.DataCacheItem;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.enums.ImportedDataCategory;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.CompositeDataRepository;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.ImportDataEntityRepository;
import com.bcxin.tenant.domain.repositories.UniqueDataConstraintRepository;
import com.bcxin.tenant.domain.repositories.composites.BatchImportDepart;
import com.bcxin.tenant.domain.repositories.composites.BatchImportDepartResult;
import com.bcxin.tenant.domain.repositories.composites.EmployeeImportWrapper;
import com.bcxin.tenant.domain.services.commands.BatchImportEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.BatchLeaveEmployeeExcelCommand;
import com.bcxin.tenant.domain.services.commands.contracts.BatchImportContractCommand;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CompositeDataRepositoryImpl
implements CompositeDataRepository {
    private static final Logger log = LoggerFactory.getLogger(CompositeDataRepositoryImpl.class);
    private final EntityManager entityManager;
    private final DepartmentRepository departmentRepository;
    private final UnitWork unitWork;
    private final UniqueDataConstraintRepository uniqueDataConstraintRepository;
    private final EmployeeRepository employeeRepository;
    private final JsonProvider jsonProvider;
    private final ImportDataEntityRepository importDataEntityRepository;
    private final RetryProvider retryProvider;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final CacheProvider cacheProvider;
    private final TenantDbReader tenantDbReader;
    private final EnvConfig envConfig;

    public CompositeDataRepositoryImpl(EntityManager entityManager, DepartmentRepository departmentRepository, UnitWork unitWork, UniqueDataConstraintRepository uniqueDataConstraintRepository, EmployeeRepository employeeRepository, JsonProvider jsonProvider, ImportDataEntityRepository importDataEntityRepository, RetryProvider retryProvider, ThreadPoolTaskExecutor taskExecutor, CacheProvider cacheProvider, TenantDbReader tenantDbReader, EnvConfig envConfig) {
        this.entityManager = entityManager;
        this.departmentRepository = departmentRepository;
        this.unitWork = unitWork;
        this.uniqueDataConstraintRepository = uniqueDataConstraintRepository;
        this.employeeRepository = employeeRepository;
        this.jsonProvider = jsonProvider;
        this.importDataEntityRepository = importDataEntityRepository;
        this.retryProvider = retryProvider;
        this.taskExecutor = taskExecutor;
        this.cacheProvider = cacheProvider;
        this.tenantDbReader = tenantDbReader;
        this.envConfig = envConfig;
    }

    public BatchImportDepartResult execute(BatchImportDepart data) {
        return null;
    }

    public String execute(OrganizationEntity organization, BatchImportEmployeeCommand command) {
        ImportDataEntity importDataEntity = ImportDataEntity.create((String)organization.getId(), (String)command.getPath(), (ImportedDataCategory)ImportedDataCategory.Employee);
        for (BatchImportEmployeeCommand.EmployeeCommandItem commandItem : command.getCommandItems()) {
            String originalData = this.jsonProvider.getJson((Object)commandItem.getDataItem());
            if (commandItem.IsValid()) {
                importDataEntity.addDataItem(originalData);
                continue;
            }
            importDataEntity.addProcessedDataItem(originalData, ProcessedStatus.Error, commandItem.getErrorResult());
        }
        this.retryProvider.execute(() -> this.unitWork.executeTran(() -> this.importDataEntityRepository.save((EntityAbstract)importDataEntity)), 10);
        this.cacheProvider.put(importDataEntity.getId(), (CacheItemAbstract)DataCacheItem.create((Object)EmployeeImportWrapper.create((OrganizationEntity)organization, (ImportDataEntity)importDataEntity)));
        return importDataEntity.getId();
    }

    public String execute(OrganizationEntity organization, BatchImportContractCommand command) {
        ImportDataEntity importDataEntity = ImportDataEntity.create((String)organization.getId(), (String)command.getPath(), (ImportedDataCategory)ImportedDataCategory.Contract);
        for (BatchImportContractCommand.ContractCommandItem commandItem : command.getItems()) {
            String originalData = this.jsonProvider.getJson((Object)commandItem.getData());
            if (commandItem.IsValid()) {
                importDataEntity.addDataItem(originalData);
                continue;
            }
            importDataEntity.addProcessedDataItem(originalData, ProcessedStatus.Error, commandItem.getErrorResult());
        }
        this.retryProvider.execute(() -> this.unitWork.executeTran(() -> this.importDataEntityRepository.save((EntityAbstract)importDataEntity)), 10);
        return importDataEntity.getId();
    }

    public String execute(OrganizationEntity organization, BatchLeaveEmployeeExcelCommand command) {
        ImportDataEntity importDataEntity = ImportDataEntity.create((String)organization.getId(), (String)command.getPath(), (ImportedDataCategory)ImportedDataCategory.Contract);
        for (BatchLeaveEmployeeExcelCommand.EmployeeCommandItem commandItem : command.getCommandItems()) {
            String originalData = this.jsonProvider.getJson((Object)commandItem.getDataItem());
            if (StringUtils.hasLength((String)commandItem.getDataItem().getErrMsg())) {
                importDataEntity.addProcessedDataItem(originalData, ProcessedStatus.Error, commandItem.getDataItem().getErrMsg());
                continue;
            }
            if (commandItem.IsValid()) {
                importDataEntity.addDataItem(originalData);
                continue;
            }
            importDataEntity.addProcessedDataItem(originalData, ProcessedStatus.Error, commandItem.getErrorResult());
        }
        this.retryProvider.execute(() -> this.unitWork.executeTran(() -> this.importDataEntityRepository.save((EntityAbstract)importDataEntity)), 10);
        return importDataEntity.getId();
    }
}

