/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class URLUtil {
    public static String encode(String url) {
        if (!StringUtils.hasLength((String)url)) {
            return url;
        }
        String path = url;
        String queryPath = null;
        if (url.contains("?")) {
            path = url.substring(0, url.indexOf("?"));
            queryPath = url.substring(url.indexOf("?") + 1);
        }
        List sectionPaths = Arrays.stream(path.split("/")).collect(Collectors.toList());
        StringBuilder urlEncoded = new StringBuilder();
        for (int index = 0; index < sectionPaths.size(); ++index) {
            String sectionValue = (String)sectionPaths.get(index);
            if (index > 3) {
                sectionValue = URLUtil.encodeValue(sectionValue);
            }
            urlEncoded.append(sectionValue);
            if (index == sectionPaths.size() - 1) continue;
            urlEncoded.append("/");
        }
        if (StringUtils.hasLength((String)queryPath)) {
            String[] querySectionPaths = queryPath.split("&");
            for (int index = 0; index < querySectionPaths.length; ++index) {
                if (index == 0) {
                    urlEncoded.append("?");
                }
                if (index % 2 == 0) {
                    urlEncoded.append(querySectionPaths[index]);
                    urlEncoded.append("=");
                    continue;
                }
                urlEncoded.append(URLUtil.encodeValue(querySectionPaths[index]));
                if (index == querySectionPaths.length - 1) continue;
                urlEncoded.append("&");
            }
        }
        return urlEncoded.toString();
    }

    private static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadTenantException(String.format("\u5730\u5740(%s)\u7f16\u7801\u65e0\u6548!", value));
        }
    }

    public static String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return value;
        }
    }
}

