/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class DateUtil {
    public static String format2ShortDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static String format2ShortDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String format2ShortDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String format2ShortDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyyMMddHHmmss").format(date);
    }

    public static Date fromString(String text) {
        if (!StringUtils.hasLength((String)text)) {
            return null;
        }
        text = text.replace(" ", "");
        for (String ii : Stream.of("-", "\\.", "/").collect(Collectors.toList())) {
            try {
                String[] splitItems = text.split(ii);
                if (splitItems.length != 3) continue;
                String formattedText = String.format("%s-%s-%s", splitItems[0], DateUtil.leftString(splitItems[1], 2, "0"), DateUtil.leftString(splitItems[2], 2, "0"));
                return new SimpleDateFormat("yyyy-MM-dd").parse(formattedText);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static String leftString(String input, int length, String pad) {
        if (!StringUtils.hasLength((String)input)) {
            return null;
        }
        if (input.length() >= length) {
            return input;
        }
        return String.format("0%s", input);
    }
}

