/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.rbac.domain.RbacCustomDbReader;
import com.bcxin.rbac.domain.dtos.custom.RbacCustomRoleDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAppDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitOptionDto;
import com.bcxin.rbac.domain.dtos.custom.RbacUserDto;
import com.bcxin.rbac.domain.dtos.custom.RbacUserSearchDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class RbacCustomDbReaderImpl
implements RbacCustomDbReader {
    private final EntityManager entityManager;

    public List<RbacCustomRoleDto> findOrgRoleList(String organizationId, String roleName, String employeeId) {
        HashMap<String, String> params = new HashMap<String, String>();
        String sql = "select new com.bcxin.rbac.domain.dtos.custom.RbacCustomRoleDto(t.id, t.roleName, t.roleType, t.remark, t.seq, t.createTime, t.updateTime)  from RbacCustomRoleEntity t ";
        if (StringUtils.isNotBlank((CharSequence)employeeId)) {
            sql = sql + " left join RbacCustomRoleUserEntity u on u.rbacRoleId = t.id ";
        }
        sql = sql + " where t.organizationId = :organizationId ";
        params.put("organizationId", organizationId);
        if (StringUtils.isNotBlank((CharSequence)employeeId)) {
            sql = sql + " and u.tenantEmployeeId = :employeeId ";
            params.put("employeeId", employeeId);
        }
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            sql = sql + " and t.roleName like :roleName ";
            params.put("roleName", "%" + roleName + "%");
        }
        sql = sql + " order by t.seq desc ";
        TypedQuery query = this.entityManager.createQuery(sql, RbacCustomRoleDto.class);
        for (String key : params.keySet()) {
            query.setParameter(key, params.get(key));
        }
        return query.getResultList();
    }

    public Pageable<RbacUserDto> getRbacUserDtoList(RbacUserSearchDto searchDto) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String sqlStr = "select e.id as employeeId, e.occupation_type as occupationType, t.name as userName, t.telephone as mobile, d.id as departId, d.name as departName ";
        if (searchDto.getRoleId() != null) {
            sqlStr = sqlStr + ", ru.create_time as addRoleTime ";
        }
        sqlStr = sqlStr + "from tenant_employees e left join tenant_users t on e.tenant_user_id = t.id left join tenant_departments d on e.department_id = d.id left join tenant_user_credentials c on t.id = c.tenant_user_id and c.selected = 1 ";
        if (searchDto.getRoleId() != null) {
            sqlStr = sqlStr + "left join rbac_custom_role_user ru on e.id = ru.tenant_employee_id ";
        }
        sqlStr = sqlStr + " where e.status = 0 and e.organization_id = :organizationId ";
        parameters.put("organizationId", searchDto.getOrganizationId());
        String sqlCount = "select count(1) from tenant_employees e left join tenant_users t on e.tenant_user_id = t.id left join tenant_departments d on e.department_id = d.id left join tenant_user_credentials c on t.id = c.tenant_user_id and c.selected = 1 ";
        if (searchDto.getRoleId() != null) {
            sqlCount = sqlCount + "left join rbac_custom_role_user ru on e.id = ru.tenant_employee_id ";
        }
        sqlCount = sqlCount + " where e.status = 0 and e.organization_id = :organizationId ";
        if (searchDto.getRoleId() != null) {
            sqlStr = sqlStr + " and ru.rbac_role_id = :roleId ";
            sqlCount = sqlCount + " and ru.rbac_role_id = :roleId ";
            parameters.put("roleId", searchDto.getRoleId());
        }
        if (StringUtils.isNotBlank((CharSequence)searchDto.getKeyWord())) {
            sqlStr = sqlStr + " and (t.name like :keyword or t.telephone like :keyword or c.number like :keyword) ";
            sqlCount = sqlCount + " and (t.name like :keyword or t.telephone like :keyword or c.number like :keyword) ";
            parameters.put("keyword", "%" + searchDto.getKeyWord() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)searchDto.getDepartId())) {
            sqlStr = sqlStr + " and d.id = :departId ";
            sqlCount = sqlCount + " and d.id = :departId ";
            parameters.put("departId", searchDto.getDepartId());
        }
        if (searchDto.getOccupationType() != null) {
            sqlStr = sqlStr + " and e.occupation_type =:occupationType ";
            sqlCount = sqlCount + " and e.occupation_type =:occupationType ";
            parameters.put("occupationType", searchDto.getOccupationType().ordinal());
        }
        Query query = this.entityManager.createNativeQuery(sqlStr);
        Query cquery = this.entityManager.createNativeQuery(sqlCount);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
            cquery.setParameter(key, parameters.get(key));
        }
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(RbacUserDto.class));
        query.setFirstResult(searchDto.getSkip()).setMaxResults(searchDto.getPageSize());
        List resultList = query.getResultList();
        int sum = Integer.valueOf(cquery.getResultList().get(0).toString());
        return Pageable.create((int)searchDto.getPageIndex(), (int)searchDto.getPageSize(), (int)sum, (Collection)resultList);
    }

    public List<RbacPermitAppDto> findOrgAppList(String organizationId) {
        String findAppCodeListSql = "select BIND_APPLICATIONS from t_domain where ID = :organizationId ";
        Query findAppCodeListQuery = this.entityManager.createNativeQuery(findAppCodeListSql);
        findAppCodeListQuery.setParameter("organizationId", (Object)organizationId);
        String bindApplications = findAppCodeListQuery.getResultList().get(0).toString();
        ArrayList<String> authAppCodeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)bindApplications)) {
            authAppCodeList.addAll(JSONObject.parseArray((String)bindApplications, String.class));
        }
        authAppCodeList.add("__zidingyiyingyongPTJCGN");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        String sql = "select new com.bcxin.rbac.domain.dtos.custom.RbacPermitAppDto(t.id, t.appCode, t.appName, t.appLogo, t.category)  from RbacPermitAppEntity t  where t.appCode in :authAppCodeList  order by t.categorySeq, t.seq asc ";
        params.put("authAppCodeList", authAppCodeList);
        TypedQuery query = this.entityManager.createQuery(sql, RbacPermitAppDto.class);
        for (String key : params.keySet()) {
            query.setParameter(key, params.get(key));
        }
        return query.getResultList();
    }

    public List<RbacPermitOptionDto> findAppOptionList(Long appId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        String sql = "select new com.bcxin.rbac.domain.dtos.custom.RbacPermitOptionDto(t.id, t.permitAppId, t.appCode, t.category, t.optionType, t.optionCode, t.optionName)  from RbacPermitOptionEntity t  where t.permitAppId = :appId  order by t.seq asc ";
        params.put("appId", appId);
        TypedQuery query = this.entityManager.createQuery(sql, RbacPermitOptionDto.class);
        for (String key : params.keySet()) {
            query.setParameter(key, params.get(key));
        }
        return query.getResultList();
    }

    public List<RbacUserDto> getRbacUserDtoList(String organizationId, List<String> names) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String sqlStr = "select e.id as employeeId, t.name as userName, t.telephone as mobile  from tenant_employees e  left join tenant_users t on e.tenant_user_id = t.id  where e.status = 0 and e.organization_id = :organizationId and t.name in (:names) ";
        parameters.put("organizationId", organizationId);
        parameters.put("names", names);
        Query query = this.entityManager.createNativeQuery(sqlStr);
        for (String key : parameters.keySet()) {
            query.setParameter(key, parameters.get(key));
        }
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean(RbacUserDto.class));
        List resultList = query.getResultList();
        return CollectionUtil.isNotEmpty((Collection)resultList) ? resultList : new ArrayList();
    }

    public RbacCustomDbReaderImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

