/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import java.util.Collection;
import org.springframework.util.StringUtils;

public class EmployeeBeforeEntryValidationEvent
extends DomainEventAbstract<String> {
    private final String areaCode;
    private final String organizationId;
    private final Collection<TenantUserOccupationTypeInfo> tenantUsers;

    public EmployeeBeforeEntryValidationEvent(String areaCode, String organizationId, Collection<TenantUserOccupationTypeInfo> tenantUsers) {
        super((Object)(StringUtils.hasLength((String)areaCode) ? areaCode : ""));
        this.areaCode = areaCode;
        this.organizationId = organizationId;
        this.tenantUsers = tenantUsers;
    }

    public static EmployeeBeforeEntryValidationEvent create(String areaCode, String organizationId, Collection<TenantUserOccupationTypeInfo> tenantUsers) {
        return new EmployeeBeforeEntryValidationEvent(areaCode, organizationId, tenantUsers);
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<TenantUserOccupationTypeInfo> getTenantUsers() {
        return this.tenantUsers;
    }

    public static class TenantUserOccupationTypeInfo {
        private final String tenantUserId;
        private final String name;
        private final OccupationType occupationType;
        private final CredentialType credentialType;
        private final String credentialNumber;
        private final String telephone;
        private final boolean isBack;

        public TenantUserOccupationTypeInfo(String tenantUserId, String name, OccupationType occupationType, CredentialType credentialType, String credentialNumber, String telephone, boolean isBack) {
            this.tenantUserId = tenantUserId;
            this.name = name;
            this.occupationType = occupationType;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
            this.telephone = telephone;
            this.isBack = isBack;
        }

        public static TenantUserOccupationTypeInfo create(String tenantUserId, String name, OccupationType occupationType, CredentialType credentialType, String credentialNumber, String telephone, boolean isBack) {
            return new TenantUserOccupationTypeInfo(tenantUserId, name, occupationType, credentialType, credentialNumber, telephone, isBack);
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public String getName() {
            return this.name;
        }

        public OccupationType getOccupationType() {
            return this.occupationType;
        }

        public CredentialType getCredentialType() {
            return this.credentialType;
        }

        public String getCredentialNumber() {
            return this.credentialNumber;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public boolean isBack() {
            return this.isBack;
        }
    }
}

