package com.bcxin.file;

import cn.hutool.core.io.FileUtil;
import com.bcxin.file.model.FtpConfig;

import javax.swing.*;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * <b> zxf </b>
 * @author ZXF
 * @create 2022/10/19 0019 13:41
 * @version
 * @注意事项 </b>
 */
public class FtpSwingWorker1 extends SwingWorker {

    private final String filePath;
    private final FtpConfig ftpConfig;

    public FtpSwingWorker1(FtpConfig ftpConfig, String filePath) {
        this.ftpConfig = ftpConfig;
        this.filePath = filePath;
    }

    @Override
    protected Object doInBackground() throws Exception {
        try {
            List<File> fileList = getFile(new File(filePath));
            if(fileList != null){
                int number = 0;
                double proNum = 100.0/fileList.size();
                BcxinFtpClient ftpClient = new BcxinFtpClient();
                try {
                    try{
                        boolean conn = ftpClient.connect(ftpConfig.getIp(), ftpConfig.getUserName(), ftpConfig.getPassword(), ftpConfig.getPort());
                        if(!conn){
                            throw new Exception("FTP连接失败");
                        }
                    }catch (Exception e){
                        JOptionPane.showMessageDialog(null,"FTP连接失败！");
                        return null;
                    }
                    for (File fileUrl : fileList) {
                        number++;
                        String asolutePath = fileUrl.getAbsolutePath();
                        asolutePath = asolutePath.replaceAll("\\\\", "/");
                        asolutePath = asolutePath.substring(asolutePath.indexOf("/uploads"));
                        System.out.println(asolutePath);
                        String file = ftpConfig.getPath() + asolutePath;
                        file= ftpClient.getEncodingName(file);
                        System.out.println(file);
                        boolean result = FtpUtil.bcxUploadFile(ftpClient, file, new FileInputStream(fileUrl));
                        if(!result){
                            FileUtil.writeString(fileUrl.getAbsolutePath(),new File(filePath).getParent()+"/error.log","utf-8");
                        }
                        publish(number);
                        setProgress((int) (number * proNum));
                        if(result){
                            System.out.println("上传成功");
                        }else{
                            System.out.println("上传失败");
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }finally {
                    if(ftpClient != null){
                        try {
                            ftpClient.disconnect();
                        }catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                }
            }
            System.out.println("上传完成");
        }catch (Exception ex){
            ex.printStackTrace();
            System.out.println("上传失败");
        }

        return String.valueOf(100);

    }


    private List<File> getFile(File dirFile){
        List<File> fileList = new ArrayList<>();
        if(dirFile.isDirectory()){
            File[] dirFiles = dirFile.listFiles();
            if(dirFiles != null){
                for (File file : dirFiles) {
                    if(file.isFile()){
                        fileList.add(file);
                        continue;
                    }
                    if(file.isDirectory()){
                        fileList.addAll(getFile(file));
                    }
                }
            }
        }else{
            fileList.add(dirFile);
        }


        return fileList;
    }
}
