package com.bcxin.file;

import cn.hutool.core.io.FileUtil;

import java.io.OutputStream;
import java.io.PrintStream;

public class CustomSystemErrorPrintStream extends PrintStream {
    public static CustomSystemErrorPrintStream instance = new CustomSystemErrorPrintStream(System.out);

    private String errorPath;
    public void setErrorPath(String path) {
        this.errorPath = path;
    }

    public CustomSystemErrorPrintStream(OutputStream out) {
        super(out);
    }

    @Override
    public void print(String s) {
            /*
            if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }
             */

        try {
            if (errorPath != null && errorPath != "") {
                FileUtil.appendString(s,errorPath,"UTF-8");
            }
        }catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void println() {
            /*
            if(!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }
             */
        try {
            if (errorPath != null && errorPath != "") {
                FileUtil.appendString("\n\t", errorPath, "UTF-8");
            }
        }catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}
