package com.bcxin.file;

import cn.hutool.core.io.FileUtil;
import com.bcxin.file.model.FileLog;

import javax.swing.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Auther linqinglin
 * @date 2022/9/23 12:27
 */
public class FileSwingWorker  {

    private final JButton jButton;
    private final List<FileLog> logList;
    private final String savePath;
    private final boolean checkPepeat;

    public FileSwingWorker(JButton jButton,List<FileLog> logList,String savePath,boolean checkPepeat) {
        this.jButton = jButton;
        this.logList = logList;
        this.savePath = savePath;
        this.checkPepeat = checkPepeat;
    }

    public Object execute() {
        DataBaseUtil dataBaseUtil = null;
        try {
            if(checkPepeat){
                for(int index=0;index<10;index++) {
                    try {
                        dataBaseUtil = new DataBaseUtil();
                        break;
                    } catch (Exception e) {
                        jButton.setEnabled(true);
                        jButton.setText("开始下载");
                        return null;
                    }
                }
            }

            if(logList != null && logList.size() > 0) {

                double proNum = 100.0 / logList.size();
                //根据数据数量情况，切分不同的大小
                int limit = 100;
                //计算拆分次数
                int count = new Double(Math.ceil(logList.size() * 1.0 / limit)).intValue();
                //存放拆分数据
                List<FileLog> errorList = new ArrayList<>();
                //循环拆分次数 生成相应数据文件
                Collection<List<FileLog>> pagesLogs = new ArrayList<>();
                for (int i = 0; i < count; i++) {
                    List<FileLog> subList = logList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                    pagesLogs.add(subList);
                }

                DataBaseUtil finalDataBaseUtil = dataBaseUtil;
                pagesLogs.parallelStream().forEach(subList -> {
                    int number = 0;
                    if (checkPepeat) {
                        List<FileLog> dbLogs = finalDataBaseUtil.readData(subList);
                        //subList.removeAll(dbLogs);
                        subList = subList.stream().filter(ii -> {
                            Optional<FileLog> dbFileLogOptional = dbLogs.stream().filter(ix->ix.equals(ii) &&
                                    ix.getFileUrl().equals(ii.getFileUrl())).findFirst();
                            if(!dbFileLogOptional.isPresent()) {
                                return true;
                            }
                            boolean result = !dbFileLogOptional.isPresent();//!dbFileLogOptional.get().getFileUrl().equals(ii.getFileUrl());

                            return result;
                        }).collect(Collectors.toList());
                    }
                    System.err.println(String.format("即将下载的文件数量=%s", subList.size()));

                    List<FileLog> batchFileLogs = new ArrayList<>();
                    for (FileLog fileLog : subList) {
                        try {
                            number++;
                            if (!FileUtils.downloadFile(fileLog.getFileUrl(), savePath)) {
                                errorList.add(fileLog);
                            }
                            batchFileLogs.add(fileLog);

                            if (checkPepeat && batchFileLogs.size() >= 10) {
                                finalDataBaseUtil.saveData(batchFileLogs);
                                batchFileLogs.clear();
                            }
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }

                    if (checkPepeat && batchFileLogs.size() > 0) {
                        try {
                            finalDataBaseUtil.saveData(batchFileLogs);
                            batchFileLogs.clear();
                        }
                        catch (Exception ex) {
                            System.err.println(String.format("数据保(%s)存异常:%s", batchFileLogs.size(), ex.toString()));
                            ex.toString();
                        }
                    }
                });

                logList.removeAll(errorList);
                if (logList.size() < 1) {
                    jButton.setText("图片不存在");
                    return String.valueOf(100);
                }
            }
        }catch (Exception ex){
            jButton.setEnabled(true);
            jButton.setText("开始下载");
            ex.printStackTrace();
            FileUtil.appendString(String.format("执行过程异常:%s", ex.toString()), gui.errorPath, "UTF-8");
        }finally {
            if (dataBaseUtil != null) {
                dataBaseUtil.close();
            }
        }

        return String.valueOf(100);
    }
}
