/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class BcxinFtpClient {
    private FTPClient client;

    public BcxinFtpClient() {
        this.client = new FTPClient();
    }

    public FTPClient getClient() {
        return this.client;
    }

    public void setClient(FTPClient client) {
        this.client = client;
    }

    public BcxinFtpClient(boolean ftps) {
        if (ftps) {
            try {
                this.client = new FTPSClient(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.client = new FTPClient();
        }
    }

    public boolean changeDir(String remotePath) throws Exception {
        return this.client.changeWorkingDirectory(remotePath);
    }

    public boolean connect(String host, String username, String password, int port) throws Exception {
        boolean result = false;
        this.client.setConnectTimeout(30000);
        try {
            this.client.connect(host, port);
            this.client.login(username, password);
            this.client.enterLocalPassiveMode();
            int reply = this.client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.client.disconnect();
                result = false;
            }
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void disconnect() throws Exception {
        if (this.client != null) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean downloadFileAfterCheck(String remotePath, String localFile) throws IOException {
        boolean rst;
        try (FileOutputStream out = null;){
            File file = new File(localFile);
            if (!file.exists()) {
                this.client.setFileType(2);
                out = new FileOutputStream(localFile);
                rst = this.client.retrieveFile(remotePath, (OutputStream)out);
            } else {
                rst = true;
            }
        }
        if (out != null) {
            out.close();
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String localFile) throws IOException {
        boolean rst;
        try (FileOutputStream out = null;){
            this.client.setFileType(2);
            out = new FileOutputStream(localFile);
            rst = this.client.retrieveFile(remotePath, (OutputStream)out);
        }
        return rst;
    }

    public List<String> listFileNameInDir(String remoteDir) throws Exception {
        if (this.changeDir(remoteDir)) {
            FTPFile[] files = this.client.listFiles();
            ArrayList<String> v = new ArrayList<String>();
            for (FTPFile file : files) {
                if (file.isDirectory()) continue;
                v.add(file.getName());
            }
            return v;
        }
        return null;
    }

    public List<FTPFile> listFileInDir(String remoteDir) throws Exception {
        if (this.changeDir(remoteDir)) {
            FTPFile[] files = this.client.listFiles();
            ArrayList<FTPFile> v = new ArrayList<FTPFile>();
            for (FTPFile file : files) {
                if (file.isDirectory()) continue;
                v.add(file);
            }
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String localFile, String remotePath) throws IOException {
        boolean rst;
        try (FileInputStream in = new FileInputStream(localFile);){
            this.client.setFileType(2);
            rst = this.client.storeFile(remotePath, (InputStream)in);
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(InputStream in, String remotePath) throws IOException {
        boolean rst;
        try {
            this.client.setFileType(2);
            rst = this.client.storeFile(remotePath, in);
        }
        finally {
            in.close();
        }
        return rst;
    }

    public List<String> listSubDirInDir(String remoteDir) throws Exception {
        if (this.changeDir(remoteDir)) {
            FTPFile[] files = this.client.listFiles();
            ArrayList<String> v = new ArrayList<String>();
            for (FTPFile file : files) {
                if (!file.isDirectory()) continue;
                v.add(file.getName());
            }
            return v;
        }
        return null;
    }

    public boolean createDirectory(String dirName) {
        return this.createMultiDirectory(dirName);
    }

    public String reName(String name, String remote) {
        try {
            boolean status;
            this.client.enterLocalPassiveMode();
            this.client.setFileType(2);
            String result = null;
            FTPFile[] files = this.client.listFiles(remote);
            result = files.length == 1 ? ((status = this.client.rename(remote, name)) ? "200" : "300") : "400";
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isARemoteDirectory(String path) {
        String cache = "/";
        try {
            cache = this.client.printWorkingDirectory();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            boolean isDir = this.changeDir(path);
            this.changeDir(cache);
            return isDir;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getWorkingDirectory() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createMultiDirectory(String multiDirectory) {
        boolean bool = false;
        try {
            String[] dirs = multiDirectory.split("/");
            if (dirs.length == 1) {
                dirs = multiDirectory.split(File.separator);
                this.client.changeWorkingDirectory(File.separator);
            } else {
                this.client.changeWorkingDirectory("/");
            }
            for (int i = 1; dirs != null && i < dirs.length; ++i) {
                if (this.client.changeWorkingDirectory(dirs[i])) continue;
                if (this.client.makeDirectory(dirs[i])) {
                    if (this.client.changeWorkingDirectory(dirs[i])) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            bool = true;
            return bool;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return bool;
        }
    }

    public boolean deleteServerFiles(String deleteFiles) {
        boolean type = false;
        if (!this.client.isConnected() || !this.client.isAvailable()) {
            System.out.println(">>>>>FTP\u670d\u52a1\u5668\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed\u6216\u8005\u8fde\u63a5\u65e0\u6548*****\u653e\u5f03\u6587\u4ef6\u4e0a\u4f20****");
            return false;
        }
        try {
            boolean changeFlag = this.client.changeWorkingDirectory(deleteFiles);
            if (changeFlag) {
                FTPFile[] ftpFiles;
                for (FTPFile ftpFile : ftpFiles = this.client.listFiles()) {
                    System.out.println("----------------::::" + this.client.printWorkingDirectory());
                    if (ftpFile.isFile()) {
                        boolean deleteFlag = this.client.deleteFile(ftpFile.getName());
                        if (deleteFlag) {
                            System.out.println(">>>>>\u5220\u9664\u670d\u52a1\u5668\u6587\u4ef6\u6210\u529f****" + ftpFile.getName());
                            type = true;
                            continue;
                        }
                        System.out.println(">>>>>\u5220\u9664\u670d\u52a1\u5668\u6587\u4ef6\u5931\u8d25****" + ftpFile.getName());
                        type = false;
                        continue;
                    }
                    String workingDirectory = this.client.printWorkingDirectory();
                    this.deleteServerFiles(workingDirectory + "/" + ftpFile.getName());
                }
                String workingDirectory = this.client.printWorkingDirectory();
                this.client.removeDirectory(workingDirectory);
                this.client.changeToParentDirectory();
            } else {
                boolean deleteFlag = this.client.deleteFile(deleteFiles);
                if (deleteFlag) {
                    System.out.println(">>>>>\u5220\u9664\u670d\u52a1\u5668\u6587\u4ef6\u6210\u529f****" + deleteFiles);
                    type = true;
                } else {
                    System.out.println(">>>>>\u5220\u9664\u670d\u52a1\u5668\u6587\u4ef6\u5931\u8d25****" + deleteFiles);
                    type = false;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return type;
    }

    public String getEncodingName(String fileName) throws UnsupportedEncodingException {
        String cc = new String(fileName.getBytes(), "ISO-8859-1");
        return cc;
    }
}

