//
//  KSNavigationController.m
//  Navigation
//
//  Created by 刘荣毅 on 15/12/9.
//  Copyright © 2015年 Lanni. All rights reserved.
//

#import "KSNavigationController.h"

@interface KSNavigationController ()<UIGestureRecognizerDelegate>

@end

@implementation KSNavigationController

- (void)viewDidLoad {
    [super viewDidLoad];
    //设置手势代理
    self.interactivePopGestureRecognizer.delegate = self;
    //设置NavigationBar
    [self setupNavigationBar];
}

//设置导航栏主题
- (void)setupNavigationBar
{
//    UINavigationBar *appearance = [UINavigationBar appearance];
//    //统一设置导航栏颜色，如果单个界面需要设置，可以在viewWillAppear里面设置，在viewWillDisappear设置回统一格式。
//    [appearance setBarTintColor:[UIColor getColor:@"fb9c0a"]];
//
//    //导航栏title格式
//    NSMutableDictionary *textAttribute = [NSMutableDictionary dictionary];
//    textAttribute[NSForegroundColorAttributeName] = [UIColor whiteColor];
//    textAttribute[NSFontAttributeName] = [UIFont systemFontOfSize:15];
//    [appearance setTitleTextAttributes:textAttribute];
    
    self.navigationBar.tintColor = [UIColor whiteColor];
    
}

- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated
{
    if (self.viewControllers.count > 0) {
        viewController.hidesBottomBarWhenPushed = YES;
//        UIButton *backButton = [[UIButton alloc]initWithFrame:CGRectMake(0, 0, 44, 44)];
//        [backButton setImage:[UIImage imageNamed:@"fanhui"] forState:UIControlStateNormal];
//        [backButton setImage:[UIImage imageNamed:@"fanhui"] forState:UIControlStateHighlighted];
//        [backButton setImageEdgeInsets:UIEdgeInsetsMake(0, -50, 0, 0)];
//        [backButton addTarget:self action:@selector(popView) forControlEvents:UIControlEventTouchUpInside];
//        viewController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]initWithCustomView:backButton];
    }
    
    [super pushViewController:viewController animated:animated];
}

- (void)popView
{
    [self popViewControllerAnimated:YES];
}

//手势代理
- (BOOL)gestureRecognizerShouldBegin:(UIGestureRecognizer *)gestureRecognizer
{
    return self.childViewControllers.count > 1;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - setter and getter
- (void)setBackTitle:(NSString *)backTitle {
    if (_backTitle != backTitle) {
        _backTitle = backTitle;
        UIBarButtonItem *backBarButtonItem = [[UIBarButtonItem alloc] init];
        backBarButtonItem.title = _backTitle;
        self.navigationItem.backBarButtonItem = backBarButtonItem;
    }
}

@end
