class Resources {
  loadImage(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  onload(callback) {
    const pr = [];

    const source = {
      // abort: "images/abort.gif",
      // abortBig: "images/abort_big.gif",
      auto: 'images/auto.gif',
      // autoBig: "images/auto_big.gif",
      complete: 'images/complete.gif',
      // completeBig: "images/complete_big.gif",
      manual: 'images/manual.gif',
      // manualBig: "images/manual_big.gif",
      start: 'images/start.gif',
      // startBig: "images/start_big.gif",
      subflow: 'images/subflow.gif',
      // subflowBig: "images/subflow_big.gif",
      // suspend: "images/suspend.gif",
      // suspendBig: "images/suspend_big.gif",
      // terminate: "images/terminate.gif",
      // terminateBig: "images/terminate_big.gif",
    };

    for (const key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        const url = source[key];
        const p = this.loadImage(url).then((img) => {
          switch (key) {
            case 'start':
              Resources.IMG_START_NODE = img;
              break;
            case 'complete':
              Resources.IMG_COMPLETE_NODE = img;
              break;
            case 'auto':
              Resources.IMG_AUTO_NODE = img;
              break;
            case 'manual':
              Resources.IMG_MANUAL_NODE = img;
              break;
            case 'subflow':
              Resources.IMG_SUBFLOW_NODE = img;
              break;
            default:
              break;
          }
          return img;
        }).catch(err => console.log(err));
        pr.push(p);
      }
    }

    Promise.all(pr).then(() => {
      callback();
    });
  }
}

Resources.IMG_START_NODE = null;
Resources.IMG_COMPLETE_NODE = null;
Resources.IMG_AUTO_NODE = null;
Resources.IMG_MANUAL_NODE = null;
Resources.IMG_SUBFLOW_NODE = null;

Resources.FONT_METRICS = {
  width: 12,
  height: 12,
  ascent: 1,
};

Resources.COLOR = {
  white: 'rgb(255, 255, 255)',
  lightGray: 'rgb(229, 229, 229)',
  black: 'rgb(0, 0, 0)',
  lightYellow: '#FFFFE1',
  blue: 'blue',
};

export default Resources;
