class FlowType {
  static getActionName(code) {
    if (code == null || code.trim().length <= 0) {
      return FlowType.ACTIONCODES[0];
    }

    for (let i = 0; i < FlowType.ACTIONCODES.length; i += 1) {
      if (code === FlowType.ACTIONCODES[i]) {
        return FlowType.ACTIONNAMES[i];
      }
    }

    return '';
  }

  static getActionCode(name) {
    if (name == null || name.trim().length <= 0) {
      return FlowType.ACTIONNAMES[0];
    }

    for (let i = 0; i < FlowType.ACTIONNAMES.length; i += 1) {
      if (name === FlowType.ACTIONCODES[i]) {
        return FlowType.ACTIONCODES[i];
      }
    }

    return '';
  }
}

// 流程状态
// FlowType.CLOSE_END = 0x10000000;
FlowType.FLOWSTATUS_OPEN_NOSTART = 0x00000010; // 流程初始状态第一个结点为当前结点
FlowType.FLOWSTATUS_OPEN_RUN_RUNNING = 0x00000100; // 流程运转状态
FlowType.FLOWSTATUS_OPEN_RUN_SUSPEND = 0x00001000; // 流程挂起状态
FlowType.FLOWSTATUS_CLOSE_ABORT = 0x00010000; // 流程拒绝状态
FlowType.FLOWSTATUS_CLOSE_COMPLETE = 0x00100000; // 流程完成状态
FlowType.FLOWSTATUS_CLOSE_TERMINAT = 0x01000000; // 流程终止状态

// 流程处理动作
FlowType.START2RUNNING = '1'; // 开始
FlowType.START2TERMINATE = '2'; // 终止1
FlowType.SUSPEND2RUNNING = '3'; // 恢复
FlowType.RUNNING2SUSPEND = '4'; // 挂起1
FlowType.SUSPEND2ABORT = '5'; // 取消
FlowType.RUNNING2COMPLETE = '6'; // 完成
FlowType.RUNNING2TERMIATE = '7'; // 终止2
FlowType.RUNNING2RUNNING_NEXT = '80'; // 运行/下一步
FlowType.RUNNING2RUNNING_BACK = '81'; // 退回
FlowType.RUNNING2RUNNING_SELF = '82'; // 自循环
FlowType.SUSPEND2SUSPEND = '9'; // 挂起2

// 自动处理类型
FlowType.NOTDO = '0'; // 不处理
FlowType.DONEXT = '1'; // 自动流转
FlowType.DOTERMINAT = '2'; // 自动终止
FlowType.DOBACK = '3'; // 自动回退
FlowType.DOBACKTONODE = '4'; // 自动回退至指定节点

// 审核通过条件
FlowType.ORCONDITION = '0'; // 审核通过条件－－或－－任一审核通过
FlowType.GROUPANDCNDT = '1'; // 审核通过条件－－与－－每组（分号隔开）须至少有一人审核才可通过
FlowType.ANDCONDITION = '2'; // 审核通过条件－－与－－每组所有人均需审核才可通过
FlowType.ORAND = '3'; // 审核通过条件－－自定义－－“与”“或”混合

// 提醒策略
FlowType.REMAINDER_NOT = '0'; // 不提醒
FlowType.REMAINDER_AFTER = '1'; // 到达后提醒
FlowType.REMAINDER_BEFORE = '2'; // 提前提醒

FlowType.ACTIONCODES = ['1', '2', '3', '4', '5', '6', '7', '80', '81', '82', '9'];
FlowType.ACTIONNAMES = ['{*[Start]*}', '{*[Terminate]*}', '{*[Running]*}', '{*[Suspend]*}', '{*[Cancel]*}', '{*[Complete]*}', '{*[Terminate]*}', '{*[Running_Next]*}', '{*[Running_Back]*}', '{*[Loop_Self]*}', '{*[Suspend]*}'];


export default FlowType;
