class Api {
	
	constructor() {
		// this.contextPath = window.params.contextPath;
		this.contextPath = 'designer/api'
		this.http = (data)=>{
			return  new Promise((resolve, reject) => {
				var xhr = new XMLHttpRequest();
				xhr.onreadystatechange = function () {
					if (xhr.readyState === 4) {
						if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
							resolve(xhr.responseText);
						} else {
							reject(xhr.status);
						}
					} else {
						// HTTP请求还在继续...
					}
				};
				xhr.open(data.methods, data.url, true);
				xhr.setRequestHeader('content-type', 'application/json');
				delete data.methods;
				delete data.url;
				xhr.send(JSON.stringify(data));
			});
		}
	}
	/**
	 * *获取表单详情
	 * /designer/designtime/applications/modules/forms/{formid}
	 * @return 
	 */
	getFormDetail(formid) {
		// if(!formid)formid='__M7Y51AkZg4NY0ESEr3C'
		// let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/${window.params.application}/allmodules`}
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/modules/forms/${formid}`}//__M7Y51AkZg4NY0ESEr3C
		
		return this.http(data);
	}
	/**
	 * *获取树形结构所有模块列表**
	 * /designtime/applications/{applicationId}/allmodules
	 * @return 
	 */
	getModules() {
		// let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/${window.params.application}/allmodules`}
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/${params.application}/allmodules`}//sOZu9kthmxyP8qQfq0e
		
		return this.http(data);
	}
	/**
	 * *获取模块下的视图列表
	 * /designtime/applications/{applicationId}/modules/{moduleId}/views?searchword={searchword}
	 * @return 
	 */
	getModuleViews(moduleId) {
		
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/modules/${moduleId}/views?pageNo=1&linesPerPage=1000000`}//wexZCU0uXN8u396EUtX
		return this.http(data);
	}
	/**
	 * *获取视图列列表
	 * /designtime/applications/modules/views/{viewId}/columns
	 * @return 
	 */
	getViewsColumnsList(viewId) {
		
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/modules/views/${viewId}/columns`}
		return this.http(data);
	}
	/**
	 * *获取表单列表（可根据名字或者描述查询）
	 * /designtime/applications/modules/views/{viewId}/columns
	 * @return 
	 */
	getFormsList(moduleId,type=2,searchword="",pageNo=1,linesPerPage=100000 ) {
		
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/modules/${moduleId}/forms?searchword=${searchword}&type=${type}&pageNo=${pageNo}&linesPerPage=${linesPerPage}`}//wexZCU0uXN8u396EUtX
		return this.http(data);
	}
	/**
	 * *获取状态标签列表（可根据名字或者描述查询）**
	 * /designtime/applications/{applicationId}/statelabels?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}
	 * @return 
	 */
	getStateLabels(applicationId) {
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/${applicationId}/statelabels?searchword=&pageNo=1&linesPerPage=10000000`}//sOZu9kthmxyP8qQfq0e
		return this.http(data);
	}
	/**
	 * *获取表单摘要列表**
	 * /designtime/applications/{applicationId}/summarys?formId={formId}&pageNo={pageNo}&linesPerPage={linesPerPage}
	 * @return 
	 */
	getSummarys(applicationId) {
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/${applicationId}/summarys?formId=&pageNo=1&linesPerPage=1000000`}//sOZu9kthmxyP8qQfq0e
		return this.http(data);
	}
	/**
	 * 获取报表列表（可根据名字或者描述查询）
	 * /designtime/applications/modules/{moduleId}/reports?searchword={searchword}&pageNo={pageNo}&linesPerPage={linesPerPage}
	 * @return 
	 */
	getReportList(moduleId,isPrint) {
		let data={"methods":'get',"url":`/`+this.contextPath+`/designtime/applications/modules/${moduleId}/reports?searchword=&pageNo=1&linesPerPage=1000000&isPrint=${isPrint}`}//wexZCU0uXN8u396EUtX
		return this.http(data);
	}
	/**
	 * 获取视图列列表
	 *  /designtime/applications/modules/views/{viewId}/columns
	 * @return 
	 */
	getViewColumnList(viewId) {
		let data={"methods":'get',"url":`/${this.contextPath}/designtime/applications/modules/views/${viewId}/columns`}
		return this.http(data);
	}
}

export default Api;