import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class WeixingpsField extends AbstractField{
    constructor(container) {
        super();
        this.scope="weixingpsField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">微信GPS定位</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text"  class="base-field" readonly></div>`;
        
        this.propValues.name="微信GPS定位"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.discript="";
        this.propValues.editProp="editWeixingpsField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.refreshonchanged = false;//刷新：字段值改变时，触发表单刷新动作
        this.propValues.fieldtype="VALUE_TYPE_VARCHAR"
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','refreshonchanged','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
        }
    }
    
}
export default WeixingpsField;