import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class ViewdialogField extends AbstractField{
    constructor(container) {
        super();
        this.scope="viewdialogField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.propValues.caption="";//说明文字
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">视图选择框</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' >
        <button class="baseCon-btn">${this.propValues.caption}</button></div>`;
        
        this.propValues.name="视图选择框"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        this.propValues.editProp="editViewdialogField";
        

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        
        
        this.propValues.module="";//模块
        this.propValues.dialogview="";//视图
        this.propValues.viewsoptions=[];//存储视图的选项，不插入html中
        this.propValues.optionstextoptions=[{name:"选择",id:""}];//存储列的选项，不插入html中

        this.propValues.opentype="弹出层显示";//打开类型
        this.propValues.maximization="default";//显示大小
        this.propValues.divwidth="";
        this.propValues.divheight="";
        this.propValues.selectone=false;//拼接模式
        this.propValues.mutilselect=false;//多项选择
        this.propValues.allowviewdoc=false;//允许查看文档
        this.propValues.mapping=[];//映射
        this.propValues.okscript=""//确定条件脚本
        this.propValues.callbackscript=""//确定后执行脚本

    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','caption','module','dialogview','opentype','maximization','divwidth','refreshonchanged','refreshmode','refreshfields','calculateonrefresh','selectone','mutilselect','allowviewdoc','mobile','mapping'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript'],
            "ok":['okscript'],
            "callback":['callbackscript']

        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.module==''){
            alert('请选择模块')
            return false;
        }else if(this.propValues.dialogview==''){
            alert('请选择视图')
            return false;
        }
        return true;
    }
}
export default ViewdialogField;