import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class TabField extends AbstractField{
    constructor(container) {
        super();
        this.scope="tabField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div class="baseCon fieldId" style="overflow:auto" fieldid='${this.propValues.id}' style="height: 40px;border-bottom: 1px solid #dddddd;">
            <div class='normalTabDiv'><a name="name0"class="normalTabCheck"></a>
            </div>
            <div class="normalTabPanelDiv">
                <tab-content></tab-content>
            </div>
            
        </div>`;
        this.propValues.openAll=true;//是否全部展开
        this.propValues.name="选项卡"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.showmode = 0;//显示模式
        // this.propValues.refresh = '0';
        this.propValues.editProp="editTabField";
        this.propValues.selectedscript="";//页签选中脚本
        this.propValues.allowsamename=false;//是否允许同名
        this.propValues.relstr=[{
            name:"",
            type:"form",
            moduleId:"",
            formId:"",
            formsOptions:[{"id":"",name:'选择'}],
            recalculate:true,
            relate:false,
            hiddenScript:'',
            readOnlyScript:'',
            hiddenPrintScript:"",
        }];//选项卡内容


    }
    getPropsDesc() {
        return {
            "base":['myselfrows','showmode','openAll','allowsamename','relstr'],
            "selected":['selectedscript']
            

        }
    }
    //校验特殊属性
    checkSpeProp(){
        for(let i=0;i<this.propValues.relstr.length;i++){
            if(this.propValues.relstr[i].name==""){
                alert(`选项卡名称不能为空`);
                return false;
            }
            if(this.propValues.relstr[i].moduleId==""){
                alert(`选项卡模块必选`);
                return false;
            }
            if(this.propValues.relstr[i].formId==""){
                alert(`选项卡标签页/视图必选`);
                return false;
            }
        }

        return true;
    }
    
}
export default TabField;