import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class QrcodeField extends AbstractField{
    constructor(container) {
        super();
        this.scope="qrcodeField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">二维码控件</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text" class="base-field" readonly></div>`;
        
        this.propValues.name="二维码控件"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.discript="";
        this.propValues.editProp="editQrcodeField";
        this.propValues.calculateonrefresh = false; //重计算

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        this.propValues.mobile = true;//手机可用
        this.propValues.handletype = "text";//扫码处理方式
        this.propValues.size = 200;//大小
        this.propValues.refreshonchanged=false;//回调脚本执行完后刷新表单
        this.propValues.callbackscript="";//回调脚本
        this.propValues.valuescript="";//内容脚本
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','handletype','size','refreshonchanged','calculateonrefresh','mobile','discript'],
            "valueQ":['valuescript'],
            "callback":['callbackscript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
        }
    }
    
}
export default QrcodeField;