import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class OnlinetakephotoField extends AbstractField{
    constructor(container) {
        super();
        this.scope="onlinetakephotoField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">在线拍照</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text" class="base-field" readonly></div>`;
        
        this.propValues.name="在线拍照"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.imgh=100;//高
        this.propValues.imgw=100;//宽
        this.propValues.album=false;//允许从手机相册中选择照片
        this.propValues.calculateonrefresh = false; //重计算

        this.propValues.discript="";

        this.propValues.editProp="editOnlinetakephotoField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        this.propValues.fieldtype="VALUE_TYPE_TEXT";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','imgh','imgw','album','calculateonrefresh','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
        }
    }
    
}
export default OnlinetakephotoField;