import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class MapField extends AbstractField{
    constructor(container) {
        super();
        this.scope="mapField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">地图</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text" class="base-field" readonly></div>`;
        
        this.propValues.name="地图"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.discript="";
        this.propValues.editProp="editMapField";
        this.propValues.calculateonrefresh = false; //重计算

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.opentype="iframe";//显示方式
        this.propValues.maptype="iframe";//显示方式
        this.propValues.fieldtype="VALUE_TYPE_TEXT";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','maptype','opentype','calculateonrefresh','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
        }
    }
    
}
export default MapField;