import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class IncludeField extends AbstractField{
    constructor(container) {
        super();
        this.scope="includeField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">包含元素</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text" class="base-field" readonly></div>`;
        this.propValues.name="包含元素"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        // this.propValues.refresh = '0';
        this.propValues.editProp="editInputField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值

        this.propValues.includetype=0;//包含元素类型
        this.propValues.module="";//模块
        this.propValues.viewid="";//视图
        this.propValues.viewsoptions=[];//存储视图的选项，不插入html中

        this.propValues.relate=true;//是否为父子关系
        this.propValues.fixation=false;//固定高度
        this.propValues.fixationheight=0;//固定高度的高度
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','includetype','module','viewid','relate','fixation','fixationheight','refreshonchanged','refreshmode','refreshfields','calculateonrefresh'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            

        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.module==''){
            alert('请选择模块')
            return false;
        }
        return true;
    }
}
export default IncludeField;