import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class ImageuploadField extends AbstractField{
    constructor(container) {
        super();
        this.scope="imageuploadField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">图片上传</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}'>
        <p class="imageuploadField"><i class='imageuploadIcon'></i></p>
        </div>`;
        this.propValues.name="图片上传"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.imgh=100;//高
        this.propValues.imgw=100;//宽
        this.propValues.limitsize="";//限制单个上传文件大小
        this.propValues.limitnumber=10;//最大上传数量
        this.propValues.filepattern="00";//存放路径

        this.propValues.filecatalog="";//自定义存放路径

        this.propValues.readonlyshowvalonly = true; //只读时仅只显示值
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合

        this.propValues.discript="";

        this.propValues.editProp="editImageuploadField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        this.propValues.fieldtype="VALUE_TYPE_TEXT";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','imgh','imgw','limitsize','limitnumber','filepattern','filecatalog','readonlyshowvalonly','refreshonchanged','refreshmode','refreshfields','calculateonrefresh','mobile','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
        }
    }
    
}
export default ImageuploadField;