import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class FlowhistoryField extends AbstractField{
    constructor(container) {
        super();
        this.scope="flowhistoryField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">流程历史</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style=" height: 30px;">
        <input type="text" class="base-field"  readonly></div>`;
        this.propValues.name="流程历史"+window.formApp.formPanel.propValues.nameIndex;
        this.propValues.mobile=true;//手机可用
        this.propValues.discript="";
        this.propValues.editProp="editFlowhistoryField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值

        this.propValues.showmode=""//展现方式
        


    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','showmode','mobile','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            

        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.showmode==''){
            alert('请选择展现方式')
            return false;
        }
        return true;
    }
    
}
export default FlowhistoryField;