import Api from "../utility/Api";

class PropsPanel{
	constructor(propsContainer) {
        this.htmlDOM=null;
        this.propsContainer=propsContainer;
        // this.type=null;
        this.propsDesc=[]; //[{propName:'NAME',propType:'TEXT'...}]
        this.propValues=[];
        this.api=new Api();
        this.modulesOption=[];
        this.rendering=false;
    }
    /**
     * 重新渲染属性面板
     * @param {*} scope 
     */
    async render(scope=""){
        if(this.rendering==false){
            this.rendering=true;
            this.scope=scope;
            this.propsContainer.innerHTML="";
            let that=this;
            this.htmlDOM = document.createElement("DIV");
            let fieldOption=[]
            window.formApp.allElements.forEach((elm)=>{
                let data={"text":elm.propValues.name,"value":elm.propValues.fieldtype};
                fieldOption.push(data);
            })
            let allName = ["选择"];
            window.formApp.allElements.forEach(el=>{
                allName.push(el.propValues.name);
            })
            
            let fieldtypeOptions=[{label:"文本",value:"VALUE_TYPE_VARCHAR"},{label:"数字",value:"VALUE_TYPE_NUMBER"}],
            texttypeOptions=[{label:"普通",value:"text"},{label:"手机",value:"tel"},{label:"密码",value:"password"},{label:"只读",value:"readonly"},{label:"隐藏",value:"hidden"}],
            fieldkeyeventOptions=[{label:"Tab",value:"Tabkey"},{label:"Tab or Enter",value:"Enterkey"}],
            refreshmodeOptions=[{label:"全局刷新",value:"0"},{label:"局部刷新",value:"1"}],
            // myselfrowsOptions=[{label:"25%",value:"25%"},{label:"50%",value:"50%"},{label:"100%",value:"100%"}],
            editmodeOptions=[{label:"设计",value:"00"},{label:"IScript脚本",value:"01"}],
            numberOptions=[{label:"+",value:"+"},{label:"-",value:"-"},{label:"*",value:"*"},{label:"/",value:"/"},{label:"(",value:"("},{label:")",value:")"},{label:"Clear",value:"Clear"}],
            validatelibsOptions=[{"label": "手机号/电话校验","value": "core.dynaform.form.formfield.validate.checkPhone_system",
            },{"label": "非空校验","value": "core.dynaform.form.formfield.validate.checkEmpty_system",
            },{"label": "数据唯一校验","value": "core.dynaform.form.formfield.validate.checkFieldUnique_system",
            },{"label": "邮箱校验","value": "core.dynaform.form.formfield.validate.checkEmail_system",
            },{"label": "身份证校验","value": "core.dynaform.form.formfield.validate.checkIDcard_system",}],
            layoutOptions=[{label:"水平",value:"horizontal"},{label:"垂直",value:"vertical"}],
            optionseditmodeOptions=[{label:"设计",value:"00"},{label:"IScript脚本",value:"01"}],
            testOptions=[{label:"测试1",value:"1"},{label:"测试2",value:"2"}],
            datepatternOptions=[{label:"yyyy",value:"Y"},{label:"yyyy-MM",value:"YM"},{label:"yyyy-MM-dd",value:"YMD"},{label:"yyyy-MM-dd %h:%m",value:"YMD_HM"},{label:"yyyy-MM-dd %h:%m:%s",value:"YMD_HMS"},{label:"%h:%m:%s",value:"HMS"}],
            departmentlevelOptions=[{label:"所有部门",value:-1},{label:"一级部门",value:0},{label:"二级部门",value:1},{label:"三级部门",value:2},{label:"四级部门",value:3},{label:"五级部门",value:4}],
            defaultoptiontypeOptions=[{label:"第一个选项",value:16},{label:"用户所属部门",value:256}],
            selectmodeOptions=[{label:"多选",value:"multiSelect"},{label:"单选",value:"selectOne"}],
            datamodeOptions=[{label:"本地静态数据查询",value:"local"},{label:"服务器动态数据查询(选项脚本通过'_keyword'参数获取输入内容)",value:"remote"}],
            acttypeOptions=[{label:"选择",value:"0"},
            {label:"自定义",value:'13'},
            {label:"保存",value:'34'},
            {label:"保存并返回",value:'11'},
            {label:"保存并新建",value:'42'},
            {label:"保存草稿(不进行校验)",value:'19'},
            {label:"保存并复制",value:'21'},
            {label:"返回",value:'10'},
            {label:"关闭窗口",value:'8'},
            {label:"网页打印",value:'14'},
            {label:"自定义打印",value:'30'},
            {label:"PDF导出",value:'25'},
            {label:"文件下载",value:'26'},
            {label:"金格电子签章",value:'28'},
            {label:"通过邮件或手机短信分享",value:'37'},
            {label:"跳转",value:'43'},
            {label:"签章",value:'46'}],
            maximizationOptions=[{label:"默认",value:"default"},{label:"最大化",value:"true"},{label:"自定义",value:"false"}],
            showmodeOptions=[{label:"普通",value:0},{label:"折叠",value:1},{label:"列表",value:2}],
            relstrtypeOptions=[{label:"标签页",value:"form"},{label:"视图",value:"view"}],
            includetypeOptions=[{label:"视图",value:0}],
            filetypeOptions=[{label:"所有",value:"00"},{label:"自定义",value:"01"}],
            filepatternOptions=[{label:"系统默认",value:"00"},{label:"自定义",value:"01"}],
            watermarksupportmodeOptions=[{label:"预览时水印",value:"preview"},{label:"下载时水印",value:"download"},{label:"打印时水印",value:"print"}],
            showmodeFOptions=[{label:"文本列表",value:"text"},{label:"图表",value:"diagram"},{label:"文本列表与图表",value:"textAndDiagram"}],
            opentypeOptions=[{label:"弹出层显示",value:3},{label:"嵌入在页面显示",value:1}],
            opentypeMOptions=[{label:"默认",value:"iframe"},{label:"弹出窗口",value:"dialog"}],
            maptypeOptions=[{label:"百度地图",value:"baidumap"},{label:"ArcGIS",value:"arcgis"}],
            handletypeOptions=[{label:"显示内容",value:"text"},{label:"打开表单",value:"link"},{label:"执行回调脚本",value:"callback_event"}],
            emptyOptions=[{label:"选择",value:""}],
            actionselectionOptions=[{label:"完成动作执行前脚本，直接进行动作执行脚本",value:"0"},{label:"完成动作执行前脚本，可获取模板表单的参数，再进行动作执行脚本",value:"1"}],
            actiontypeOptions=[{label:"无",value:"0"},{label:"返回",value:"1"},{label:"关闭",value:"2"},{label:"跳转",value:"3"}],
            jumpmodeOptions=[{label:"跳转到动态表单",value:"0"},{label:"跳转到指定URL",value:"1"}],
            jumpactopentypeOptions=[{label:"当前页面",value:"0"},{label:"弹出层",value:"1"},{label:"页签",value:"2"},{label:"新窗口",value:"3"}],
            signaturetypeOptions=[{label:"HTML签章",value:"HTML"},{label:"PDF签章",value:"PDF"}],
            signatureactionOption=[{label:"盖章",value:"signature"},{label:"签字",value:"sign"},{label:"意见",value:"opinion"},{label:"时间",value:"date"}]

            if(scope=="radioField" || scope=="checkboxField"){
                texttypeOptions=[{label:"普通",value:"text"},{label:"只读",value:"readonly"}];
            }
            if(scope =="selectField" || scope=="dataField" || scope == "deptField" || scope =="userField" || scope =="treedepartmentField" || scope =="suggestField"){
                texttypeOptions=[{label:"普通",value:"text"},{label:"只读",value:"readonly"},{label:"隐藏",value:"hidden"}];
            }
            let modulesOption;
            try{
                modulesOption = await this.api.getModules();
                if(modulesOption.indexOf("data")!=-1)
                {modulesOption=JSON.parse(modulesOption).data;this.modulesOption=modulesOption;}
                else {modulesOption=[{id:"",value:'无'}];this.modulesOption=modulesOption;}
            } catch(e){
                modulesOption=[{id:"",value:'无'}];
            }
            let statetoshowOptions,relatedformidOptions,transpondOptions,actionprintOptions;
            
            for(let propPart in this.propsDesc){
                let div = document.createElement("DIV");
                div.setAttribute("class","part");
                let baseCon = document.createElement("DIV");
                baseCon.setAttribute("class","partCon");
                switch (propPart) {
                    case "base":
                        let baseTitle = document.createElement("DIV");
                        let basetxt = document.createTextNode("基本");
                        baseTitle.appendChild(basetxt);
                        baseTitle.setAttribute("class","partHeader");
                        
                        div.appendChild(baseTitle);

                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'myselfrows':
                                    chinaName = "自身占父级的百分比";
                                    html+=`<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' max='100' />单位：%`
                                    // <select name='${propName}'>
                                    // myselfrowsOptions.forEach(el=>{
                                    //     if(el.value==that.propValues[propName]){
                                    //         html+=`<option value='${el.value}' selected>${el.label}</option>`
                                    //     }else{
                                    //         html+=`<option value='${el.value}'>${el.label}</option>`    
                                    //     }
                                    // })
                                    // html+=`</select>`
                                    break;
                                case 'containerHeight':
                                    chinaName = "容器高度";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'borderwidth':
                                    chinaName = "边框宽度";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'containerwidth':
                                    chinaName = "表单宽度";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'name':
                                    chinaName = "名称";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='text' value='${that.propValues[propName]}' />`;
                                    break;
                                case 'inputwidth':
                                    chinaName = "单行文本框宽度";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'textareaheight':
                                    chinaName = "高度";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'layout':
                                    chinaName = "布局";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    layoutOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'discript':
                                    chinaName = "描述";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea>`
                                    if(scope=="selectaboutField" || scope=="mapField"){
                                        html+=`<p style="color:green;">*手机微信端不支持控件</p>`
                                    }
                                    break;
                                case 'fieldtype':
                                    chinaName = "类型";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    fieldtypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'numberPattern':
                                    chinaName = "格式";
                                    if(that.propValues.fieldtype!="VALUE_TYPE_NUMBER"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    html =`<p >例如:##.##</p>`
                                    html += `<label>${chinaName}</label><input name='${propName}' value='${that.propValues[propName]}'/>`
                                    break;
                                case 'defaultValueIsNull':
                                    chinaName = "不填时，默认值为空";
                                    if(that.propValues.fieldtype!="VALUE_TYPE_NUMBER"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'texttype':
                                    chinaName = "显示";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    texttypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break; 
                                case 'fieldkeyevent':
                                    chinaName = "焦点切换键";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    fieldkeyeventOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;   
                                case 'readonlyshowvalonly':
                                    chinaName = "只读时仅显示值";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;   
                                case 'refreshonchanged':
                                    if(scope=="qrcodeField"){
                                        if(that.propValues.handletype!="callback_event"){
                                            span.setAttribute("class",'d-none');
                                        }
                                        chinaName = "回调脚本执行完后刷新表单";
                                        html +=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    }else{
                                        chinaName = "刷新";
                                        html +=`<label class="partConCheckboxLabel">${chinaName}:字段值改变时,触发表单刷新动作</label>`
                                    }
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    
                                    break;  
                                case 'calculateonrefresh':
                                    chinaName = "重计算";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}:表单刷新时,重新计算本字段内容</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break; 
                                case 'mobile':
                                    chinaName = "手机可用";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;  
                                case 'showfieldtitle':
                                    chinaName = "是否显示标题栏";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;  
                                case 'refreshmode':
                                    chinaName = "刷新方式";
                                    if(that.propValues.refreshonchanged==false){
                                        span.setAttribute("class","d-none");
                                    }
                                    html+=`<label>${chinaName}</label>&nbsp;`
                                    refreshmodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label class="partConRadioLabel">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label class="partConRadioLabel">${el.label}</label>`
                                        }
                                    })
                                    break; 
                                case 'refreshfields':
                                    chinaName = "局部刷新字段";
                                    if(that.propValues.refreshonchanged==false){
                                        span.setAttribute("class","d-none");
                                    }else if(that.propValues.refreshmode=='0'){
                                        span.setAttribute("class","d-none");
                                    }
                                    
                                    html+=`<label>${chinaName}</label>
                                        <button id='addRefreshField'>添加</button>`
                                        html += `<div>`
                                    that.propValues[propName].forEach((el)=>{
                                        html += `<div>`

                                        html+=`<label >字段名称</label>
                                        <select id='refreshfields' name="refreshfields" style="width:100px;">`;
                                        if(allName.length>0){
                                            for(let k=0;k<allName.length;k++){
                                                if(el==allName[k]){
                                                    html+=`<option value=${allName[k]} selected>${allName[k]}</option>`
                                                }else{
                                                    html+=`<option value=${allName[k]}>${allName[k]}</option>`
                                                }
                                            }
                                        }
                                        html+=`</select>
                                        <button  class="delRefreshField">删除</button>`
                                        html += `</div>`

                                    })
                                    html+=`</div>`
                                    break; 
                                
                                case 'multiselect':
                                    chinaName = "多选";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'datepattern':
                                    chinaName = "格式";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    datepatternOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'limit':
                                    if(scope=='treedepartmentField'){
                                        chinaName = "最多可选";
                                        html += `<label>${chinaName}</label><input name='${propName}' type='text' value='${this.propValues[propName]}'/>`
                                        html += '项'
                                    }else{
                                        chinaName = "限制";
                                        html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                        if(that.propValues[propName]==true){
                                            html+=`<input name='${propName}' type='checkbox' checked/>`
                                        }else{
                                            html+=`<input name='${propName}' type='checkbox'  />`
                                        }
                                    }
                                    
                                    break;
                                case 'prev_name':
                                    if(that.propValues.limit==false){
                                        span.setAttribute("class","d-none");
                                    }
                                    chinaName = "开始日期字段名";
                                    html+=`<label>${chinaName}</label><select name='${propName}' style="width:150px;">`;
                                    let allDataInfo = window.formApp.formPanel.getAllDataInfo();
                                    allDataInfo=[{propValues:{id:'',name:"选择"}}].concat(allDataInfo);
                                    allDataInfo.forEach(el=>{
                                        if(el.propValues.name==that.propValues[propName]){
                                            html+=`<option value='${el.propValues.name}' selected>${el.propValues.name}</option>`
                                        }else{
                                            html+=`<option value='${el.propValues.name}'>${el.propValues.name}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'departmentlevel':
                                    chinaName = "可选";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    departmentlevelOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'relatedfield':
                                    chinaName = "上级部门联动字段";
                                    //数据要调接口，还有相应的事件处理
                                    html+=`<label>${chinaName}</label><select name='${propName}' style="width:150px;">`;
                                    let allDeptInfo = window.formApp.formPanel.getAllDeptInfo();
                                    allDeptInfo=[{propValues:{id:'',name:"选择"}}].concat(allDeptInfo);
                                    allDeptInfo.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.propValues.name}' selected>${el.propValues.name}</option>`
                                        }else{
                                            html+=`<option value='${el.propValues.name}'>${el.propValues.name}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'limitbyuser':
                                    chinaName = "仅显示当前用户所属部门及下属部门";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'defaultoptiontype':
                                    chinaName = "默认值";
                                    //数据要调接口，还有相应的事件处理
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    defaultoptiontypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'allowempty':
                                    chinaName = "选项中包含空值";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'selectmode':
                                    chinaName = "选择模式";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    selectmodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'datamode':
                                    chinaName = "搜索方式";
                                    html+=`<label class="partConRadioLabel">${chinaName}</label>&nbsp;`
                                    datamodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label>${el.label}</label><br>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label>${el.label}</label><br>`
                                        }
                                    })
                                    break;
                                case 'acttype':
                                    chinaName = "动作";
                                    if(that.propValues[propName]=='0')
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    else html+=`<label>${chinaName}</label><select disabled="disabled" name='${propName}'>`
                                        
                                    acttypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'withold':
                                    if(that.propValues.acttype!='42'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "带旧数据";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'signaturetype':
                                    if(that.propValues.acttype!='28'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "签章类型";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    signaturetypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'datafield':
                                    if(that.propValues.acttype!='28'){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.signaturetype!='HTML')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "签章数据关联字段";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='text' value='${that.propValues[propName]}' />`;
                                    break;
                                case 'signatureaction':
                                    if(that.propValues.acttype!='28'){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.signaturetype!='PDF')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "签署动作";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    signatureactionOption.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'statetoshow':
                                    chinaName = "状态:动作标签";
                                    try{
                                        statetoshowOptions = await this.api.getStateLabels(params.application);
                                        if(statetoshowOptions.indexOf("data")!=-1)
                                        {statetoshowOptions=JSON.parse(statetoshowOptions).data.data;this.statetoshowOptions=statetoshowOptions;}
                                        else {statetoshowOptions=[{"":"无"}];this.statetoshowOptions=statetoshowOptions;}
                                    } catch(e){
                                        statetoshowOptions=[{"":"无"}]
                                    } 
                                    html+=`<label>${chinaName}</label><div style="display:inline-block;vertical-align:top">`
                                    statetoshowOptions.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<label style="width:auto">${el.name}</label><input name='${propName}' value='${el.id}' type='checkbox' checked/><br>`
                                        }else{
                                            html+=`<label style="width:auto">${el.name}</label><input name='${propName}' value='${el.id}' type='checkbox'/><br>`
                                        }
                                        
                                    })
                                    html+=`</div>`
                                    break;
                                case 'transpond':
                                    if(that.propValues.acttype!="37"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "摘要模板";
                                    try{
                                        transpondOptions = await this.api.getSummarys(params.application);
                                        if(transpondOptions.indexOf("data")!=-1)
                                        {transpondOptions=JSON.parse(transpondOptions).data.data;
                                            transpondOptions.unshift({name:"选择",id:''});
                                            this.transpondOptions=transpondOptions;}
                                        else {transpondOptions=[{"":"选择"}];this.transpondOptions=transpondOptions;}
                                    } catch(e){
                                        transpondOptions=[{"":"选择"}]
                                    } 
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    transpondOptions.forEach(el=>{
                                        if(el.type=="01"){
                                            if(el.id==that.propValues[propName]){
                                                html+=`<option value='${el.id}' selected>${el.name}</option>`
                                            }else{
                                                html+=`<option value='${el.id}'>${el.name}</option>`    
                                            }
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'filenamescript':
                                    if(that.propValues.acttype!="26"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "文件路径脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'beforeactionscript':
                                    if(that.propValues.acttype=="43"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作执行前脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'actionselection':
                                    if(that.propValues.acttype!="13"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作处理方式";
                                    html+=`<label>${chinaName}</label><div style="width:70%;display:inline-block;">`
                                    actionselectionOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style="width:80%" >${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label style="width:80%" >${el.label}</label>`
                                        }
                                    })
                                    html+=`</div>`
                                    break;
                                case 'jumpmode':
                                    if(that.propValues.acttype!="43"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "类型";
                                    html+=`<label>${chinaName}</label><div style="width:70%;display:inline-block;">`
                                    jumpmodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style="width:80%" >${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label style="width:80%" >${el.label}</label>`
                                        }
                                    })
                                    html+=`</div>`
                                    break;
                                case 'targetlist':
                                    if(that.propValues.acttype!='43' ){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.jumpmode!='0')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "跳转设置";
                                    html+=`<label name="${propName}">${chinaName}</label><div><label>模块</label><select name='moduleselect'>`;
                                    modulesOption.forEach(el=>{
                                        if(el.id==that.propValues[propName].moduleselect){
                                            html+=`<option value='${el.id}' selected>${el.value}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.value}</option>`    
                                        }
                                    })
                                    html+=`</select>`;
                                    html+=`<br><label>目标表单</label><select name='formselect'>`
                                    let formOptions = null;
                                    if(that.propValues[propName].moduleselect!=""){
                                        formOptions = await this.api.getFormsList(that.propValues[propName].moduleselect,1);
                                        if(formOptions.indexOf("data")!=-1){
                                            formOptions=JSON.parse(formOptions).data;
                                            formOptions.unshift({name:"选择",id:''});
                                        }else {
                                            formOptions=[{"id":"",'name':"选择"}];
                                        }
                                    
                                    }else{
                                        formOptions=[{"id":"",'name':"选择"}];
                                    }
                                    
                                    formOptions.forEach(el=>{
                                        if(el.id==that.propValues[propName].formselect){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select><div>`
                                    break;
                                case 'jumpactopentype':
                                    if(that.propValues.acttype!='43'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "打开方式";
                                    html+=`<label>${chinaName}</label><div style='display:inline-block;vertical-align:top;width:70%;'>`
                                    jumpactopentypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style='width:auto' class="partConRadioLabel">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label style='width:auto' class="partConRadioLabel">${el.label}</label>`
                                        }
                                    })
                                    html+=`</div>`
                                    break;
                                case 'relatedformid':
                                    if(that.propValues.acttype!='13' ){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.actionselection!='1')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作关联表单";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    try{
                                        relatedformidOptions = await this.api.getFormsList(params.moduleId,'1048576');
                                            
                                        if(relatedformidOptions.indexOf("data")!=-1)
                                        {relatedformidOptions=JSON.parse(relatedformidOptions).data;
                                            relatedformidOptions.unshift({name:"选择",id:''});
                                            this.relatedformidOptions=relatedformidOptions;}
                                        else {relatedformidOptions=[{"id":"",'name':"选择"}];this.relatedformidOptions=relatedformidOptions;}
                                    } catch(e){
                                        relatedformidOptions=[{"":"选择"}]
                                    } 
                                    relatedformidOptions.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'actionprint':
                                    if(that.propValues.acttype!='30'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "选择打印模板";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    try{
                                        actionprintOptions = await this.api.getReportList(params.moduleId,1);
                                        if(actionprintOptions.indexOf("datas")!=-1)
                                        {actionprintOptions=JSON.parse(actionprintOptions).data.datas;
                                            actionprintOptions.unshift({name:"选择",id:''});
                                        }
                                        else {actionprintOptions=[{"":"选择"}];}
                                    } catch(e){
                                        actionprintOptions=[{"":"选择"}]
                                    } 
                                    actionprintOptions.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        } 
                                    })
                                    html+=`</select>`
                                    break;
                                case 'dispatcherurl':
                                    if(that.propValues.acttype!='43' ){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.jumpmode!='1')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "地址脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'dispatcherparams':
                                        
                                    if(that.propValues.acttype!='43'){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.jumpmode!='1')
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "参数";
                                    html+=`<label name=${propName}>${chinaName}</label>`;
                                    html+=`<div><span style="width:30%">参数名称</span><span style="width:30%">参数值</span><button id="addDispatcherparams">添加</button></div>`
                                    html+=`<div>`
                                    that.propValues[propName].forEach((el,index)=>{
                                        html+=`<div style="margin-top:5px;"><input style="width:30%" type="text"  name=paramKey${index} value=${el.paramValue}/>
                                        <input style="width:30%"  type="text" name=paramValue${index}  value=${el.paramValue}/>
                                        <button class="delDispatcherparams">删除</button><div>`

                                    })
                                    html+=`</div>`

                                    break;
                                case 'actionscript':
                                    if(that.propValues.acttype!='13'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作执行脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'afteractionscript':
                                    if(that.propValues.acttype=="43"){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作执行后脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;
                                case 'actiontype':
                                    if(that.propValues.acttype!='13'){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "动作完成后操作类型";
                                    html+=`<label>${chinaName}</label>`
                                    actiontypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label class="partConRadioLabel">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label class="partConRadioLabel">${el.label}</label>`
                                        }
                                    })
                                    html+=`</div>`
                                    break;
                                case 'actiondispatcherurlscript':
                                    if(that.propValues.acttype!='13'){
                                        span.setAttribute("class",'d-none');
                                    }else{
                                        if(that.propValues.actiontype!="3")
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "地址脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;
                                case 'caption':
                                    chinaName = "说明文字";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='text' value='${that.propValues[propName]}' />`;
                                    break;
                                case 'module':
                                    chinaName = "模块";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    // for(let key in modulesOption){
                                    //     if(key==that.propValues[propName]){
                                    //         html+=`<option value='${key}' selected>${modulesOption[key]}</option>`
                                    //     }else{
                                    //         html+=`<option value='${key}'>${modulesOption[key]}</option>`                                           
                                    //     }
                                    // }
                                    modulesOption.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.id}' selected>${el.value}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.value}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    break;
                                case 'dialogview':
                                    chinaName = "视图";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    that.propValues.viewsoptions.forEach(el=>{
                                        if(el.id==that.propValues[propName])
                                        html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        else html+=`<option value='${el.id}'>${el.name}</option>`
                                    })
                                    break;
                                case 'opentype':
                                    if(scope=="genericwordField"){
                                        chinaName = "显示方式";
                                        html+=`<label>${chinaName}</label><select name='${propName}'>`
                                        opentypeOptions.forEach(el=>{
                                            if(el.value==that.propValues[propName]){
                                                html+=`<option value='${el.value}' selected>${el.label}</option>`
                                            }else{
                                                html+=`<option value='${el.value}'>${el.label}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                    }else if(scope=="mapField"){
                                        chinaName = "打开类型";
                                        html+=`<label>${chinaName}</label><select name='${propName}'>`
                                        opentypeMOptions.forEach(el=>{
                                            if(el.value==that.propValues[propName]){
                                                html+=`<option value='${el.value}' selected>${el.label}</option>`
                                            }else{
                                                html+=`<option value='${el.value}'>${el.label}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                    }else{
                                        chinaName = "打开类型";
                                        html = `<label>${chinaName}</label><p style="display:inline-block">弹出层显示</p>`;
                                    }
                                    
                                    break;
                                case 'maximization':
                                    chinaName = "显示大小";
                                    html+=`<label>${chinaName}</label>`
                                    maximizationOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><b>${el.label}</b>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><b>${el.label}</b>`
                                        }
                                    })
                                    break; 
                                case 'divwidth':
                                    if(that.propValues.maximization!="false"){
                                        span.setAttribute("class","d-none")
                                    }
                                    html+=`<label>高</label><input name='divheight' type='text' style="width:25%" value='${that.propValues.divheight}' />(500px或50%)<br>`
                                    html+=`<label>宽</label><input name='divwidth' type='text' style="width:25%;margin-top: 3px;" value='${that.propValues.divwidth}' />(300px或30%)`

                                    break;
                                case 'selectone':
                                    chinaName = "拼接模式";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        if(that.propValues.mutilselect)
                                        html+=`<input name='${propName}' type='checkbox' disabled />`
                                        else
                                        html+=`<input name='${propName}' type='checkbox' />`

                                    }
                                    break;
                                case 'mutilselect':
                                    chinaName = "多项选择";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        if(that.propValues.selectone)
                                        html+=`<input name='${propName}' type='checkbox' disabled />`
                                        else
                                        html+=`<input name='${propName}' type='checkbox' />`
                                    }
                                    break;
                                case 'allowviewdoc':
                                    chinaName = "允许查看文档";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'mapping':
                                    chinaName = "映射";
                                    html+=`<label>${chinaName}</label>`
                                    html +=`<div>`;
                                    html +=`<button id="addmapping">添加</button>`
                                    html +=`<div style="margin:5px 0">`;
                                    html +=`&nbsp;<b class="paddingR30P">列名称</b>`;
                                    html +=`<b class="paddingR23P">字段</b>`;
                                    html +=`</div>`;

                                    if(that.propValues[propName].length>0){
                                        that.propValues[propName].forEach((el)=>{
                                            for(let key in el){
                                                html +=`<div style="display:flex;">
                                                <i style="padding:0 3px;font-style:normal;">从</i>
                                                <select  name="colname" class="form-control"  style="width:80px">`
                                                    
                                                that.propValues.optionstextoptions.forEach((val)=>{
                                                    if(key == val.id)
                                                    html+=`<option selected value=${val.id}>${val.name}</option>`
                                                    else
                                                    html+=`<option value=${val.id}>${val.name}</option>`
                                                })
                                                html+=`</select>
                                                <i style="padding:0 3px;font-style:normal;">至</i>
                                                <select name="fldname" class="form-control"  style="width:80px">`
                                                let noMyAllName=[...allName];
                                                let index=null;
                                                allName.forEach((elm,ind)=>{
                                                    if(that.propValues.name==elm)index=ind;
                                                })
                                                noMyAllName.splice(index,1);
                                                noMyAllName.forEach((val)=>{
                                                    if(el[key]==val)
                                                    html+=`<option selected value=${val}>${val}</option>`
                                                    else
                                                    html+=`<option value=${val}>${val}</option>`
                                                })
                                                html+=`</select>
                                                    <button class="delmapping padding0" style="margin:0 3px;">删除</button>
                                                </div>`; 
                                            }
                                            
                                        })   
                                    }else{
                                        html +=`<div style="display:flex;">
                                            <i style="padding:0 3px;font-style:normal;">从</i>
                                            <select  name="colname" class="form-control"  style="width:80px">`
                                                
                                            that.propValues.optionstextoptions.forEach((val)=>{
                                                html+=`<option value=${val.id}>${val.name}</option>`
                                            })
                                            html+=`</select>
                                            <i style="padding:0 3px;font-style:normal;">至</i>
                                            <select name="fldname" class="form-control"  style="width:80px">`
                                            let noMyAllName=[...allName];
                                            let index=null;
                                            allName.forEach((elm,ind)=>{
                                                if(that.propValues.name==elm)index=ind;
                                            })
                                            noMyAllName.splice(index,1);
                                            noMyAllName.forEach((val)=>{
                                                html+=`<option value=${val}>${val}</option>`
                                            })
                                            html+=`</select>
                                                <button class="delmapping padding0" style="margin-left:3px;">删除</button>
                                            </div>`; 
                                    }
                                    
                                    
                                    
                                    html+=`</div>`;
                                    break;
                                case 'showmode':
                                    if(scope=="flowhistoryField"){
                                        chinaName = "展现方式";
                                        html+=`<label>${chinaName}</label><div style='display:inline-block;vertical-align:top;width: 70%;'>`
                                        showmodeFOptions.forEach(el=>{
                                            if(el.value==that.propValues[propName]){
                                                html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style="width:auto">${el.label}</label><br>`
                                            }else{
                                                html+=`<input name='${propName}' type='radio' value=${el.value} /><label style="width:auto">${el.label}</label><br>`
                                            }
                                        })
                                        html+='</div>'
                                    }else{
                                        chinaName = "显示模式";
                                        html+=`<label>${chinaName}</label><select name='${propName}'>`
                                        showmodeOptions.forEach(el=>{
                                            if(el.value==that.propValues[propName]){
                                                html+=`<option value='${el.value}' selected>${el.label}</option>`
                                            }else{
                                                html+=`<option value='${el.value}'>${el.label}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                    }
                                    
                                    break;
                                case 'openAll':
                                    if(that.propValues.showmode!=1){
                                        span.setAttribute("class",'d-none');
                                    }
                                    chinaName = "是否全部展开";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'allowsamename':
                                    chinaName = "是否允许同名";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'relstr':
                                    html+=`<button id="addRelstr" style="margin-left:5px;">添加</button>`

                                    html+=`<div class="d-flex">`
                                    html +=`<div style="padding-left:5px;width:100px; display: inline-block;vertical-align: top;border-right:1px solid #ccc;">`
                                    html+=`<p class="marginB5" style="line-height:30px">名称</p><p class="marginB5" style="line-height:24px">类型</p><p class="marginB5" style="line-height:24px">模块</p><p class="marginB5" style="line-height:24px">标签页/视图</p><p class="marginB5" style="line-height:19px">重计算</p><p style="height:19px">是否为父子关系</p><p style="height:76px">隐藏条件</p><p style="height:76px">只读条件</p><p class="marginB5" style="height:54px">打印时隐藏条件</p></div>`
                                    
                                    html+=`<div style="width: calc(100% - 100px);display: flex;overflow-x:scroll;">`
                                    that.propValues[propName].forEach((el,index)=>{
                                        html+=`<div style="width:100px;display: inline-block;">`
                                        html+=`<input class="marginB5" name='name${index}' type='text'  style="width:100px;" value='${el.name}' />`
                                        html+=`<select class="marginB5" name='type${index}'  style="width:100px;" >`
                                        relstrtypeOptions.forEach(elm=>{
                                            if(elm.value==el.type){
                                                html+=`<option value='${elm.value}' selected>${elm.label}</option>`
                                            }else{
                                                html+=`<option value='${elm.value}'>${elm.label}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                        html+=`<select class="marginB5" name='moduleId${index}'  style="width:100px;">`
                                        
                                        modulesOption.forEach(elm=>{
                                            if(elm.id==el.moduleId){
                                                html+=`<option value='${elm.id}' selected>${elm.value}</option>`
                                            }else{
                                                html+=`<option value='${elm.id}'>${elm.value}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                        html+=`<select class="marginB5" name='formId${index}'  style="width:100px;">`;
                                        el.formsOptions.forEach(elm=>{
                                            if(elm.id==el.formId){
                                                html+=`<option value='${elm.id}' selected>${elm.name}</option>`
                                            }else{
                                                html+=`<option value='${elm.id}'>${elm.name}</option>`    
                                            }
                                        })
                                        html+=`</select>`
                                        if(el.recalculate==true){
                                            html+=`<input class="marginB5" name='recalculate${index}' type='checkbox' checked  style="width:100px;"/>`
                                        }else{
                                            html+=`<input class="marginB5" name='recalculate${index}' type='checkbox'   style="width:100px;"/>`
                                        }
                                        if(el.relate==true){
                                            html+=`<input class="marginB5" name='relate${index}' type='checkbox' checked  style="width:100px;"/>`
                                        }else{
                                            html+=`<input class="marginB5" name='relate${index}' type='checkbox'  style="width:100px;" />`
                                        }
                                        html += `<textarea class="marginB5" name='hiddenScript${index}' style="width:100px;">${el.hiddenScript}</textarea><img name='openScript' src='./images/editor.png'/>`
                                        html += `<textarea class="marginB5" name='readOnlyScript${index}' style="width:100px;">${el.readOnlyScript}</textarea><img name='openScript' src='./images/editor.png'/>`
                                        html += `<textarea class="marginB5" name='hiddenPrintScript${index}' style="width:100px;">${el.hiddenPrintScript}</textarea><img name='openScript' src='./images/editor.png'/><br>`
                                        html += `<button  class="delRelstr">删除</button>`
                                        html += `</div>`
                                    })
                                    html += `</div>`

                                    html+=`</div>`

                                    break;
                                case 'valuescript':
                                    chinaName = "计算脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'includetype':
                                    chinaName = "包含元素类型";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    includetypeOptions.forEach(el=>{
                                        html+=`<option value='${el.value}' selected>${el.label}</option>`
                                    })
                                    html+=`</select>`
                                    break;
                                case 'viewid':
                                    chinaName = "视图";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    that.propValues.viewsoptions.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    
                                    break;
                                case 'relate':
                                    chinaName = "是否为父子关系";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'fixation':
                                    chinaName = "固定高度";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'fixationheight':
                                    if(!that.propValues.fixation){
                                        span.setAttribute("class",'d-none')
                                    }
                                    html = `<input name='${propName}' type='text' value=${that.propValues[propName]} />px`;
                                    
                                    break;
                                case 'limitsize':
                                    chinaName = "限制单个上传文件大小";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />KB<label style="color:red">默认 10M</label>`;
                                    break;
                                case 'filetype':
                                    chinaName = "上传文件类型";
                                    html+=`<label>${chinaName}</label><div style="display:inline-block;">`
                                    filetypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style="width:auto">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label style="width:auto">${el.label}</label>`
                                        }
                                    })
                                    html+="</div>"
                                    break;
                                case 'customizetype':
                                    if(that.propValues.filetype=="00"){
                                        span.setAttribute("class",'d-none')
                                    }
                                    html+='<div style="margin-left:30%">'
                                    html+=`<p style="color:red">格式：doc;xls;ppt</p>`;
                                    html+=`<textarea name='${propName}'>${that.propValues[propName]}</textarea>`
                                    html+='</div>'
                                    break;
                                case 'limitnumber':
                                    chinaName = "最大上传数量";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />`;
                                    break;
                                case 'filepattern':
                                    if(scope=="imageuploadField"){
                                        chinaName = "图像存放路径";
                                    }else{
                                        chinaName = "存放路径";
                                    }
                                    html+=`<label>${chinaName}</label><div style='display:inline-block'>`
                                    filepatternOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value='${el.value}' checked/><label style="width:auto">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value='${el.value}' /><label style="width:auto">${el.label}</label>`
                                        }
                                    })
                                    html+='</div>'
                                    break;
                                case 'filecatalog':
                                    if(that.propValues.filepattern=="00"){
                                        span.setAttribute("class",'d-none')
                                    }
                                    chinaName="服务器目录"
                                    html+=`<label>${chinaName}</label>`;
                                    html+=`<input name='${propName}' value="${that.propValues[propName]}" type="text"/>`
                                    break;
                                case 'previewedit':
                                    chinaName="office文档预览时可编辑";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'openwatermark':
                                    chinaName="是否添加水印";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'watermarksupportmode':
                                    chinaName = "添加水印模式:";
                                    if(!that.propValues.openwatermark){
                                        span.setAttribute("class",'d-none')
                                    }
                                    html+=`<label>${chinaName}</label><div style="display:inline-block;width:70%;vertical-align:top">`
                                    let arr =null;
                                    if(that.propValues[propName].indexOf(",")){
                                        arr = that.propValues[propName].split(",")
                                    }else{
                                        arr=that.propValues[propName]
                                    }
                                    watermarksupportmodeOptions.forEach(el=>{
                                        
                                        if(typeof arr == "object"){
                                            let have=false;
                                            for(let i=0;i<arr.length;i++){
                                                if(arr[i]==el.value){
                                                    have=true;
                                                    break;
                                                }else{
                                                    have=false;                                        
                                                }
                                            }
                                            if(have){
                                                html+=`<label style="width:auto">${el.label}</label><input name='${propName}' type='checkbox' checked  value="${el.value}"/>`

                                            }else{
                                                html+=`<label style="width:auto">${el.label}</label><input name='${propName}' type='checkbox' value="${el.value}"/>`

                                            }
                                        }else{
                                            if(arr==el.value){
                                                html+=`<label>${el.label}</label><input name='${propName}' type='checkbox' checked  value="${el.value}"/>`
                                            }else{
                                                html+=`<label>${el.label}</label><input name='${propName}' type='checkbox' value="${el.value}"/>`
                                            }
                                        }

                                    })
                                    html+='</div>'
                                    break;
                                case 'watermarkscript':
                                    if(!that.propValues.openwatermark){
                                        span.setAttribute("class",'d-none')
                                    }
                                    chinaName = "添加水印脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;
                                case 'supportsorting':
                                    chinaName="文件排序功能";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'showtrackrevisions':
                                    chinaName="托盘编辑显示痕迹";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'showusernameanddate':
                                    chinaName="显示用户名和日期";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break;
                                case 'areawidth':
                                    chinaName = "大小：";
                                    html = `<label>${chinaName}</label>宽<input name='${propName}' type='text' style='width:60px;height:20px' value="${that.propValues[propName]}" /><label style="color:green">(单位：PX或%)</label>`;
                                    break;
                                case 'areaheight':
                                    html = `<label style='padding-left:30%'></label>高<input name='${propName}' style='width:60px;height:20px' type='text' value="${that.propValues[propName]}" /><label style="color:green">(单位：PX)</label>`;
                                    break;
                                case 'maptype':
                                    
                                    chinaName = "地图类型";
                                    html+=`<label>${chinaName}</label><select name='${propName}'>`
                                    maptypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<option value='${el.value}' selected>${el.label}</option>`
                                        }else{
                                            html+=`<option value='${el.value}'>${el.label}</option>`    
                                        }
                                    })
                                    html+=`</select>`
                                    html+=`<p style="color:red;">(ArcGIS仅支持PC端使用，暂不支持手机端)</p>`
                                    break;
                                case 'handletype':
                                    chinaName = "扫码处理方式";
                                    html+=`<label>${chinaName}</label><div style="display:inline-block;vertical-align:top;width:70%;">`
                                    handletypeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label style="width:auto">${el.label}</label><br>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label  style="width:auto">${el.label}</label><br>`
                                        }
                                    })
                                    html+='</div>'
                                    break;
                                case 'size':
                                    chinaName = "大小";
                                    html += `<label>${chinaName}</label>&nbsp;`
                                    html += `<input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />px`;
                                    break;
                                case 'imgh':
                                    chinaName = "显示大小";
                                    html += `<label>${chinaName}</label>`
                                    html += `高<input name='${propName}' type='number' value='${that.propValues[propName]}' min='0' />px`;
                                    html += `宽<input name='imgw' type='number' value='${that.propValues.imgw}' min='0' />px`;

                                    break;
                                case 'album':
                                    chinaName="允许从手机相册中选择照片";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    html+=`<label style="color:red">(此功能仅在微信端生效)</label>`
                                    break;
                                default:
                                    break;
                            }
                            html+="<br>"
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "question":
                        let questionTitle = document.createElement("DIV");
                        let questiontxt = document.createTextNode("问卷脚本");
                        questionTitle.appendChild(questiontxt);
                        questionTitle.setAttribute("class","partHeader");
                        div.appendChild(questionTitle);
                        questionTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'questionscript':
                                    chinaName = "问卷脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*cn.myapps.runtime.dynaform.form.webeditor.label.questionscript.tip（true/false）*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "valueQ":

                        let valueQTitle = document.createElement("DIV");
                        let valueQtxt = document.createTextNode("内容脚本");
                        valueQTitle.appendChild(valueQtxt);
                        valueQTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        if(that.propValues.handletype!="text"){
                            div.setAttribute("class",'d-none');
                        }
                        div.appendChild(valueQTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'valuescript':
                                    chinaName = "内容脚本";
                                    html += `<label>${chinaName}</label>`
                                    html += `<textarea name='${propName}' placeholder="/*返回内容字符串，如果内容为url地址，扫码后会调转到此url指定的页面上*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`;
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "value":
                        let valueTitle = document.createElement("DIV");
                        let valuetxt = document.createTextNode("值");
                        valueTitle.appendChild(valuetxt);
                        valueTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        
                        div.appendChild(valueTitle);
                        
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                
                                case 'editmode':
                                    editmodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label  class="partConRadioLabel">${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label  class="partConRadioLabel">${el.label}</label>`
                                        }
                                    })
                                    break; 
                                case 'isdefaultvalue':
                                    chinaName = "仅创建时计算";
                                    html+=`<label class="partConCheckboxLabel">${chinaName}</label>`
                                    if(that.propValues[propName]==true){
                                        html+=`<input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html+=`<input name='${propName}' type='checkbox'  />`
                                    }
                                    break; 
                                case 'valuescript':
                                    if(that.propValues.editmode=="00"){
                                        span.setAttribute("class","d-none");
                                    }
                                    chinaName = "脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回值作为该控件的默认值 */">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'processdescription':
                                    if(that.propValues.editmode=="01"){
                                        span.setAttribute("class","d-none");
                                    }
                                    chinaName = "字段";
                                    html+=`<div style="display:flex;">`
                                    html+=`<div><p>${chinaName}</p><select name="processfield"  size="12" style="width:100px;height:auto;">`
                                    fieldOption.forEach(el=>{
                                        html+=`<option  value='${el.value}'>${el.text}</option>`
                                    })
                                    
                                    html+=`</select></div>`;
                                    html+=`<div><p>操作</p>`
                                    numberOptions.forEach(el=>{
                                        html+=`<input style="width:50px;height:25px;display:block;" name="processoprion" type="button" value="${el.value}" >`
                                    })
                                    html+=`</div>`
                                    html += `<div><p>显示</p><textarea name='${propName}' style="width:100px;height:200px">${that.propValues[propName]}</textarea></div>`

                                    
                                    html+=`</div>`

                                    break;

                            }
                            html+="<br>"

                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "options":
                        let optionsTitle = document.createElement("DIV");
                        let optionstxt = document.createTextNode("选项");
                        optionsTitle.appendChild(optionstxt);
                        optionsTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        
                        div.appendChild(optionsTitle);
                        
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                
                                case 'optionseditmode':
                                    optionseditmodeOptions.forEach(el=>{
                                        if(el.value==that.propValues[propName]){
                                            html+=`<input name='${propName}' type='radio' value=${el.value} checked/><label>${el.label}</label>`
                                        }else{
                                            html+=`<input name='${propName}' type='radio' value=${el.value} /><label>${el.label}</label>`
                                        }
                                    })
                                    break; 
                                case 'optionsscript':
                                    if(that.propValues.optionseditmode=="00"){
                                        span.setAttribute("class","d-none");
                                    }
                                    chinaName = "脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回字符串或Options对象作为该控件的可选选项*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'module':
                                    //把整个选项设计模块都归结为module属性方便隐藏
                                    if(that.propValues.optionseditmode=="01"){
                                        span.setAttribute("class","d-none");
                                    }
                                    html+=`<div>`
                                    html+=`<div><label>模块</label><select name='${propName}'>`
                                    // for(let key in modulesOption){
                                    //     if(that.propValues[propName]==key){
                                    //         html+=`<option value='${key}' selected>${modulesOption[key]}</option>`
                                    //     }else{
                                    //         html+=`<option value='${key}'>${modulesOption[key]}</option>`

                                    //     }
                                    // }
                                    modulesOption.forEach(el=>{
                                        if(el.id==that.propValues[propName]){
                                            html+=`<option value='${el.id}' selected>${el.value}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.value}</option>`    
                                        }
                                    })
                                    html+=`</select></div>`
                                    html+=`<div><label>视图</label><select name='dialogview'>`
                                    that.propValues.viewsoptions.forEach(el=>{
                                        if(el.id==that.propValues.dialogview){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select></div>`
                                    html+=`<div style="display:flex;align-items: center;"><p style="vertical-align:middle;padding:0 10px 0 3px">映射</p>`
                                    html +=`<div style="display:flex; vertical-align: middle;">`
                                    html+=`<div style="width:150px"><p>真实值</p><p style="color:red;">提示：真实值最好是选择数据唯一的字段</p><select name='optionstext'>`
                                    
                                    that.propValues.optionstextoptions.forEach(el=>{
                                        if(el.id==that.propValues.optionstext){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select></div>`
                                    html+=`<div style="width:80px"><p style='padding-bottom: 32px;'>显示值</p><select name='optionsvalue'>`
                                    that.propValues.optionstextoptions.forEach(el=>{
                                        if(el.id==that.propValues.optionsvalue){
                                            html+=`<option value='${el.id}' selected>${el.name}</option>`
                                        }else{
                                            html+=`<option value='${el.id}'>${el.name}</option>`    
                                        }
                                    })
                                    html+=`</select></div>`
                                    html +=`</div></div>`

                                    html+=`</div>`
                                    
                                    

                                    break;
                                default:
                                    break;

                            }
                            html+="<br>"

                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "check":
                        let checkTitle = document.createElement("DIV");
                        let checktxt = document.createTextNode("校验");
                        checkTitle.appendChild(checktxt);
                        checkTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        
                        div.appendChild(checkTitle);
                        
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'validatelibs':
                                    chinaName = "标准校验";
                                    span.setAttribute("class",'d-flex')
                                    html+=`<label>${chinaName}</label><div>`
                                    validatelibsOptions.forEach(el=>{
                                        let have=false;
                                        for(let i=0;i<that.propValues.validatelibs.length;i++){
                                            if(el.value==that.propValues.validatelibs[i]){have=true;break;}else have=false;
                                        }
                                        if(have){
                                            html+=`<label class="partConRadioLabel">${el.label}</label><input name='${propName}' value='${el.value}' type='checkbox' checked/><br>`
                                        }else{
                                            html+=`<label class="partConRadioLabel">${el.label}</label><input name='${propName}' value='${el.value}' type='checkbox'/><br>`
                                        }
                                        
                                    })
                                    html+=`</select></div>`
                                    break; 
                                case 'validaterule':
                                    chinaName = "校验脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' readonly placeholder="/*描述：动作触发前执行
                                    返回值：
                                         1.无返回值，不做处理
                                         2.返回字符串      --弹出警告框（Alert）
                                    */">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;
                                case 'instantvalidate':
                                    chinaName = "即时校验";
                                    if(that.propValues[propName]==true){
                                        html=`<label  class="partConRadioLabel">${chinaName}</label><input name='${propName}' type='checkbox' checked/>`
                                    }else{
                                        html=`<label class="partConRadioLabel">${chinaName}</label><input name='${propName}' type='checkbox'  />`
                                    }
                                    break; 

                            }
                            html+="<br>"

                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "hidden":
                        let hiddenTitle = document.createElement("DIV");
                        let hiddentxt = document.createTextNode("隐藏条件");
                        hiddenTitle.appendChild(hiddentxt);
                        hiddenTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        
                        div.appendChild(hiddenTitle);
                        
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'hiddenscript':
                                    chinaName = "隐藏条件脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回布尔值（true/false）*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'hiddenvalue':
                                    chinaName = "隐藏时显示值";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='text' value='${that.propValues[propName]}' >`;
                                    break; 

                            }
                            html+="<br>"

                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "hiddenprint":
                        let hiddenprintTitle = document.createElement("DIV");
                        let hiddenprinttxt = document.createTextNode("打印时隐藏条件");
                        hiddenprintTitle.appendChild(hiddenprinttxt);
                        hiddenprintTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");
                        
                        div.appendChild(hiddenprintTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'hiddenprintscript':
                                    chinaName = "打印时隐藏条件脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回布尔值（true/false）*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break; 
                                case 'printhiddenvalue':
                                    chinaName = "打印隐藏时显示值";
                                    html = `<label>${chinaName}</label><input name='${propName}' type='text' value='${that.propValues[propName]}' />`;
                                    break; 

                            }
                            html+="<br>"

                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "readonly":
                        let readonlyTitle = document.createElement("DIV");
                        let readonlytxt = document.createTextNode("只读条件");
                        readonlyTitle.appendChild(readonlytxt);
                        readonlyTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");

                        div.appendChild(readonlyTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'readonlyscript':
                                    chinaName = "只读条件脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回布尔值（true/false）*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "ok":
                        let okTitle = document.createElement("DIV");
                        let oktxt = document.createTextNode("确定条件");
                        okTitle.appendChild(oktxt);
                        okTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");

                        div.appendChild(okTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'okscript':
                                    chinaName = "确定条件脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回布尔值（true/false）*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "callback":
                        let callbackTitle = document.createElement("DIV");
                        let callbacktxtName=""
                        if(scope=="qrcodeField")callbacktxtName="回调脚本";else callbacktxtName="确定后执行条件"
                        let callbacktxt = document.createTextNode(callbacktxtName);
                        callbackTitle.appendChild(callbacktxt);
                        callbackTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");

                        if(scope=="qrcodeField" && that.propValues.handletype!="callback_event"){
                            div.setAttribute("class",'d-none');
                        }
                        div.appendChild(callbackTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'callbackscript':
                                    chinaName = "确定后执行脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}'>${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    case "selected":
                        let selectedTitle = document.createElement("DIV");
                        let selectedtxt = document.createTextNode("页签选中脚本");
                        selectedTitle.appendChild(selectedtxt);
                        selectedTitle.setAttribute("class","partHeader");
                        baseCon.setAttribute("class","partCon d-none");

                        div.appendChild(selectedTitle);
                        for(let i=0;i<that.propsDesc[propPart].length;i++){
                            let propName = that.propsDesc[propPart][i];
                            let chinaName = null;
                            let span = document.createElement("SPAN");
                            let html = '';
                            switch (propName) {
                                case 'selectedscript':
                                    chinaName = "页签选中脚本";
                                    html = `<label>${chinaName}</label><textarea name='${propName}' placeholder="/*返回页签的名称,作为默认打开的页签*/">${that.propValues[propName]}</textarea><img name='openScript' src='./images/editor.png'/>`
                                    break;

                            }
                            html+="<br>";
                            span.innerHTML = html;
                            baseCon.appendChild(span)
                        }
                    break;
                    default:
                    break;
                }
                div.appendChild(baseCon);
                that.htmlDOM.appendChild(div); 
                
            }
            this.propsContainer.appendChild(this.htmlDOM);
            this.unbindEvent();
            this._bindEvent();
            this.rendering=false;
        }
        
    }
    /**
     * 获取当前点击的控件或容器
     */
    getCurrElem(){
        let currElem=null;
        window.formApp.allElements.forEach((el)=>{
            if(el.isChecked){
                currElem=el;
                return currElem;
            }
        })
        if(currElem == null){
            if(window.formApp.formPanel.isChecked){
                currElem = window.formApp.formPanel;
                return currElem;
            }
            for(let j=0;j<window.formApp.formPanel.childs.length;j++){
                if(window.formApp.formPanel.childs[j].isChecked){
                    currElem=window.formApp.formPanel.childs[j];
                    return currElem;
                }else{
                    currElem = window.formApp.formPanel.childs[j].getChecked();
                    if(currElem){
                        return currElem;   
                    }
                }
            }
        }
        if(currElem){
            return currElem;   
        }else{
            return null;
        }
    }
    //属性面板事件解绑
    unbindEvent(){
        this.propsContainer.removeEventListener("change",this.changeEvent,false);
    }
    /**
     * 属性面板绑定事件
     */
    _bindEvent(){
        let that=this;
        let currElem = this.getCurrElem();
        let allName = ["选择"];
        window.formApp.allElements.forEach(el=>{
            allName.push(el.propValues.name);
        })
        let nowEditScriptName='';//当前正在编辑的脚本多行文本框name
        let testOptions=[{label:"测试1",value:"1"},{label:"测试2",value:"2"}],
        relstrtypeOptions=[{label:"标签页",value:"form"},{label:"视图",value:"view"}],
        emptyOptions=[{label:"选择",value:""}]

        //input事件
        this.propsContainer.addEventListener("change",this.changeEvent,false);
        //脚本编辑器事件
        let scriptDomLength = document.getElementsByName("openScript").length;
        for(let q=0;q<scriptDomLength;q++){
            document.getElementsByName("openScript")[q].addEventListener('click',(e)=>{
                let code=e.target.previousSibling.value;
                let formIscriptName=e.target.previousSibling.getAttribute("name")
                window.parent['openIscript'](code,formIscriptName,currElem.propValues.id);

            })
        }
        // //值设计的字段绑定事件
        let processfieldlength=document.getElementsByName("processfield").length;
        for(let m=0;m<processfieldlength;m++){
            document.getElementsByName("processfield")[m].addEventListener("click",(e)=>{
                currElem = that.getCurrElem();
                let key = 'processdescription';
                let value = null;
                
                value =e.target.value;
                let text = e.target.options?e.target.options[e.target.selectedIndex].innerHTML:e.target.innerHTML;
                
                // currElem.propValues.processdescription +=text;
                // currElem.propValues.processprevalue.push({"text":text,value:value});
                let script="";
                if(currElem.propValues.filtercondition==""){
                    script="var doc= $CURRDOC.getCurrDoc();";
                }
                if(value=="VALUE_TYPE_VARCHAR"){
                    script+='(doc.getItemValueAsString(\''+text+'\'))';
                }else if(value=="VALUE_TYPE_NUMBER"){
                    script+='(doc.getItemValueAsDouble(\''+text+'\'))';
                }else if(value=="VALUE_TYPE_DATE"){
                    script+='(doc.getItemValueAsString(\''+text+'\'))';
                }else{
                        script+='(doc.getItemValueAsString(\''+text+'\'))';
                }
                let obj={
                    processdescription: currElem.propValues.processdescription + text,
                    processprevalue:currElem.propValues.processprevalue.concat({"text":text,value:value}),
                    filtercondition:currElem.propValues.filtercondition+script,
                }
                // currElem.propValues.filtercondition+=script;
                currElem.setPropValues(obj);
                e.target.parentElement.nextElementSibling?e.target.parentElement.nextElementSibling.nextElementSibling.children[1].value+=text:e.target.parentElement.parentElement.nextElementSibling.nextElementSibling.children[1].value+=text;
            },false);
        }
        //值设计的操作绑定事件
        let processoprionlength=document.getElementsByName("processoprion").length;
        for(let n=0;n<processoprionlength;n++){
            document.getElementsByName("processoprion")[n].addEventListener("click",(e)=>{
                currElem = that.getCurrElem();
                let value = null;
                value = e.target.value;
                let obj = null;
                if(value=="Clear"){
                    currElem.propValues.processdescription ="";
                    currElem.propValues.filtercondition="";
                    currElem.propValues.processprevalue=[];
                    e.target.parentElement.nextElementSibling.children[1].value="";
                }else{
                    currElem.propValues.processdescription +=value;
                    currElem.propValues.filtercondition+=value;
                    e.target.parentElement.nextElementSibling.children[1].value+=value

                }
            },false);
        }
        //refreshfields重刷新 局部刷新字段的添加事件
        if(document.getElementById("addRefreshField")){
            document.getElementById("addRefreshField").addEventListener("click",(e)=>{
                // refreshfields 
                let arr = currElem.getPropValues().refreshfields;
                arr.push("");
                currElem.setPropValues({"refreshfields":arr});
                let div = document.createElement("DIV");
                div.setAttribute("style",'display:block')
                let html = `
                    <label >字段名称</label>
                    <select id='refreshfields' name="refreshfields" style="width:100px;">`;
                    if(allName.length>0){
                        for(let k=0;k<allName.length;k++){
                            html+=`<option value=${allName[k]}>${allName[k]}</option>`
                        }
                    }
                    html+=`</select>
                    <button  class="delRefreshField">删除</button>
                </div>`;
                div.innerHTML=html;
                div.getElementsByClassName("delRefreshField")[0].addEventListener("click",(e)=>{
                    let arr = currElem.getPropValues().refreshfields;
                    let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                    arr.splice(index,1)
                    currElem.setPropValues({"refreshfields":arr});
                    e.target.parentElement.parentElement.removeChild(e.target.parentElement)
                })
                e.target.nextElementSibling.appendChild(div)

            },false);
        }
        //refreshfields重刷新 局部刷新字段的删除事件
        let delRefreshFieldlength=this.propsContainer.getElementsByClassName("delRefreshField").length;
        for(let l=0;l<delRefreshFieldlength;l++){
            this.propsContainer.getElementsByClassName("delRefreshField")[l].addEventListener("click",(e)=>{
                let arr = currElem.getPropValues().refreshfields;
                let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                arr.splice(index,1)
                currElem.setPropValues({"refreshfields":arr});
                e.target.parentElement.parentElement.removeChild(e.target.parentElement)
            },false);
        }
        //mapping 字段的添加事件
        if(document.getElementById("addmapping")){
            document.getElementById("addmapping").addEventListener("click",(e)=>{
                currElem.propValues.mapping.push({});
                let addMap=document.createElement("div");
                addMap.setAttribute('style','display:flex;');
                let noMyAllName=[...allName];
                let index=null;
                allName.forEach((elm,ind)=>{
                    if(that.propValues.name==elm)index=ind;
                })
                noMyAllName.splice(index,1);
                let html=`<i style="padding:0 3px;font-style:normal;">从</i>
                    <select  name="colname" class="form-control"  style="width:100px">`
                    //用allname替代，后面改成接口返回的 
                    currElem.propValues.optionstextoptions.forEach(el=>{
                        html+=`<option value='${el.id}'>${el.name}</option>`
                    })
                    html+=`</select>
                    <i style="padding:0 3px;font-style:normal;">从</i>
                    <select  name="fldname" class="form-control"  style="width:100px">`
                    noMyAllName.forEach((val)=>{
                        html+=`<option value=${val}>${val}</option>`
                    })
                    html+=`</select>
                    <button class="delmapping padding0" style="margin:0 3px;">删除</button>
                `;
                addMap.innerHTML=html;
                addMap.getElementsByClassName("delmapping")[0].addEventListener("click",(e)=>{
                    let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement)-2; 
                    currElem.propValues.mapping.splice(index,1)
                    e.target.parentElement.remove();


                },false);
                e.target.parentElement.appendChild(addMap);



            },false);
        }
        //mapping 字段的删除事件
        if(this.propsContainer.getElementsByClassName("delmapping").length>0){
            let mappingLength=this.propsContainer.getElementsByClassName("delmapping").length;

            for(let o=0;o<mappingLength;o++){
                this.propsContainer.getElementsByClassName("delmapping")[o].addEventListener("click",(e)=>{
                    let index = [].indexOf.call(e.target.parentElement.parentElement.parentElement.children, e.target.parentElement.parentElement)-2; 
                    currElem.propValues.mapping.splice(index,1)
                    e.target.parentElement.remove();
                    // e.target.parentElement.appendChild(addMap);


                },false);
            }
            
        }
        
        //选项卡relstr 的添加事件
        if(document.getElementById("addRelstr")){
            document.getElementById("addRelstr").addEventListener("click",(e)=>{
                let el={
                    name:"",
                    type:"form",
                    moduleId:"",
                    formId:"",
                    formsOptions:[{"id":"",name:'选择'}],
                    recalculate:true,
                    relate:false,
                    hiddenScript:'',
                    readOnlyScript:'',
                    hiddenPrintScript:"",
                }
                let index=currElem.propValues.relstr.length;
                let div=document.createElement("div");
                div.setAttribute('style',"width:100px;display: inline-block;");
                let html=""
                html+=`<input class="marginB5" name='name${index}' type='text' style="width:100px" value='${el.name}' />`
                html+=`<select class="marginB5" name='type${index}'  style="width:100px" >`
                relstrtypeOptions.forEach(elm=>{
                    if(elm.value==el.type){
                        html+=`<option value='${elm.value}' selected>${elm.label}</option>`
                    }else{
                        html+=`<option value='${elm.value}'>${elm.label}</option>`    
                    }
                })
                html+=`</select>`
                html+=`<select class="marginB5" name='moduleId${index}' style="width:100px" >`
                that.modulesOption.forEach(el=>{
                    html+=`<option value='${el.id}'>${el.value}</option>`  
                })
                html+=`</select>`
                html+=`<select class="marginB5" name='formId${index}' style="width:100px" >`
                emptyOptions.forEach(elm=>{
                    if(elm.value==el.formId){
                        html+=`<option value='${elm.value}' selected>${elm.label}</option>`
                    }else{
                        html+=`<option value='${elm.value}'>${elm.label}</option>`    
                    }
                })
                html+=`</select>`
                if(el.recalculate==true){
                    html+=`<input class="marginB5" name='recalculate${index}' type='checkbox' checked style="width:100px" />`
                }else{
                    html+=`<input class="marginB5" name='recalculate${index}' type='checkbox'  style="width:100px"  />`
                }
                if(el.relate==true){
                    html+=`<input class="marginB5" name='relate${index}' type='checkbox' checked style="width:100px" />`
                }else{
                    html+=`<input class="marginB5" name='relate${index}' type='checkbox'  style="width:100px"  />`
                }
                html += `<textarea class="marginB5" name='hiddenScript${index}' style="width:100px" >${el.hiddenScript}</textarea><img name='openScript' src='./images/editor.png'/>`
                html += `<textarea class="marginB5" name='readOnlyScript${index}' style="width:100px" >${el.readOnlyScript}</textarea><img name='openScript' src='./images/editor.png'/>`
                html += `<textarea class="marginB5" name='hiddenPrintScript${index}' style="width:100px" >${el.hiddenPrintScript}</textarea><img name='openScript' src='./images/editor.png'/><br>`
                html += `<button  class="delRelstr">删除</button>`
                html += `</div>`;
                div.innerHTML=html;
                div.getElementsByClassName("delRelstr")[0].addEventListener("click",(e)=>{
                    let arr = currElem.getPropValues().relstr;
                    let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                    arr.splice(index,1)
                    currElem.setPropValues({"relstr":arr});
                    e.target.parentElement.parentElement.removeChild(e.target.parentElement);
                    currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].removeChild(currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[index])
                    currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].removeChild(currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].children[index])
                    if(currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[0]){
                        currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[0].setAttribute("class",'normalTabCheck')
                        currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].children[0].setAttribute("class",'')
                    }
                },false);
                let scriptDomLength = div.getElementsByTagName("IMG").length;
                for(let q=0;q<scriptDomLength;q++){
                    div.getElementsByTagName("IMG")[q].addEventListener('click',(e)=>{
                        let code=e.target.previousSibling.value;
                        let formIscriptName=e.target.previousSibling.getAttribute("name")
                        window.parent['openIscript'](code,formIscriptName,currElem.propValues.id);

                    })
                }
                e.target.nextElementSibling.children[1].appendChild(div)
                currElem.propValues.relstr.push(el);
                if(index==0){
                    currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML=currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML+`<a name="name${index}" class="normalTabCheck"></a>`
                    currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML=currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML+`<tab-content></tab-content>`
                }
                else{
                    currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML=currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML+`<a name="name${index}" class="normalTab"></a>`
                    currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML=currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML+`<tab-content class='d-none'></tab-content>`
                }
                
            },false);
        }
        //relstr 选项卡删除事件
        let delRelstrlength=this.propsContainer.getElementsByClassName("delRelstr").length;
        for(let p=0;p<delRelstrlength;p++){
            this.propsContainer.getElementsByClassName("delRelstr")[p].addEventListener("click",(e)=>{
                let arr = currElem.getPropValues().relstr;
                let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                arr.splice(index,1)
                currElem.setPropValues({"relstr":arr});
                e.target.parentElement.parentElement.removeChild(e.target.parentElement)
                currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].removeChild(currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[index])
                currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].removeChild(currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].children[index])
                if(currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[0]){
                    currElem.htmlDOM.getElementsByClassName("normalTabDiv")[0].children[0].setAttribute("class",'normalTabCheck')
                    currElem.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].children[0].setAttribute("class",'')
                }
            },false);
        }

        //dispatcherparams的添加事件
        if(document.getElementById("addDispatcherparams")){
            document.getElementById("addDispatcherparams").addEventListener("click",(e)=>{
                let el={
                    paramKey:"",
                    paramValue:'',
                }
                let index=currElem.propValues.dispatcherparams.length;
                let div=document.createElement("div");
                div.setAttribute("style",'margin-top:5px')
                let html=""
                html+=`<input style="width:30%"  name=paramKey${index} value=${el.paramValue}/>
                        <input style="width:30%"  name=paramValue${index}  value=${el.paramValue}/>
                        <button class="delDispatcherparams">删除</button>`;
                div.innerHTML=html;
                div.getElementsByClassName("delDispatcherparams")[0].addEventListener("click",(e)=>{
                    let arr = currElem.getPropValues().delDispatcherparams;
                    let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                    arr.splice(index,1)
                    currElem.setPropValues({"dispatcherparams":arr});
                    e.target.parentElement.parentElement.removeChild(e.target.parentElement)
                },false);
                e.target.parentElement.nextElementSibling.appendChild(div)
                currElem.propValues.dispatcherparams.push(el);

            },false);
        }
        //dispatcherparams删除事件
        let delDispatcherparamslength=this.propsContainer.getElementsByClassName("delDispatcherparams").length;
        for(let p=0;p<delDispatcherparamslength;p++){
            this.propsContainer.getElementsByClassName("delDispatcherparams")[p].addEventListener("click",(e)=>{
                let arr = currElem.getPropValues().dispatcherparams;
                let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                arr.splice(index,1)
                currElem.setPropValues({"dispatcherparams":arr});
                e.target.parentElement.parentElement.removeChild(e.target.parentElement)
            },false);
        }


        //属性面板的伸缩展开事件
        let headerlength=this.propsContainer.getElementsByClassName("partHeader").length;
        for(let j=0;j<headerlength;j++){
            that.propsContainer.getElementsByClassName("partHeader")[j].addEventListener("click",(e)=>{
                if(that.propsContainer.getElementsByClassName("partCon")[j].getAttribute("class").indexOf("d-none")!=-1){
                    that.propsContainer.getElementsByClassName("partCon")[j].setAttribute('class',"partCon")
                }else{
                    that.propsContainer.getElementsByClassName("partCon")[j].setAttribute('class',"partCon d-none");
                }
            },false);
        }
        
    }
    changeEvent(e){
        let that=window.formApp.propsPanel;
        let currElem = that.getCurrElem();
        let allName = ["选择"];
        window.formApp.allElements.forEach(el=>{
            allName.push(el.propValues.name);
        })
        e.stopPropagation();  
        if(e.target.nodeName.toLowerCase() =='input'){
            currElem = that.getCurrElem();
            let type=e.target.getAttribute('type');
            let key = e.target.getAttribute('name');

            let value = null;
            if(type=="checkbox"){
                value = e.target.checked;
                if(that.scope!="weixingpsField" &&that.scope!="qrcodeField" &&( key == "refreshonchanged" || key == 'fixation')){
                    if(value){
                        e.target.parentElement.nextSibling.setAttribute("class","");
                        if(currElem.propValues.refreshmode == "1")
                        e.target.parentElement.nextSibling.nextSibling.setAttribute("class","");
                    }else{
                        e.target.parentElement.nextSibling.setAttribute("class","d-none");
                        if(key == "refreshonchanged")
                        e.target.parentElement.nextSibling.nextSibling.setAttribute("class","d-none");
                    }
                }else if(key == "validatelibs"){
                    let arr=[];
                    for(let i=0;i<e.target.parentElement.getElementsByTagName("input").length;i++){
                        if(e.target.parentElement.getElementsByTagName("input")[i].checked){
                            arr.push(e.target.parentElement.getElementsByTagName("input")[i].getAttribute("value"));
                        }
                    }
                    value=arr;
                }else if(key =="openwatermark"){
                    if(value){
                        e.target.parentElement.nextSibling.setAttribute("class","");
                        e.target.parentElement.nextSibling.nextSibling.setAttribute("class","");
                    }else{
                        e.target.parentElement.nextSibling.setAttribute("class","d-none");
                        e.target.parentElement.nextSibling.nextSibling.setAttribute("class","d-none");
                    }
                }else if(key =="limit"){
                    if(value){
                        e.target.parentElement.nextSibling.setAttribute("class","");
                    }else{
                        e.target.parentElement.nextSibling.setAttribute("class","d-none");
                    }
                }else if(key =="watermarksupportmode"){
                    value="";
                    let arr=e.target.parentElement.getElementsByTagName("input").length;
                    for(let i=0;i<arr;i++){
                        if(e.target.parentElement.getElementsByTagName("input")[i].checked){
                            if(value=="" || i==arr-1)
                            value+=e.target.parentElement.getElementsByTagName("input")[i].value;
                            else value+=e.target.parentElement.getElementsByTagName("input")[i].value+",";
                                
                        }
                    }
                }else if(key =="statetoshow"){
                    let arr="";
                    let length = e.target.parentElement.children.length;
                    for(let i=0;i<length;i++){
                        if(e.target.parentElement.children[i].nodeName=="INPUT" && value){
                            arr+=e.target.parentElement.children[i].previousSibling.innerHTML;
                            if(arr.length>0){
                                arr+=";"
                            }
                        }
                        
                    }
                    value=arr;
                }else if(key =='selectone'){
                    //视图选择框拼接模式多项选择只能选择一个
                    if(value)
                    e.target.parentElement.nextElementSibling.getElementsByTagName("input")[0].disabled=true;
                    else
                    e.target.parentElement.nextElementSibling.getElementsByTagName("input")[0].disabled="";
                }else if(key =='mutilselect'){
                    //视图选择框拼接模式多项选择只能选择一个
                    if(value)
                    e.target.parentElement.previousSibling.getElementsByTagName("input")[0].disabled=true;
                    else
                    e.target.parentElement.previousSibling.getElementsByTagName("input")[0].disabled="";
                }
                
            }else if(type=="number"){
                value = parseInt(e.target.value);
                if(key == "myselfrows"){
                    currElem.setPropValues({"myselfrows":value});
                    currElem.setBasePropValues({"width":value+"%"});
    
                    // currElem.resetElemWidth();//重置当前容器的子元素和宽度
                }
            }else{
                value = e.target.value;
                if( key == "refreshmode"){
                    if(value=="1"){
                        e.target.parentElement.nextSibling.setAttribute("class","");
                    }else{
                        e.target.parentElement.nextSibling.setAttribute("class","d-none");
                    }
                }
                if( key == "editmode"){
                    if(value=="01"){
                        e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","");
                        e.target.parentElement.nextElementSibling.nextElementSibling.nextElementSibling.setAttribute("class","d-none");
                    }else{
                        e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","d-none");
                        e.target.parentElement.nextElementSibling.nextElementSibling.nextElementSibling.setAttribute("class","");
                    }
                }
                if( key == "optionseditmode"){
                    if(value=="00"){
                        e.target.parentElement.nextElementSibling.setAttribute("class","");
                        e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","d-none");
                    }else{
                        e.target.parentElement.nextElementSibling.setAttribute("class","d-none");
                        e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","");
                    }
                }
                if(key =="maximization" && value=="false"){
                    e.target.parentElement.nextSibling.setAttribute("class","");
                }else if(key =="maximization" && value!="false"){
                    e.target.parentElement.nextSibling.setAttribute("class","d-none");
                    e.target.parentElement.nextSibling.getElementsByTagName("input")[0].value="";
                    e.target.parentElement.nextSibling.getElementsByTagName("input")[1].value="";


                }
                if((key == 'filetype'||key=="filepattern") && value =="00"){
                    e.target.parentElement.parentElement.nextSibling.setAttribute("class","d-none");
                }else if((key == 'filetype'||key=="filepattern") && value =="01"){
                    e.target.parentElement.parentElement.nextSibling.setAttribute("class","");

                }
                if(key=="handletype"){
                    switch(value){
                        case 'text':
                            document.getElementsByName("refreshonchanged")[0].parentElement.setAttribute("class",'d-none');
                            document.getElementsByName("valuescript")[0].parentElement.parentElement.parentElement.setAttribute("class",'')
                            document.getElementsByName("callbackscript")[0].parentElement.parentElement.parentElement.setAttribute("class",'d-none')
                            break;
                        case 'link':
                            document.getElementsByName("refreshonchanged")[0].parentElement.setAttribute("class",'d-none');
                            document.getElementsByName("valuescript")[0].parentElement.parentElement.parentElement.setAttribute("class",'d-none')
                            document.getElementsByName("callbackscript")[0].parentElement.parentElement.parentElement.setAttribute("class",'d-none')
                            break;
                        case 'callback_event':
                            document.getElementsByName("refreshonchanged")[0].parentElement.setAttribute("class",'');
                            document.getElementsByName("valuescript")[0].parentElement.parentElement.parentElement.setAttribute("class",'d-none')
                            document.getElementsByName("callbackscript")[0].parentElement.parentElement.parentElement.setAttribute("class",'')
                            break;
                        default:
                            break;
                    }
                    let obj={};
                    obj[key]=value;
                    currElem.setPropValues(obj);
                }
                if(key == "actionselection"){
                    value=e.target.value;
                    if(value=="0"){
                        e.target.parentElement.parentElement.nextElementSibling.setAttribute("class",'d-none');

                    }else{
                        e.target.parentElement.parentElement.nextElementSibling.setAttribute("class",'');
                    }
                    let obj={};
                    obj[key]=value;
                    currElem.setPropValues(obj);
                }
                if(key == "actiontype"){
                    value=e.target.value;
                    if(value=="3"){
                        e.target.parentElement.nextElementSibling.setAttribute("class",'');

                    }else{
                        e.target.parentElement.nextElementSibling.setAttribute("class",'d-none');
                    }
                    let obj={};
                    obj[key]=value;
                    currElem.setPropValues(obj);
                }
                if(key == 'jumpmode'){
                    if(value=="1"){
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','')
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','')
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','');
                    }else{
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','')
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','')
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none');
                    }
                    let obj={};
                    obj[key]=value;
                    currElem.setPropValues(obj);   
                }
                
            }
            if(that.scope=="tabField" && (key.indexOf("name")==0||key.indexOf("relate")!=-1||key.indexOf("recalculate")!=-1)){
                // let relstrInd=parseInt(key.replace(/[a-z|A-Z]*/g,""));
                let relstrInd = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 

                let relstrId=key.replace(/[0-9]*/g,"");
                let relstr=[...currElem.propValues.relstr];
                
                if(type=="checkbox"){
                    relstr[relstrInd][relstrId]=e.target.checked;
                    currElem.setPropValues({"relstr":relstr})
                    
                }else{
                    if(!currElem.propValues.allowsamename){
                        //不允许同名的时候
                        for(let k=0;k<relstr.length;k++){
                            if(relstr[k].name==e.target.value){
                                alert("选项卡不允许同名")
                                return false;
                            }
                        }
                        relstr[relstrInd][relstrId]=e.target.value;
                        currElem.setPropValues({"relstr":relstr})
                    }else{
                        relstr[relstrInd][relstrId]=e.target.value;
                        currElem.setPropValues({"relstr":relstr})
                    }
                    
                }
            }else if(key == "containerHeight"){
                let obj={};
                obj['min-height']=value+"px";
                obj[key]=value;
                currElem.setBasePropValues(obj);
            }else if(key == 'borderwidth'){
                let obj={};
                obj['border-width']=value+"px";
                currElem.setBasePropValues(obj);
                currElem.setPropValues({'borderwidth':value});
            }else if(key == 'containerwidth'){
                let obj={};
                obj['width']=value+'px';
                currElem.setBasePropValues(obj);
                currElem.setPropValues({'containerwidth':value});

            }
            if(that.scope=="buttonField" && (key.indexOf("paramKey")==0||key.indexOf("paramValue")!=-1)){
                let dispatcherparamsInd=parseInt(key.replace(/[a-z|A-Z]*/g,""));
                let dispatcherparamsId=key.replace(/[0-9]*/g,"");
                let dispatcherparams=[...currElem.propValues.dispatcherparams];
                
                dispatcherparams[dispatcherparamsInd][dispatcherparamsId]=e.target.value;
                currElem.setPropValues({"dispatcherparams":dispatcherparams})
            }else{
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }
        }else if(e.target.nodeName.toLowerCase() =='select'){
            currElem = that.getCurrElem();
            let key = e.target.getAttribute('name');

            let value = null;
            if(key=="refreshfields"){
                let arr = currElem.getPropValues().refreshfields;

                let index = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement);
                e.target.options[e.target.selectedIndex].value?arr[index] = e.target.options[e.target.selectedIndex].value:"";
                currElem.setPropValues({"refreshfields":arr});
            }else if(key == 'processfield'){
            }else if(key=="colname" || key=="fldname"){
                let prop={};
                if((e.target.nextElementSibling.nextElementSibling && e.target.nextElementSibling.nextElementSibling.options)||e.target.previousSibling.previousSibling.previousSibling.previousSibling.options){
                    // if(e.target.nextElementSibling.options[e.target.nextElementSibling.selectedIndex].value || e.target.previousSibling.previousSibling.options[e.target.nextElementSibling.selectedIndex].value){
                        prop["mapping"]=[];
                        if(key=="colname"){
                            let a={};
                            a[e.target.value]=e.target.nextElementSibling.nextElementSibling.options[e.target.nextElementSibling.nextElementSibling.selectedIndex].value
                            prop["mapping"].push(a)
    
                        }else{
                            let a2={};
                            a2[e.target.previousSibling.previousSibling.previousSibling.previousSibling.options[e.target.previousSibling.previousSibling.previousSibling.previousSibling.selectedIndex].value]=e.target.value
                            prop["mapping"].push(a2);
    
                        }
                    // }
                }
                let children = e.target.parentElement.parentElement.getElementsByTagName("div");
                let index = [].indexOf.call(children , e.target.parentElement )-1;
                if(currElem.propValues.mapping[index]){
                    currElem.propValues.mapping[index]=prop.mapping[0]
                }else{
                    currElem.propValues.mapping.push(prop.mapping[0])

                }
                currElem.setPropValues({"mapping":currElem.propValues.mapping});
                
                // currElem.setPropValues(prop);

            }else if(that.scope=="tabField" && (key.indexOf("type")!=-1||key.indexOf("moduleId")!=-1||key.indexOf("formId")!=-1)){
                // let relstrInd=parseInt(key.replace(/[a-z|A-Z]*/g,""));
                let relstrInd = [].indexOf.call(e.target.parentElement.parentElement.children, e.target.parentElement); 
                let relstrId=key.replace(/[0-9]*/g,"");
                let relstr=[...currElem.propValues.relstr];
                
                if(key.indexOf("moduleId")!=-1){
                    if(currElem.propValues.relstr[relstrInd].type=="form"){
                        let formsOptions=[{id:"",name:"选择"}],html="";
                        that.api.getFormsList(e.target.options[e.target.selectedIndex].value,2).then((result)=>{
                            if(result.indexOf("data")!=-1)
                            formsOptions=formsOptions.concat(JSON.parse(result).data);
                            formsOptions.forEach(elm=>{
                                html+=`<option value='${elm.id}'>${elm.name}</option>`
                            })
                            e.target.nextElementSibling.innerHTML=html;
                            relstr[relstrInd].formsOptions=formsOptions;
                            relstr[relstrInd].formId="";
                            currElem.setPropValues({"relstr":relstr})
                        })
                    }else if(currElem.propValues.relstr[relstrInd].type=="view"){
                        that.api.getModuleViews(e.target.options[e.target.selectedIndex].value).then((result)=>{
                            let viewsOption =[{id:"",name:"选择"}]
                            if(result.indexOf("datas")!=-1)
                            viewsOption= viewsOption.concat(JSON.parse(result).data.datas)
                            
                            let html=``;
                            viewsOption.forEach(el=>{
                                html+=`<option value='${el.id}'>${el.name}</option>`
                            })
                            e.target.nextElementSibling.innerHTML=html;
                            relstr[relstrInd].formsOptions=viewsOption;
                            relstr[relstrInd].formId="";
                            currElem.setPropValues({"relstr":relstr})
                            // currElem.propValues.relstr[relstrInd].formsOptions=viewsOption;

                        })
                    }
                }else if(key.indexOf("type")!=-1){
                    if(e.target.options[e.target.selectedIndex].value=="form"){
                        let formsOptions=[{id:"",name:"选择"}];
                        let html=``;

                        that.api.getFormsList(currElem.propValues.relstr[relstrInd].moduleId,2).then((result)=>{
                            if(result.indexOf("data")!=-1)
                            formsOptions=formsOptions.concat(JSON.parse(result).data);
                            formsOptions.forEach(elm=>{
                                html+=`<option value='${elm.id}'>${elm.name}</option>`
                            })
                            e.target.nextElementSibling.nextElementSibling.innerHTML=html
                        })
                        relstr[relstrInd].formsOptions=formsOptions;
                        relstr[relstrInd].formId="";
                        currElem.setPropValues({"relstr":relstr})
                        // currElem.propValues.relstr[relstrInd].formsOptions=formsOptions;
                    }else if(e.target.options[e.target.selectedIndex].value=="view"){
                        let viewsOption =[{id:"",name:"选择"}];
                        that.api.getModuleViews(currElem.propValues.relstr[relstrInd].moduleId).then((result)=>{
                            if(result.indexOf("datas")!=-1)
                            viewsOption= viewsOption.concat(JSON.parse(result).data.datas)
                            let html=``;
                            viewsOption.forEach(el=>{
                                html+=`<option value='${el.id}'>${el.name}</option>`
                            })
                            e.target.nextElementSibling.nextElementSibling.innerHTML=html;
                            
                        })
                        relstr[relstrInd].formsOptions=viewsOption;
                        relstr[relstrInd].formId="";
                        currElem.setPropValues({"relstr":relstr});
                    }
                }
                relstr[relstrInd][relstrId]=e.target.options[e.target.selectedIndex].value;
                currElem.setPropValues({"relstr":relstr})
            }else if(key == "module"){
                
                that.api.getModuleViews(e.target.options[e.target.selectedIndex].value).then((result)=>{
                    let viewsOption =[{id:"",name:"选择"}];
                    if(result.indexOf("datas")!=-1)
                    viewsOption= viewsOption.concat(JSON.parse(result).data.datas);
                    let html=``;
                    viewsOption.forEach(el=>{
                        html+=`<option value='${el.id}'>${el.name}</option>`
                    })
                    e.target.parentElement.nextElementSibling.children[1].innerHTML=html
                    value =e.target.options[e.target.selectedIndex].value;
                    let obj={};
                    obj[key]=value;
                    // if(that.scope=="includeField" || that.scope=="viewdialogField")
                    obj.viewsoptions=viewsOption;
                    currElem.setPropValues(obj);
                })
                
            }else if(key == "dialogview"){
                
                that.api.getViewsColumnsList(e.target.options[e.target.selectedIndex].value).then((result)=>{
                    let mapOption=[{id:"",name:"选择"}];
                    if(result.indexOf("data")!=-1)
                    mapOption =mapOption.concat(JSON.parse(result).data);
                    let html=``;
                    mapOption.forEach(el=>{
                        html+=`<option value='${el.id}'>${el.name}</option>`
                    })
                    if(that.scope=="viewdialogField"){
                        let length = e.target.parentElement.parentElement.lastElementChild.children[1].getElementsByTagName("div").length;
                        for(let i=1;i<length;i++){
                            e.target.parentElement.parentElement.lastElementChild.children[1].getElementsByTagName("div")[i].children[1].innerHTML=html;
                        }
                    }else{
                        e.target.parentElement.nextElementSibling.children[1].children[0].children[2].innerHTML=html;
                        e.target.parentElement.nextElementSibling.children[1].children[1].children[1].innerHTML=html;
                    }
                    value =e.target.options[e.target.selectedIndex].value;
                    let obj={};
                    obj[key]=value;
                    // if(that.scope=="radioField" || that.scope=="checkboxField" || that.scope=="selectaboutField" || that.scope=="selectField" || that.scope=="suggestField")
                    obj.optionstextoptions=mapOption;
                    currElem.setPropValues(obj);
                    
                })
                
            }else if(key == "acttype"){
                value=e.target.options[e.target.selectedIndex].value;
                switch(value){
                    case "13":
                        //自定义
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','')//动作处理方式
                        if(currElem.propValues.actionselection=='1')
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','')//动作关联表单
                        else
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单

                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','')//动作完成后操作类型
                        if(currElem.propValues.actiontype=='3')
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','')//地址脚本-自定义跳转的脚本
                        else
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                            
                    break;
                    case "42":
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                            
                            
                        break;
                    case "30":
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                                
                            
                        break;
                    case '26':
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                                
                                
                        break;
                    case '28':
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','')//签章类型
                        if(currElem.propValues.signaturetype=='HTML')
                            document.getElementsByName('datafield')[0].parentElement.setAttribute('class','')//签章数据关联字段
                        else
                            document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','')//签署动作

                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                                
                            
                        break;
                    case '37':
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                                
                    break;
                    case '43':
                            
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','')//类型
                        if(currElem.propValues.jumpmode=='0'){
                            document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','')//跳转设置
                        }else if(currElem.propValues.jumpmode=='1'){
                            document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','')//地址脚本
                            document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','')//参数
                            
                        }
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','d-none')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                                
                    break;
                    default:
                        document.getElementsByName('jumpmode')[0].parentElement.parentElement.setAttribute('class','d-none')//类型
                        document.getElementsByName('targetlist')[0].parentElement.setAttribute('class','d-none')//跳转设置
                        document.getElementsByName('dispatcherurl')[0].parentElement.setAttribute('class','d-none')//地址脚本
                        document.getElementsByName('dispatcherparams')[0].parentElement.setAttribute('class','d-none')//参数
                        document.getElementsByName('jumpactopentype')[0].parentElement.parentElement.setAttribute('class','d-none')//打开方式
                        document.getElementsByName('filenamescript')[0].parentElement.setAttribute('class','d-none')//文件路径脚本
                        document.getElementsByName('transpond')[0].parentElement.setAttribute('class','d-none')//摘要模板
                        document.getElementsByName('actionprint')[0].parentElement.setAttribute('class','d-none')//选择打印膜版
                        document.getElementsByName('withold')[0].parentElement.setAttribute('class','d-none')//带旧数据
                        document.getElementsByName('signaturetype')[0].parentElement.setAttribute('class','d-none')//签章类型
                        document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                        document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签署动作
                        document.getElementsByName('beforeactionscript')[0].parentElement.setAttribute('class','')//动作执行前脚本
                        document.getElementsByName('actionselection')[0].parentElement.parentElement.setAttribute('class','d-none')//动作处理方式
                        document.getElementsByName('relatedformid')[0].parentElement.setAttribute('class','d-none')//动作关联表单
                        document.getElementsByName('actionscript')[0].parentElement.setAttribute('class','d-none')//动作执行脚本
                        document.getElementsByName('afteractionscript')[0].parentElement.setAttribute('class','')//动作执行后脚本
                        document.getElementsByName('actiontype')[0].parentElement.setAttribute('class','d-none')//动作完成后操作类型
                        document.getElementsByName('actiondispatcherurlscript')[0].parentElement.setAttribute('class','d-none')//地址脚本-自定义跳转的脚本
                            
                        
                    break;
                }
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }else if(key == "moduleselect"){
                let formsOptions=[{id:"",name:"选择"}],html="";
                that.api.getFormsList(e.target.options[e.target.selectedIndex].value,1).then((result)=>{
                    if(result.indexOf("data")!=-1)
                    formsOptions=formsOptions.concat(JSON.parse(result).data);
                    formsOptions.forEach(elm=>{
                        html+=`<option value='${elm.id}'>${elm.name}</option>`
                    })
                    document.getElementsByName("formselect")[0].innerHTML=html;
                    let obj={};
                    obj[key]=e.target.options[e.target.selectedIndex].value
                    obj.formselect=document.getElementsByName("formselect")[0].options[document.getElementsByName("formselect")[0].selectedIndex].value
                    
                    currElem.setPropValues({"targetlist":obj})
                })
            }else if(key == "formselect"){
                let obj={};
                obj[key]=e.target.options[e.target.selectedIndex].value;
                obj.moduleselect=document.getElementsByName("moduleselect")[0].options[document.getElementsByName("moduleselect")[0].selectedIndex].value

                currElem.setPropValues({"targetlist":obj})
            }else if(key == 'fieldtype'){
                value=e.target.options[e.target.selectedIndex].value;
                if(value=="VALUE_TYPE_VARCHAR"){
                    e.target.parentElement.nextElementSibling.setAttribute("class","d-none");
                    e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","d-none");
                }else{
                    e.target.parentElement.nextElementSibling.setAttribute("class","");
                    e.target.parentElement.nextElementSibling.nextElementSibling.setAttribute("class","");
                }
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }else if(key == 'signaturetype'){
                value =e.target.options[e.target.selectedIndex].value;
                if(value=='HTML'){
                    document.getElementsByName('datafield')[0].parentElement.setAttribute('class','')//签章数据关联字段
                    document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                }
                else {
                    document.getElementsByName('datafield')[0].parentElement.setAttribute('class','d-none')//签章数据关联字段
                    document.getElementsByName('signatureaction')[0].parentElement.setAttribute('class','')//签章数据关联字段

                }

                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }else if(key == 'showmode' && that.scope=='tabField'){
                value =e.target.options[e.target.selectedIndex].value;
                if(value==1){
                    document.getElementsByName('openAll')[0].parentElement.setAttribute('class','')
                }
                else {
                    document.getElementsByName('openAll')[0].parentElement.setAttribute('class','d-none')                  
                }
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }
            else{
                value =e.target.options[e.target.selectedIndex].value;
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }
        }else if(e.target.nodeName.toLowerCase() =='textarea'){
            currElem = that.getCurrElem();
            let key = e.target.getAttribute('name');
            let value = null;
            value = e.target.value;
            if(that.scope=="tabField" && (key.indexOf("hiddenScript")!=-1||key.indexOf("readOnlyScript")!=-1||key.indexOf("hiddenPrintScript")!=-1)){
                let relstrInd=parseInt(key.replace(/[a-z|A-Z]*/g,""));
                let relstrId=key.replace(/[0-9]*/g,"");
                let relstr=[...currElem.propValues.relstr];

                // currElem.propValues.relstr[relstrInd][relstrId]=e.target.value;
                relstr[relstrInd][relstrId]=e.target.value;
                currElem.setPropValues({"relstr":relstr})
            }else if(key == 'discript' && value==""){
                //描述为空，
                let obj={};
                obj[key]=value;
                obj.name=currElem.propValues.name;;
                currElem.setPropValues(obj);   
            }else{
                let obj={};
                obj[key]=value;
                currElem.setPropValues(obj);
            }
        }
        
    }
}
export default PropsPanel;