import {Api,StringUtil} from '../utility';

import Container from './Container';

class AbstractElement {
    constructor() {
        this.x=0;
        this.y=0;
        // this.width="100%";
        // this.height=100;
        this.init();
        this.isChecked=false;
        this.propValues={};
        this.propValues.myselfrows=100;
        
    }
    init(){
        this.api = new Api();
        this.propPanel = document.getElementById("propsBoard");
    }
    setPropValues(obj){
        Object.assign(this.propValues, obj);
        this.renderHtml(obj,'prop')
        
    }
    renderHtml(obj,type="prop"){
        let that=this;
        if(type=="style"){
            for(let propName in obj){
                this.htmlDOM.style[propName]=obj[propName];
            }
        }else if(type=="prop"){
            for(let propName in obj){
                if(propName=='processdescription'){
                    let value="";
                    value += StringUtil.encodeHTML(JSON.stringify(obj.processprevalue));
                    value += ";";
                    value += "[" + this.propValues.processdescription.toString() + "]";
                    this.htmlDOM.setAttribute(propName,value);
    
                }else if(propName == 'processprevalue'){
                    let value="";
                    value += "[" + this.propValues.processdescription.toString() + "]";
                    this.htmlDOM.setAttribute(propName,value);
                }else if(propName == "refreshfields"||propName == 'validatelibs'){
                    let value="";
                    for(let i=0;i<obj[propName].length;i++){
                        value+=obj[propName][i];
                        if(i!=obj[propName].length-1)value+=';'
                    }
                    this.htmlDOM.setAttribute(propName,value);
                }else if(propName=="mapping"){
                    let value="";
                    value = JSON.stringify(obj.mapping).replace(/(^\[)|(\{)|(\])|(\})/g,"").replace(/"/g,"").replace(/,/g,";");
                    this.htmlDOM.setAttribute(propName,value);
                    
                }else if(propName=="relstr"){
                    let value="";
                    let arr=[...obj.relstr];
                    obj.relstr.forEach((elm,index)=>{
                        let {formsOptions, ...data} = elm;
                        // elm=data;
                        // JSON.stringify(data).replace(/"/g,"'");
                        data.hiddenScript=StringUtil.encodeHTML(data.hiddenScript);
                        data.readOnlyScript=StringUtil.encodeHTML(data.readOnlyScript)
                        data.hiddenPrintScript=StringUtil.encodeHTML(data.hiddenPrintScript)
                        arr[index]=data;
                        if(this.htmlDOM.getElementsByTagName("a")[index]){
                            this.htmlDOM.getElementsByTagName("a")[index].innerHTML=elm.name;
                            
                            if(elm.formId!=""){
                                if(elm.type=='form'){
                                    this.api.getFormDetail(elm.formId).then((result)=>{
                                        this.htmlDOM.getElementsByTagName("tab-content")[index].innerHTML = JSON.parse(result).data.templatecontext
                                    }) 
                                }else if(elm.type=='view'){
                                    this.api.getViewColumnList(elm.formId).then((result)=>{
                                        let column = JSON.parse(result).data;
                                        let h = "<table><tr>";
                                        column.forEach(elm=>{
                                            h+=`<td>${elm.name}</td>`
                                        })
                                        h += "</tr></table>";
                                        this.htmlDOM.getElementsByTagName("tab-content")[index].innerHTML = h;
                                    })
                                }
                                
                            }else if(elm.formId==""){
                                this.htmlDOM.getElementsByTagName("tab-content")[index].innerHTML=""
                            }
                        }  
                        else{
                            this.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML=this.htmlDOM.getElementsByClassName("normalTabDiv")[0].innerHTML+`<a name="name${index}" class="normalTab">${elm.name}</a>`
                            this.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML=this.htmlDOM.getElementsByClassName("normalTabPanelDiv")[0].innerHTML+`<tab-content class="d-none"></tab-content>`
                            if(elm.formId!=""){
                                if(elm.type=='form'){
                                    this.api.getFormDetail(elm.formId).then((result)=>{
                                        this.htmlDOM.getElementsByTagName("tab-content")[index].innerHTML = JSON.parse(result).data.templatecontext
                                    })
                                }else if(elm.type=='view'){
                                    this.api.getViewColumnList(elm.formId).then((result)=>{
                                        let column = JSON.parse(result).data;
                                        let h = "<table><tr>";
                                        column.forEach(elm=>{
                                            h+=`<td>${elm.name}</td>`
                                        })
                                        h += "</tr></table>";
                                        this.htmlDOM.getElementsByTagName("tab-content")[index].innerHTML = h;
                                    })
                                }
                            }
                        }
                    })
                    value = JSON.stringify(arr).replace(/"/g,"'");
                    this.htmlDOM.setAttribute(propName,value);
                    
                }else if(propName=="targetlist"){
                    let value="";
                    value = this.propValues[propName].formselect+"|"+this.propValues[propName].moduleselect;
                    this.htmlDOM.setAttribute(propName,value);

                }else if(propName=="dispatcherparams"){
                    let value="";
                    value = StringUtil.encodeHTML(JSON.stringify(obj.dispatcherparams));
                    this.htmlDOM.setAttribute(propName,value);
                    
                }else if(propName=="valuescript"||propName=="optionsscript"||propName=="validaterule" ||propName=="hiddenscript"||propName=="hiddenprintscript"||propName=="readonlyscript"||propName=="beforeactionscript"||propName=="afteractionscript" ||propName=="actionscript"||propName=="okscript"||propName=="callbackscript"||propName=="questionscript"||propName=="selectedscript"|| propName=='filenamescript'||propName=='dispatcherurl'||propName=='actiondispatcherurlscript'||propName=='watermarkscript'){
                    let value="";
                    value = StringUtil.encodeHTML(obj[propName]);
                    this.htmlDOM.setAttribute(propName,value);

                }else if(propName == "viewsoptions" || propName == "optionstextoptions"){
                }else if(propName == "inputwidth"){
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    this.htmlDOM.getElementsByClassName("baseCon")[0].getElementsByTagName("input")[0].setAttribute("style",`width:${obj[propName]}px`);
                }else if(propName == "textareaheight"){
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    this.htmlDOM.getElementsByClassName("baseCon")[0].getElementsByTagName("textarea")[0].setAttribute("style",`height:${obj[propName]}px`);
                }else if(propName == "name" && this.scope!='container'){
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    if(this.htmlDOM.getElementsByClassName("baseLabel-title")[0])
                    this.htmlDOM.getElementsByClassName("baseLabel-title")[0].innerHTML=obj[propName];//适用普通
                    else if(this.htmlDOM.getElementsByClassName("baseCon-btn")[0])
                    this.htmlDOM.getElementsByClassName("baseCon-btn")[0].innerHTML=obj[propName];//针对按钮
                }else if(propName=='discript'){
                    let value="";
                    value = StringUtil.encodeHTML_Discript(obj[propName]);
                    this.htmlDOM.setAttribute(propName,value);

                    if(this.htmlDOM.getElementsByClassName("baseLabel-title")[0] &&value!="")
                    this.htmlDOM.getElementsByClassName("baseLabel-title")[0].innerHTML=obj[propName];//适用普通
                }
                else if(propName=='caption'){
                    //视图选择框的说明文字
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    if(this.htmlDOM.getElementsByClassName("baseCon-btn")[0])
                    this.htmlDOM.getElementsByClassName("baseCon-btn")[0].innerHTML=obj[propName];
                }else if(propName=='imgh'){
                    //图片上传的高度
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    if(this.htmlDOM.getElementsByClassName("imageuploadField")[0])
                    this.htmlDOM.getElementsByClassName("imageuploadField")[0].style.height=obj[propName]+"px";
                }else if(propName=='imgw'){
                    //图片上传的宽度
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    if(this.htmlDOM.getElementsByClassName("imageuploadField")[0])
                    this.htmlDOM.getElementsByClassName("imageuploadField")[0].style.width=obj[propName]+"px";
                }else if(propName=='maximization'){
                    //视图选择框显示大小
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                    if(obj[propName]!='false'){
                        this.htmlDOM.setAttribute('divheight','');
                        this.htmlDOM.setAttribute('divwidth','');

                    }                    
                }else{
                    this.htmlDOM.setAttribute(propName,obj[propName]);
                }
            }
        }else if(type=='fieldid'){
            if(this.htmlDOM.getElementsByClassName("fieldId")[0])
            this.htmlDOM.getElementsByClassName("fieldId")[0].setAttribute("fieldid",obj)
        }
        this.htmlDOM.setAttribute('scope',this.scope);
    }
    setBasePropValues(obj){
        Object.assign(this.style, obj);
        this.renderHtml(obj,'style')
    }
    
    setallAttribute(con,htmlNode2){
        for(let k in con.propValues){
            let str;
            if(htmlNode2.getAttribute(k)){
                if(k=='processdescription'){
                    str=StringUtil.dencodeHTML(htmlNode2.getAttribute(k));
                    con.propValues.processprevalue=JSON.parse(str.split(";[")[0]);
                    con.propValues.processdescription=str.split(";[")[1].replace(/\]/,'');
                }else if(k == 'refreshfields'||k == 'validatelibs'){
                    str=htmlNode2.getAttribute(k);
                    con.propValues[k]=str.split(";")
                }else if(k == 'discript'||k=="valuescript"||k=="optionsscript"||k=="validaterule" ||k=="hiddenscript"||k=="hiddenprintscript"||k=="readonlyscript"||k=="beforeactionscript"||k=="afteractionscript"||k=="actionscript"||k=="okscript"||k=="callbackscript"||k=="questionscript"||k=="selectedscript"||k=='filenamescript'||k=='dispatcherurl'||k=='actiondispatcherurlscript'||k=='watermarkscript'){
                    str = StringUtil.dencodeHTML(htmlNode2.getAttribute(k));
                    con.propValues[k]=str;
                }else if(k == 'mapping'&&htmlNode2.getAttribute(k).length>2){
                    let arr = htmlNode2.getAttribute(k).split(";");
                    let str=[];
                    arr.forEach(elm=>{
                        str.push(JSON.parse('{"'+elm.replace(/:/,'":"')+'"}'))
                    })
                    con.propValues[k]=str;
                }else if(k == 'module' && htmlNode2.getAttribute(k)){
                    this.api.getModuleViews(htmlNode2.getAttribute(k)).then((result)=>{
                        let viewsOption =[{id:"",name:"选择"}];
                        if(result.indexOf("datas")!=-1)
                        con.propValues.viewsoptions = viewsOption.concat(JSON.parse(result).data.datas);
                    })
                    con.propValues[k]=htmlNode2.getAttribute(k)

                }else if(k == 'dialogview' && htmlNode2.getAttribute(k)){
                    this.api.getViewsColumnsList(htmlNode2.getAttribute(k)).then((result)=>{
                        let mapOption=[{id:"",name:"选择"}];
                        if(result.indexOf("data")!=-1)
                        mapOption =mapOption.concat(JSON.parse(result).data);
                        con.propValues.optionstextoptions=mapOption;
                        
                    })
                    con.propValues[k]=htmlNode2.getAttribute(k)

                }else if(k == 'processprevalue' || k == 'viewsoptions' || k == 'optionstextoptions'){
                }else if(k == 'targetlist'){
                    con.propValues[k].formselect=htmlNode2.getAttribute(k).split("|")[0];
                    con.propValues[k].moduleselect=htmlNode2.getAttribute(k).split("|")[1];
                }else if(k == 'dispatcherparams'){
                    let value=htmlNode2.getAttribute(k).replace("/\[|\]/g",'')
                    str=JSON.parse(StringUtil.dencodeHTML(value));
                    con.propValues[k]=str;
                }else if(k == 'relstr'){
                    str=JSON.parse(StringUtil.encodeHTMLno(htmlNode2.getAttribute(k).replace(/'/g,'"')));
                    str.forEach(elm=>{
                        if(elm.type=='form'){
                            this.api.getFormsList(elm.moduleId,2).then((result)=>{
                                if(result.indexOf("data")!=-1){
                                    let formsOptions =[{id:"",name:"选择"}]
                                    elm.formsOptions=formsOptions.concat(JSON.parse(result).data);  

                                }
                            })
                        }else if(elm.type=='view'){
                            this.api.getModuleViews(elm.moduleId).then((result)=>{
                                let viewsOption =[{id:"",name:"选择"}]
                                if(result.indexOf("datas")!=-1)
                                elm.formsOptions= viewsOption.concat(JSON.parse(result).data.datas)
                            
                            })
                        }
                        elm.hiddenScript=StringUtil.dencodeHTML(elm.hiddenScript);
                        elm.readOnlyScript=StringUtil.dencodeHTML(elm.readOnlyScript)
                        elm.hiddenPrintScript=StringUtil.dencodeHTML(elm.hiddenPrintScript)

                    })
                    con.propValues[k]=str;
                }else if(k =='inputwidth' || k =='textareaheight' || k=='myselfrows'){
                    con.propValues[k]=parseInt(htmlNode2.getAttribute(k));

                }else{
                    if(htmlNode2.getAttribute(k)=='false')
                    con.propValues[k]=false;
                    else if(htmlNode2.getAttribute(k)=='true')
                    con.propValues[k]=true;
                    else
                    con.propValues[k]=htmlNode2.getAttribute(k)
                }
                
            }
        }
        //con.style=con.panel.getAttribute('style')
        let arr = htmlNode2.getAttribute('style').split(';');
        for(let i=0;i<arr.length;i++){
            if(arr[i].split(":")[0]==' background-color'&&arr[i].split(":")[1]==' rgb(235, 248, 251)')con.isChecked=true;else con.isChecked=false
            
            if(arr[i].split(":")[0]&&arr[i].split(":")[1])
            con.style[arr[i].split(":")[0].replace(/\s*/,'')]=arr[i].split(":")[1].replace(/^\s/,'')
        }

    }
    //重置属性面板之前对当前已选择的元素进行校验属性是否合法
    checkField(){
        let checked=null;
        let result=true;
        if(window.formApp.allElements.length>0){
            for(let i=0;i<window.formApp.allElements.length;i++){
                if(window.formApp.allElements[i].isChecked){
                    checked=window.formApp.allElements[i];
                    break;
                }
            }
            if(checked){
                result = checked.checkSelf();
            }
        }
        return result;
    }
    //判断鼠标按下的位置是否在自己的区域内
    // isInMyarea(x,y){
    //     if(x>this.x && x<this.x+this.width && y>this.y && y<this.y+this.height){
    //         this.isinmyarea = true;
    //         return true;
    //     }else{
    //         this.isinmyarea = false;
    //         return false; 
    //     }
    // }
    /** 
     * 删除window。top.formapp.allelement里面存的
    */
    delWindowElem(id){
        let index=null;
        for(let i=0;i<window.formApp.allElements.length;i++){
            if(window.formApp.allElements[i].propValues.id==id){
                index=i;
            }
        } 
        if(index!=null){
            window.formApp.allElements.splice(index,1);
            if(window.formApp.formPanel.childs.length==0&&window.formApp.allElements.length==0){
                window.formApp.formPanel.htmlDOM.setAttribute("class","empty");
            }
        }
    }
    /**
     * 属性面板的重置统一调用
     */
    renderPropsPanel(propsDesc,propValues,scope=""){
        window.formApp.propsPanel.propsDesc = propsDesc;
        window.formApp.propsPanel.propValues = propValues;
        window.formApp.propsPanel.render(scope);
    }
    //单独对nameIndex属性进行设置
    setnameIndex(){
        window.formApp.formPanel.propValues.nameIndex++;
        window.formApp.formPanel.htmlDOM.setAttribute('nameIndex',window.formApp.formPanel.propValues.nameIndex)
    }
    //判断是不是tab-content的子孙节点
    checkParent(target){
        let result=target;
        while(result.tagName!='TAB-CONTENT' && result.tagName!='BODY'){
            result=target.parentNode;
        }
        if(result.tagName=='TAB-CONTENT'){
            return 'TAB-CONTENT'
        }else{
            return false;
        }

    }
    
}
export default AbstractElement;