module.exports = {
    "env": {
        "browser": true,
        "es6": true
    },
    "extends": "eslint:recommended",
    "globals": {
        "Atomics": "readonly",
        "SharedArrayBuffer": "readonly"
    },
    "parserOptions": {
        "ecmaFeatures": {
            "jsx": true
        },
        "ecmaVersion": 2018,
        "sourceType": "module"
    },
    "rules": {
        "no-dupe-args": 2, //函数参数不能重复
        "no-console": 2, //不禁用console
        "no-invalid-this": 2, //禁止无效的this，只能用在构造器，类，对象字面量
        "no-mixed-spaces-and-tabs": 2, //禁止混用tab和空格
        "no-lone-blocks": 0, //禁止不必要的嵌套块
    },
    "settings": {
        "import/ignore": [
            "node_modules"
        ]
    }
};